/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.core.pattern.TextRenderer;
import org.apache.logging.log4j.status.StatusLogger;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiRenderer;

public final class JAnsiTextRenderer
implements TextRenderer {
    public static final Map<String, AnsiRenderer.Code[]> DefaultExceptionStyleMap;
    static final Map<String, AnsiRenderer.Code[]> DefaultMessageStyleMap;
    private static final Map<String, Map<String, AnsiRenderer.Code[]>> PrefedinedStyleMaps;
    private final String beginToken;
    private final int beginTokenLen;
    private final String endToken;
    private final int endTokenLen;
    private final Map<String, AnsiRenderer.Code[]> styleMap;

    /*
     * WARNING - void declaration
     */
    private static void put(Map<String, AnsiRenderer.Code[]> map, String name, AnsiRenderer.Code ... codes) {
        void var2_2;
        void var1_1;
        map.put((String)var1_1, (AnsiRenderer.Code[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public JAnsiTextRenderer(String[] formats, Map<String, AnsiRenderer.Code[]> defaultStyleMap) {
        void var3_3;
        void var1_1;
        HashMap<String, AnsiRenderer.Code[]> map;
        String tempBeginToken = "@|";
        String tempEndToken = "|@";
        if (((String[])formats).length > 1) {
            formats = formats[1];
            String[] allStyleAssignmentsArr = formats.split(" ");
            map = new HashMap<String, AnsiRenderer.Code[]>(allStyleAssignmentsArr.length + defaultStyleMap.size());
            map.putAll((Map<String, AnsiRenderer.Code[]>)defaultStyleMap);
            defaultStyleMap = allStyleAssignmentsArr;
            int n = allStyleAssignmentsArr.length;
            block10: for (int i = 0; i < n; ++i) {
                String styleAssignmentStr = defaultStyleMap[i];
                Object styleAssignmentArr = styleAssignmentStr.split("=");
                if (((String[])styleAssignmentArr).length != 2) {
                    StatusLogger.getLogger().warn("{} parsing style \"{}\", expected format: StyleName=Code(,Code)*", (Object)this.getClass().getSimpleName(), (Object)styleAssignmentStr);
                    continue;
                }
                String styleName = styleAssignmentArr[0];
                String[] codeNames = (styleAssignmentArr = styleAssignmentArr[1]).split(",");
                if (codeNames.length == 0) {
                    StatusLogger.getLogger().warn("{} parsing style \"{}\", expected format: StyleName=Code(,Code)*", (Object)this.getClass().getSimpleName(), (Object)styleAssignmentStr);
                    continue;
                }
                switch (styleName) {
                    case "BeginToken": {
                        tempBeginToken = codeNames[0];
                        continue block10;
                    }
                    case "EndToken": {
                        tempEndToken = codeNames[0];
                        continue block10;
                    }
                    case "StyleMapName": {
                        String predefinedMapName = codeNames[0];
                        Map<String, AnsiRenderer.Code[]> predefinedMap = PrefedinedStyleMaps.get(predefinedMapName);
                        if (predefinedMap != null) {
                            map.putAll(predefinedMap);
                            continue block10;
                        }
                        StatusLogger.getLogger().warn("Unknown predefined map name {}, pick one of {}", (Object)predefinedMapName, null);
                        continue block10;
                    }
                    default: {
                        void var8_9;
                        AnsiRenderer.Code[] codes = new AnsiRenderer.Code[((void)var8_9).length];
                        for (int i2 = 0; i2 < codes.length; ++i2) {
                            codes[i2] = this.toCode((String)var8_9[i2]);
                        }
                        map.put(styleName, codes);
                    }
                }
            }
        } else {
            void var2_2;
            map = var2_2;
        }
        this.styleMap = var1_1;
        this.beginToken = tempBeginToken;
        this.endToken = tempEndToken;
        this.beginTokenLen = var3_3.length();
        this.endTokenLen = tempEndToken.length();
    }

    public final Map<String, AnsiRenderer.Code[]> getStyleMap() {
        return this.styleMap;
    }

    /*
     * WARNING - void declaration
     */
    private void render(Ansi ansi, AnsiRenderer.Code code) {
        if (code.isColor()) {
            if (code.isBackground()) {
                ansi.bg(code.getColor());
                return;
            }
            ansi.fg(code.getColor());
            return;
        }
        if (code.isAttribute()) {
            void var2_2;
            void var1_1;
            var1_1.a(var2_2.getAttribute());
        }
    }

    private void render(Ansi ansi, AnsiRenderer.Code ... codes) {
        AnsiRenderer.Code[] codeArray = codes;
        int n = codes.length;
        for (int i = 0; i < n; ++i) {
            AnsiRenderer.Code code = codeArray[i];
            this.render(ansi, code);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String render(String text, String ... names) {
        void var1_1;
        void var3_3;
        void var2_2;
        Ansi ansi = Ansi.ansi();
        for (void name : var2_2) {
            AnsiRenderer.Code[] codes = this.styleMap.get(name);
            if (codes != null) {
                this.render(ansi, codes);
                continue;
            }
            this.render(ansi, this.toCode((String)name));
        }
        return var3_3.a((String)var1_1).reset().toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void render(String input, StringBuilder output, String styleName) throws IllegalArgumentException {
        void var3_3;
        void var1_1;
        output.append(this.render((String)var1_1, new String[]{var3_3}));
    }

    @Override
    public final void render(StringBuilder input, StringBuilder output) throws IllegalArgumentException {
        int i = 0;
        while (true) {
            int j22;
            if ((j22 = input.indexOf(this.beginToken, i)) == -1) {
                if (i == 0) {
                    output.append((CharSequence)input);
                    return;
                }
                output.append(input.substring(i, input.length()));
                return;
            }
            output.append(input.substring(i, j22));
            int k = input.indexOf(this.endToken, j22);
            if (k == -1) {
                output.append((CharSequence)input);
                return;
            }
            String j22 = input.substring(j22 += this.beginTokenLen, k);
            String[] items = j22.split(" ", 2);
            if (items.length == 1) {
                output.append((CharSequence)input);
                return;
            }
            String replacement = this.render(items[1], items[0].split(","));
            output.append(replacement);
            var3_3 += this.endTokenLen;
        }
    }

    private AnsiRenderer.Code toCode(String name) {
        return AnsiRenderer.Code.valueOf((String)name.toUpperCase(Locale.ENGLISH));
    }

    public final String toString() {
        return "JAnsiMessageRenderer [beginToken=" + this.beginToken + ", beginTokenLen=" + this.beginTokenLen + ", endToken=" + this.endToken + ", endTokenLen=" + this.endTokenLen + ", styleMap=" + this.styleMap + "]";
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        HashMap hashMap;
        HashMap tempPreDefs = new HashMap();
        HashMap<String, AnsiRenderer.Code[]> map = new HashMap<String, AnsiRenderer.Code[]>();
        JAnsiTextRenderer.put(map, "Prefix", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Name", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "NameMessageSeparator", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Message", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.WHITE, AnsiRenderer.Code.BOLD);
        JAnsiTextRenderer.put(map, "At", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "CauseLabel", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Text", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "More", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Suppressed", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ClassName", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.ClassMethodSeparator", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.MethodName", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.NativeMethod", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.FileName", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "StackTraceElement.LineNumber", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "StackTraceElement.Container", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "StackTraceElement.ContainerSeparator", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.UnknownSource", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Inexact", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Container", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.ContainerSeparator", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Location", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Version", AnsiRenderer.Code.YELLOW);
        DefaultExceptionStyleMap = Collections.unmodifiableMap(map);
        tempPreDefs.put("Spock", DefaultExceptionStyleMap);
        map = new HashMap<String, AnsiRenderer.Code[]>();
        JAnsiTextRenderer.put(map, "Prefix", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Name", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.YELLOW, AnsiRenderer.Code.BOLD);
        JAnsiTextRenderer.put(map, "NameMessageSeparator", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "Message", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.WHITE, AnsiRenderer.Code.BOLD);
        JAnsiTextRenderer.put(map, "At", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "CauseLabel", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Text", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "More", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "Suppressed", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ClassName", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.ClassMethodSeparator", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.MethodName", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.NativeMethod", AnsiRenderer.Code.BG_RED, AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "StackTraceElement.FileName", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "StackTraceElement.LineNumber", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "StackTraceElement.Container", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "StackTraceElement.ContainerSeparator", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "StackTraceElement.UnknownSource", AnsiRenderer.Code.RED);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Inexact", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Container", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.ContainerSeparator", AnsiRenderer.Code.WHITE);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Location", AnsiRenderer.Code.YELLOW);
        JAnsiTextRenderer.put(map, "ExtraClassInfo.Version", AnsiRenderer.Code.YELLOW);
        tempPreDefs.put("Kirk", Collections.unmodifiableMap(hashMap));
        hashMap = new HashMap();
        DefaultMessageStyleMap = Collections.unmodifiableMap(hashMap);
        PrefedinedStyleMaps = Collections.unmodifiableMap(var0);
    }
}

