/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.AnsiConverter;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="highlight", category="Converter")
@ConverterKeys(value={"highlight"})
@PerformanceSensitive(value={"allocation"})
public final class HighlightConverter
extends LogEventPatternConverter
implements AnsiConverter {
    private static final Map<String, String> DEFAULT_STYLES = new HashMap<String, String>();
    private static final Map<String, String> LOGBACK_STYLES = new HashMap<String, String>();
    private static final String STYLE_KEY = "STYLE";
    private static final String STYLE_KEY_DEFAULT = "DEFAULT";
    private static final String STYLE_KEY_LOGBACK = "LOGBACK";
    private static final Map<String, Map<String, String>> STYLES = new HashMap<String, Map<String, String>>();
    private final Map<String, String> levelStyles;
    private final List<PatternFormatter> patternFormatters;
    private final boolean noAnsi;
    private final String defaultStyle;

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> createLevelStyleMap(String[] options) {
        void var1_1;
        Map<String, String> map;
        if (((Object)options).length < 2) {
            return DEFAULT_STYLES;
        }
        options = ((String)options[1]).replaceAll("disableAnsi=(true|false)", "").replaceAll("noConsoleNoAnsi=(true|false)", "");
        Map<String, String> styles = AnsiEscape.createMap((String)options, new String[]{STYLE_KEY});
        HashMap<String, String> levelStyles = new HashMap<String, String>(DEFAULT_STYLES);
        for (Map.Entry entry : map.entrySet()) {
            String key = ((String)entry.getKey()).toUpperCase(Locale.ENGLISH);
            String string = (String)entry.getValue();
            if (STYLE_KEY.equalsIgnoreCase(key)) {
                Map<String, String> enumMap = STYLES.get(string.toUpperCase(Locale.ENGLISH));
                if (enumMap == null) {
                    LOGGER.error("Unknown level style: " + string + ". Use one of " + Arrays.toString(STYLES.keySet().toArray()));
                    continue;
                }
                levelStyles.putAll(enumMap);
                continue;
            }
            Level level = Level.toLevel((String)key, null);
            if (level == null) {
                void var3_4;
                LOGGER.warn("Setting style for yet unknown level name {}", (Object)key);
                levelStyles.put((String)var3_4, string);
                continue;
            }
            levelStyles.put(level.name(), string);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static HighlightConverter newInstance(Configuration config, String[] options) {
        void var2_2;
        void var1_1;
        List<PatternFormatter> list;
        void var3_3;
        if (options.length <= 0) {
            LOGGER.error("Incorrect number of options on style. Expected at least 1, received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on style");
            return null;
        }
        config = PatternLayout.createPatternParser((Configuration)config);
        List<PatternFormatter> formatters = ((PatternParser)config).parse(options[0]);
        boolean disableAnsi = Arrays.toString(options).contains("disableAnsi=true");
        boolean noConsoleNoAnsi = Arrays.toString(options).contains("noConsoleNoAnsi=true");
        boolean hideAnsi = disableAnsi || var3_3 != false && System.console() == null;
        return new HighlightConverter(list, HighlightConverter.createLevelStyleMap((String[])var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private HighlightConverter(List<PatternFormatter> patternFormatters, Map<String, String> levelStyles, boolean noAnsi) {
        super("style", "style");
        void var3_3;
        void var2_2;
        void var1_1;
        this.patternFormatters = var1_1;
        this.levelStyles = var2_2;
        this.defaultStyle = AnsiEscape.getDefaultStyle();
        this.noAnsi = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent event, StringBuilder toAppendTo) {
        boolean empty;
        int start = 0;
        int end = 0;
        String levelStyle = this.levelStyles.get(event.getLevel().name());
        if (!this.noAnsi) {
            start = toAppendTo.length();
            if (levelStyle != null) {
                toAppendTo.append(levelStyle);
            }
            end = toAppendTo.length();
        }
        int size = this.patternFormatters.size();
        for (int i = 0; i < size; ++i) {
            this.patternFormatters.get(i).format(event, toAppendTo);
        }
        boolean bl = empty = toAppendTo.length() == end;
        if (!this.noAnsi) {
            if (empty) {
                void var3_3;
                toAppendTo.setLength((int)var3_3);
                return;
            }
            if (levelStyle != null) {
                void var2_2;
                var2_2.append(this.defaultStyle);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    final String getLevelStyle(Level level) {
        void var1_1;
        return this.levelStyles.get(var1_1.name());
    }

    @Override
    public final boolean handlesThrowable() {
        for (PatternFormatter patternFormatter : this.patternFormatters) {
            if (!patternFormatter.handlesThrowable()) continue;
            return true;
        }
        return false;
    }

    static {
        DEFAULT_STYLES.put(Level.FATAL.name(), AnsiEscape.createSequence("BRIGHT", "RED"));
        DEFAULT_STYLES.put(Level.ERROR.name(), AnsiEscape.createSequence("BRIGHT", "RED"));
        DEFAULT_STYLES.put(Level.WARN.name(), AnsiEscape.createSequence("YELLOW"));
        DEFAULT_STYLES.put(Level.INFO.name(), AnsiEscape.createSequence("GREEN"));
        DEFAULT_STYLES.put(Level.DEBUG.name(), AnsiEscape.createSequence("CYAN"));
        DEFAULT_STYLES.put(Level.TRACE.name(), AnsiEscape.createSequence("BLACK"));
        LOGBACK_STYLES.put(Level.FATAL.name(), AnsiEscape.createSequence("BLINK", "BRIGHT", "RED"));
        LOGBACK_STYLES.put(Level.ERROR.name(), AnsiEscape.createSequence("BRIGHT", "RED"));
        LOGBACK_STYLES.put(Level.WARN.name(), AnsiEscape.createSequence("RED"));
        LOGBACK_STYLES.put(Level.INFO.name(), AnsiEscape.createSequence("BLUE"));
        LOGBACK_STYLES.put(Level.DEBUG.name(), AnsiEscape.createSequence(null));
        LOGBACK_STYLES.put(Level.TRACE.name(), AnsiEscape.createSequence(null));
        STYLES.put(STYLE_KEY_DEFAULT, DEFAULT_STYLES);
        STYLES.put(STYLE_KEY_LOGBACK, LOGBACK_STYLES);
    }
}

