/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public final class FormattingInfo {
    private static final char[] SPACES = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final char[] ZEROS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
    private static final FormattingInfo DEFAULT = new FormattingInfo(false, 0, Integer.MAX_VALUE, true);
    private final int minLength;
    private final int maxLength;
    private final boolean leftAlign;
    private final boolean leftTruncate;
    private final boolean zeroPad;
    public static final FormattingInfo[] EMPTY_ARRAY = new FormattingInfo[0];

    /*
     * WARNING - void declaration
     */
    public FormattingInfo(boolean leftAlign, int minLength, int maxLength, boolean leftTruncate) {
        this((boolean)var1_1, (int)var2_2, (int)var3_3, leftTruncate, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FormattingInfo(boolean leftAlign, int minLength, int maxLength, boolean leftTruncate, boolean zeroPad) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.leftAlign = var1_1;
        this.minLength = var2_2;
        this.maxLength = var3_3;
        this.leftTruncate = leftTruncate;
        this.zeroPad = zeroPad;
    }

    public static FormattingInfo getDefault() {
        return DEFAULT;
    }

    public final boolean isLeftAligned() {
        return this.leftAlign;
    }

    public final boolean isLeftTruncate() {
        return this.leftTruncate;
    }

    public final boolean isZeroPad() {
        return this.zeroPad;
    }

    public final int getMinLength() {
        return this.minLength;
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    /*
     * WARNING - void declaration
     */
    public final void format(int fieldStart, StringBuilder buffer) {
        int rawLength = buffer.length() - fieldStart;
        if (rawLength > this.maxLength) {
            if (this.leftTruncate) {
                buffer.delete(fieldStart, buffer.length() - this.maxLength);
                return;
            }
            buffer.delete(fieldStart + this.maxLength, fieldStart + buffer.length());
            return;
        }
        if (rawLength < this.minLength) {
            void var3_3;
            void var1_1;
            void var2_2;
            char[] paddingArray;
            if (this.leftAlign) {
                int fieldEnd = buffer.length();
                buffer.setLength(fieldStart + this.minLength);
                for (int i = fieldEnd; i < buffer.length(); ++i) {
                    buffer.setCharAt(i, ' ');
                }
                return;
            }
            char[] cArray = paddingArray = this.zeroPad ? ZEROS : SPACES;
            for (int padLength = this.minLength - fieldEnd; padLength > paddingArray.length; padLength -= paddingArray.length) {
                buffer.insert(fieldStart, paddingArray);
            }
            var2_2.insert((int)var1_1, paddingArray, 0, (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[leftAlign=");
        sb.append(this.leftAlign);
        sb.append(", maxLength=");
        sb.append(this.maxLength);
        sb.append(", minLength=");
        sb.append(this.minLength);
        sb.append(", leftTruncate=");
        sb.append(this.leftTruncate);
        sb.append(", zeroPad=");
        sb.append(this.zeroPad);
        sb.append(']');
        return var1_1.toString();
    }
}

