/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public abstract class EqualsBaseReplacementConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;
    private final List<PatternFormatter> substitutionFormatters;
    private final String substitution;
    private final String testString;

    /*
     * WARNING - void declaration
     */
    protected EqualsBaseReplacementConverter(String name, String style, List<PatternFormatter> formatters, String testString, String substitution, PatternParser parser) {
        super((String)var1_1, (String)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.testString = testString;
        this.substitution = substitution;
        this.formatters = var3_3;
        this.substitutionFormatters = substitution.contains("%") ? parser.parse(substitution) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        int initialSize = toAppendTo.length();
        for (int i = 0; i < this.formatters.size(); ++i) {
            PatternFormatter patternFormatter = this.formatters.get(i);
            patternFormatter.format(event, toAppendTo);
        }
        EqualsBaseReplacementConverter equalsBaseReplacementConverter = this;
        if (equalsBaseReplacementConverter.equals(equalsBaseReplacementConverter.testString, toAppendTo, initialSize, toAppendTo.length() - initialSize)) {
            void var2_2;
            void var1_1;
            void var3_3;
            toAppendTo.setLength((int)var3_3);
            this.parseSubstitution((LogEvent)var1_1, (StringBuilder)var2_2);
        }
    }

    protected abstract boolean equals(String var1, StringBuilder var2, int var3, int var4);

    /*
     * WARNING - void declaration
     */
    void parseSubstitution(LogEvent event, StringBuilder substitutionBuffer) {
        void var2_2;
        if (this.substitutionFormatters != null) {
            for (int i = 0; i < this.substitutionFormatters.size(); ++i) {
                PatternFormatter patternFormatter = this.substitutionFormatters.get(i);
                patternFormatter.format(event, substitutionBuffer);
            }
            return;
        }
        var2_2.append(this.substitution);
    }
}

