/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StringBuilders;

@Plugin(name="encode", category="Converter")
@ConverterKeys(value={"enc", "encode"})
@PerformanceSensitive(value={"allocation"})
public final class EncodingPatternConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;
    private final EscapeFormat escapeFormat;

    /*
     * WARNING - void declaration
     */
    private EncodingPatternConverter(List<PatternFormatter> formatters, EscapeFormat escapeFormat) {
        super("encode", "encode");
        void var2_2;
        void var1_1;
        this.formatters = var1_1;
        this.escapeFormat = var2_2;
    }

    @Override
    public final boolean handlesThrowable() {
        return this.formatters != null && this.formatters.stream().map(PatternFormatter::getConverter).anyMatch(LogEventPatternConverter::handlesThrowable);
    }

    /*
     * WARNING - void declaration
     */
    public static EncodingPatternConverter newInstance(Configuration config, String[] options) {
        void var2_2;
        List<PatternFormatter> list;
        void var1_1;
        if (options.length > 2 || options.length == 0) {
            LOGGER.error("Incorrect number of options on escape. Expected 1 or 2, but received {}", (Object)options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on escape");
            return null;
        }
        EscapeFormat escapeFormat = options.length < 2 ? EscapeFormat.HTML : (EscapeFormat)EnglishEnums.valueOf(EscapeFormat.class, (String)options[1], (Enum)EscapeFormat.HTML);
        config = PatternLayout.createPatternParser((Configuration)config);
        List<PatternFormatter> formatters = ((PatternParser)config).parse((String)var1_1[0]);
        return new EncodingPatternConverter(list, (EscapeFormat)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent event, StringBuilder toAppendTo) {
        void var3_3;
        void var2_2;
        int start = toAppendTo.length();
        for (int i = 0; i < this.formatters.size(); ++i) {
            this.formatters.get(i).format(event, toAppendTo);
        }
        this.escapeFormat.escape((StringBuilder)var2_2, (int)var3_3);
    }

    private static enum EscapeFormat {
        HTML{

            @Override
            final void escape(StringBuilder toAppendTo, int start) {
                int i;
                int origLength;
                int firstSpecialChar = origLength = toAppendTo.length();
                for (i = origLength - 1; i >= start; --i) {
                    char c = toAppendTo.charAt(i);
                    String escaped = this.escapeChar(c);
                    if (escaped == null) continue;
                    firstSpecialChar = i;
                    for (int j = 0; j < escaped.length() - 1; ++j) {
                        toAppendTo.append(' ');
                    }
                }
                int j = toAppendTo.length();
                for (i = var3_3 - true; i >= firstSpecialChar; --i) {
                    char c = toAppendTo.charAt(i);
                    String escaped = this.escapeChar(c);
                    if (escaped == null) {
                        toAppendTo.setCharAt(--j, c);
                        continue;
                    }
                    toAppendTo.replace(j - escaped.length(), j, escaped);
                    j -= escaped.length();
                }
            }

            private String escapeChar(char c) {
                switch (c) {
                    case '\r': {
                        return "\\r";
                    }
                    case '\n': {
                        return "\\n";
                    }
                    case '&': {
                        return "&amp;";
                    }
                    case '<': {
                        return "&lt;";
                    }
                    case '>': {
                        return "&gt;";
                    }
                    case '\"': {
                        return "&quot;";
                    }
                    case '\'': {
                        return "&apos;";
                    }
                    case '/': {
                        return "&#x2F;";
                    }
                }
                return null;
            }
        }
        ,
        JSON{

            /*
             * WARNING - void declaration
             */
            @Override
            final void escape(StringBuilder toAppendTo, int start) {
                void var2_2;
                StringBuilders.escapeJson((StringBuilder)toAppendTo, (int)var2_2);
            }
        }
        ,
        CRLF{

            /*
             * WARNING - void declaration
             */
            @Override
            final void escape(StringBuilder toAppendTo, int start) {
                int i;
                int origLength;
                int firstSpecialChar = origLength = toAppendTo.length();
                for (i = origLength - 1; i >= start; --i) {
                    char c = toAppendTo.charAt(i);
                    if (c != '\r' && c != '\n') continue;
                    firstSpecialChar = i;
                    toAppendTo.append(' ');
                }
                int j = toAppendTo.length();
                block5: for (i = var3_3 - true; i >= firstSpecialChar; --i) {
                    char c = toAppendTo.charAt(i);
                    switch (c) {
                        case '\r': {
                            toAppendTo.setCharAt(--j, 'r');
                            toAppendTo.setCharAt(--j, '\\');
                            continue block5;
                        }
                        case '\n': {
                            toAppendTo.setCharAt(--j, 'n');
                            toAppendTo.setCharAt(--j, '\\');
                            continue block5;
                        }
                        default: {
                            void var2_2;
                            toAppendTo.setCharAt(--j, (char)var2_2);
                        }
                    }
                }
            }
        }
        ,
        XML{

            /*
             * WARNING - void declaration
             */
            @Override
            final void escape(StringBuilder toAppendTo, int start) {
                void var2_2;
                StringBuilders.escapeXml((StringBuilder)toAppendTo, (int)var2_2);
            }
        };


        abstract void escape(StringBuilder var1, int var2);
    }
}

