/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.pattern.NameAbbreviator;

class DynamicWordAbbreviator
extends NameAbbreviator {
    private final int rightWordCount;

    static DynamicWordAbbreviator create(String pattern) {
        Object matcher;
        if (pattern != null && ((Matcher)(matcher = Pattern.compile("1\\.([1-9][0-9]*)\\*").matcher(pattern))).matches()) {
            Object object;
            return new DynamicWordAbbreviator(Integer.parseInt(((Matcher)object).group(1)));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private DynamicWordAbbreviator(int rightWordCount) {
        void var1_1;
        this.rightWordCount = var1_1;
    }

    @Override
    public void abbreviate(String original, StringBuilder destination) {
        if (original == null || destination == null) {
            return;
        }
        String[] words = DynamicWordAbbreviator.split(original, '.');
        int wordCount = words.length;
        if (this.rightWordCount >= wordCount) {
            destination.append(original);
            return;
        }
        int lastAbbrevIdx = wordCount - this.rightWordCount;
        for (int i = 0; i < wordCount; ++i) {
            if (i >= lastAbbrevIdx) {
                destination.append(words[i]);
                if (i >= wordCount - 1) continue;
                destination.append(".");
                continue;
            }
            if (words[i].length() <= 0) continue;
            destination.append(words[i].charAt(0)).append(".");
        }
    }

    /*
     * WARNING - void declaration
     */
    static String[] split(String input, char delim) {
        void var2_3;
        int idxDelim;
        if (input == null) {
            return null;
        }
        if (input.isEmpty()) {
            return new String[0];
        }
        int n = input.chars().filter(c -> {
            char c2;
            return c == c2;
        }).map(c -> 1).sum();
        String[] tokens = new String[n + 1];
        int countToken = 0;
        int idxBegin = 0;
        while ((idxDelim = input.indexOf(delim, idxBegin)) >= 0) {
            if (idxBegin < idxDelim) {
                tokens[countToken++] = input.substring(idxBegin, idxDelim);
            }
            idxBegin = idxDelim + 1;
        }
        if (idxBegin < input.length()) {
            String string;
            tokens[countToken++] = string.substring(idxBegin);
        }
        if (countToken < tokens.length) {
            void var3_4;
            return Arrays.copyOf(tokens, (int)var3_4);
        }
        return var2_3;
    }
}

