/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="DatePatternConverter", category="Converter")
@ConverterKeys(value={"d", "date"})
@PerformanceSensitive(value={"allocation"})
public final class DatePatternConverter
extends LogEventPatternConverter
implements ArrayPatternConverter {
    private static final String UNIX_FORMAT = "UNIX";
    private static final String UNIX_MILLIS_FORMAT = "UNIX_MILLIS";
    private final String[] options;
    private final ThreadLocal<MutableInstant> threadLocalMutableInstant = new ThreadLocal();
    private final ThreadLocal<Formatter> threadLocalFormatter = new ThreadLocal();
    private final AtomicReference<CachedTime> cachedTime;
    private final Formatter formatter;

    /*
     * WARNING - void declaration
     */
    private DatePatternConverter(String[] options) {
        super("Date", "date");
        void var1_1;
        this.options = options == null ? null : Arrays.copyOf(options, options.length);
        this.formatter = this.createFormatter((String[])var1_1);
        this.cachedTime = new AtomicReference<CachedTime>(this.fromEpochMillis(System.currentTimeMillis()));
    }

    /*
     * WARNING - void declaration
     */
    private CachedTime fromEpochMillis(long epochMillis) {
        void var3_2;
        void var1_1;
        MutableInstant temp = new MutableInstant();
        temp.initFromEpochMilli((long)var1_1, 0);
        return new CachedTime((Instant)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private Formatter createFormatter(String[] options) {
        void var1_1;
        FixedDateFormat fixedDateFormat = FixedDateFormat.createIfSupported(options);
        if (fixedDateFormat != null) {
            void var2_2;
            return DatePatternConverter.createFixedFormatter((FixedDateFormat)var2_2);
        }
        return DatePatternConverter.createNonFixedFormatter((String[])var1_1);
    }

    public static DatePatternConverter newInstance(String[] options) {
        String[] stringArray;
        return new DatePatternConverter(stringArray);
    }

    private static Formatter createFixedFormatter(FixedDateFormat fixedDateFormat) {
        FixedDateFormat fixedDateFormat2;
        return new FixedFormatter(fixedDateFormat2);
    }

    /*
     * WARNING - void declaration
     */
    private static Formatter createNonFixedFormatter(String[] options) {
        Objects.requireNonNull(options);
        if (options.length == 0) {
            throw new IllegalArgumentException("Options array must have at least one element");
        }
        Objects.requireNonNull(options[0]);
        String patternOption = options[0];
        if (UNIX_FORMAT.equals(patternOption)) {
            return new UnixFormatter();
        }
        if (UNIX_MILLIS_FORMAT.equals(patternOption)) {
            return new UnixMillisFormatter();
        }
        FixedDateFormat.FixedFormat fixedFormat = FixedDateFormat.FixedFormat.lookup(patternOption);
        String pattern = fixedFormat == null ? patternOption : fixedFormat.getPattern();
        TimeZone tz = null;
        if (options.length > 1 && options[1] != null) {
            tz = TimeZone.getTimeZone(options[1]);
        }
        Locale locale = null;
        if (options.length > 2 && options[2] != null) {
            locale = Locale.forLanguageTag(options[2]);
        }
        try {
            void var3_4;
            Object tempFormat = FastDateFormat.getInstance(pattern, tz, (Locale)var3_4);
            return new PatternFormatter((FastDateFormat)tempFormat);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            void var0_1;
            void var1_2;
            LOGGER.warn("Could not instantiate FastDateFormat with pattern " + (String)var1_2, (Throwable)var0_1);
            return DatePatternConverter.createFixedFormatter(FixedDateFormat.create(FixedDateFormat.FixedFormat.DEFAULT, (TimeZone)var2_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void format(Date date, StringBuilder toAppendTo) {
        void var2_2;
        void var1_1;
        this.format(var1_1.getTime(), (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent event, StringBuilder output) {
        void var2_2;
        void var1_1;
        this.format(var1_1.getInstant(), (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void format(long epochMilli, StringBuilder output) {
        void var3_2;
        void var1_1;
        MutableInstant instant = this.getMutableInstant();
        instant.initFromEpochMilli((long)var1_1, 0);
        this.format(instant, (StringBuilder)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private MutableInstant getMutableInstant() {
        if (Constants.ENABLE_THREADLOCALS) {
            void var1_1;
            MutableInstant result = this.threadLocalMutableInstant.get();
            if (result == null) {
                result = new MutableInstant();
                this.threadLocalMutableInstant.set(result);
            }
            return var1_1;
        }
        return new MutableInstant();
    }

    /*
     * WARNING - void declaration
     */
    public final void format(Instant instant, StringBuilder output) {
        void var2_2;
        void var1_1;
        if (Constants.ENABLE_THREADLOCALS) {
            this.formatWithoutAllocation(instant, output);
            return;
        }
        this.formatWithoutThreadLocals((Instant)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void formatWithoutAllocation(Instant instant, StringBuilder output) {
        void var2_2;
        void var1_1;
        this.getThreadLocalFormatter().formatToBuffer((Instant)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Formatter getThreadLocalFormatter() {
        void var1_1;
        Formatter result = this.threadLocalFormatter.get();
        if (result == null) {
            DatePatternConverter datePatternConverter = this;
            result = datePatternConverter.createFormatter(datePatternConverter.options);
            this.threadLocalFormatter.set(result);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void formatWithoutThreadLocals(Instant instant, StringBuilder output) {
        void var3_3;
        void var2_2;
        Object cached = this.cachedTime.get();
        if (instant.getEpochSecond() != cached.epochSecond || instant.getNanoOfSecond() != cached.nanoOfSecond) {
            void var1_1;
            CachedTime newTime = new CachedTime(instant);
            cached = this.cachedTime.compareAndSet((CachedTime)cached, newTime) ? var1_1 : this.cachedTime.get();
        }
        var2_2.append(var3_3.formatted);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(Object obj, StringBuilder output) {
        void var2_2;
        void var1_1;
        if (obj instanceof Date) {
            this.format((Date)obj, output);
        }
        super.format(var1_1, (StringBuilder)var2_2);
    }

    @Override
    public final void format(StringBuilder toAppendTo, Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        for (int i = 0; i < n; ++i) {
            Object obj = objectArray[i];
            if (!(obj instanceof Date)) continue;
            ((LogEventPatternConverter)this).format(obj, toAppendTo);
            return;
        }
    }

    public final String getPattern() {
        return this.formatter.toPattern();
    }

    public final TimeZone getTimeZone() {
        return this.formatter.getTimeZone();
    }

    private final class CachedTime {
        public long epochSecond;
        public int nanoOfSecond;
        public String formatted;

        /*
         * WARNING - void declaration
         */
        public CachedTime(Instant instant) {
            void var2_2;
            this.epochSecond = instant.getEpochSecond();
            this.nanoOfSecond = instant.getNanoOfSecond();
            this.formatted = DatePatternConverter.this.formatter.format((Instant)var2_2);
        }
    }

    private static final class UnixMillisFormatter
    extends Formatter {
        private UnixMillisFormatter() {
        }

        @Override
        final String format(Instant instant) {
            return Long.toString(instant.getEpochMillisecond());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void formatToBuffer(Instant instant, StringBuilder destination) {
            void var1_1;
            destination.append(var1_1.getEpochMillisecond());
        }
    }

    private static final class UnixFormatter
    extends Formatter {
        private UnixFormatter() {
        }

        @Override
        final String format(Instant instant) {
            return Long.toString(instant.getEpochSecond());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void formatToBuffer(Instant instant, StringBuilder destination) {
            void var1_1;
            destination.append(var1_1.getEpochSecond());
        }
    }

    private static final class FixedFormatter
    extends Formatter {
        private final FixedDateFormat fixedDateFormat;
        private final char[] cachedBuffer = new char[70];
        private int length = 0;

        /*
         * WARNING - void declaration
         */
        FixedFormatter(FixedDateFormat fixedDateFormat) {
            void var1_1;
            this.fixedDateFormat = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String format(Instant instant) {
            void var1_1;
            return this.fixedDateFormat.formatInstant((Instant)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void formatToBuffer(Instant instant, StringBuilder destination) {
            void var2_2;
            int nanoOfSecond;
            long epochSecond = instant.getEpochSecond();
            if (!this.fixedDateFormat.isEquivalent(this.previousTime, this.nanos, epochSecond, nanoOfSecond = instant.getNanoOfSecond())) {
                void var3_3;
                void var1_1;
                this.length = this.fixedDateFormat.formatInstant((Instant)var1_1, this.cachedBuffer, 0);
                this.previousTime = var3_3;
                this.nanos = nanoOfSecond;
            }
            var2_2.append(this.cachedBuffer, 0, this.length);
        }

        @Override
        public final String toPattern() {
            return this.fixedDateFormat.getFormat();
        }

        @Override
        public final TimeZone getTimeZone() {
            return this.fixedDateFormat.getTimeZone();
        }
    }

    private static final class PatternFormatter
    extends Formatter {
        private final FastDateFormat fastDateFormat;
        private final StringBuilder cachedBuffer = new StringBuilder(64);

        /*
         * WARNING - void declaration
         */
        PatternFormatter(FastDateFormat fastDateFormat) {
            void var1_1;
            this.fastDateFormat = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final String format(Instant instant) {
            void var1_1;
            return this.fastDateFormat.format(var1_1.getEpochMillisecond());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void formatToBuffer(Instant instant, StringBuilder destination) {
            void var2_2;
            long timeMillis = instant.getEpochMillisecond();
            if (this.previousTime != timeMillis) {
                void var3_3;
                this.cachedBuffer.setLength(0);
                this.fastDateFormat.format((long)var3_3, this.cachedBuffer);
            }
            var2_2.append((CharSequence)this.cachedBuffer);
        }

        @Override
        public final String toPattern() {
            return this.fastDateFormat.getPattern();
        }

        @Override
        public final TimeZone getTimeZone() {
            return this.fastDateFormat.getTimeZone();
        }
    }

    private static abstract class Formatter {
        long previousTime;
        int nanos;

        private Formatter() {
        }

        abstract String format(Instant var1);

        abstract void formatToBuffer(Instant var1, StringBuilder var2);

        public String toPattern() {
            return null;
        }

        public TimeZone getTimeZone() {
            return TimeZone.getDefault();
        }
    }
}

