/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.TimeZone;

final class CachedDateFormat
extends DateFormat {
    public static final int NO_MILLISECONDS = -2;
    public static final int UNRECOGNIZED_MILLISECONDS = -1;
    private static final long serialVersionUID = -1253877934598423628L;
    private static final String DIGITS = "0123456789";
    private static final int MAGIC1 = 654;
    private static final String MAGICSTRING1 = "654";
    private static final int MAGIC2 = 987;
    private static final String MAGICSTRING2 = "987";
    private static final String ZERO_STRING = "000";
    private static final int BUF_SIZE = 50;
    private static final int DEFAULT_VALIDITY = 1000;
    private static final int THREE_DIGITS = 100;
    private static final int TWO_DIGITS = 10;
    private static final long SLOTS = 1000L;
    private final DateFormat formatter;
    private int millisecondStart;
    private long slotBegin;
    private final StringBuffer cache = new StringBuffer(50);
    private final int expiration;
    private long previousTime;
    private final Date tmpDate = new Date(0L);

    /*
     * WARNING - void declaration
     */
    public CachedDateFormat(DateFormat dateFormat, int expiration) {
        void var2_2;
        void var1_1;
        if (dateFormat == null) {
            throw new IllegalArgumentException("dateFormat cannot be null");
        }
        if (expiration < 0) {
            throw new IllegalArgumentException("expiration must be non-negative");
        }
        this.formatter = var1_1;
        this.expiration = var2_2;
        this.millisecondStart = 0;
        this.previousTime = Long.MIN_VALUE;
        this.slotBegin = Long.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int findMillisecondStart(long time, String formatted, DateFormat formatter) {
        String plusMagic;
        long slotBegin = time / 1000L * 1000L;
        if (slotBegin > time) {
            slotBegin -= 1000L;
        }
        int millis = (int)(time - slotBegin);
        int magic = 654;
        String magicString = MAGICSTRING1;
        if (millis == 654) {
            magic = 987;
            magicString = MAGICSTRING2;
        }
        if ((plusMagic = formatter.format(new Date(slotBegin + (long)magic))).length() != formatted.length()) {
            return -1;
        }
        for (int i = 0; i < formatted.length(); ++i) {
            void var0_2;
            if (formatted.charAt(i) == plusMagic.charAt(i)) continue;
            StringBuffer formattedMillis = new StringBuffer("ABC");
            CachedDateFormat.millisecondFormat(millis, formattedMillis, 0);
            String plusZero = formatter.format(new Date(slotBegin));
            if (plusZero.length() == formatted.length() && magicString.regionMatches(0, plusMagic, i, magicString.length()) && formattedMillis.toString().regionMatches(0, formatted, i, magicString.length()) && ZERO_STRING.regionMatches(0, (String)var0_2, i, 3)) {
                return i;
            }
            return -1;
        }
        return -2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final StringBuffer format(Date date, StringBuffer sbuf, FieldPosition fieldPosition) {
        void var2_2;
        void var1_1;
        this.format(var1_1.getTime(), sbuf);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final StringBuffer format(long now, StringBuffer buf) {
        void var3_2;
        if (now == this.previousTime) {
            buf.append(this.cache);
            return buf;
        }
        if (this.millisecondStart != -1 && now < this.slotBegin + (long)this.expiration && now >= this.slotBegin && now < this.slotBegin + 1000L) {
            if (this.millisecondStart >= 0) {
                CachedDateFormat.millisecondFormat((int)(now - this.slotBegin), this.cache, this.millisecondStart);
            }
            this.previousTime = now;
            buf.append(this.cache);
            return buf;
        }
        this.cache.setLength(0);
        this.tmpDate.setTime(now);
        this.cache.append(this.formatter.format(this.tmpDate));
        buf.append(this.cache);
        this.previousTime = now;
        this.slotBegin = this.previousTime / 1000L * 1000L;
        if (this.slotBegin > this.previousTime) {
            this.slotBegin -= 1000L;
        }
        if (this.millisecondStart >= 0) {
            void var1_1;
            this.millisecondStart = CachedDateFormat.findMillisecondStart((long)var1_1, this.cache.toString(), this.formatter);
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    private static void millisecondFormat(int millis, StringBuffer buf, int offset) {
        int n;
        void var2_2;
        void var1_1;
        buf.setCharAt(offset, DIGITS.charAt(millis / 100));
        buf.setCharAt(offset + 1, DIGITS.charAt(millis / 10 % 10));
        var1_1.setCharAt((int)(var2_2 + 2), DIGITS.charAt(n % 10));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setTimeZone(TimeZone timeZone) {
        void var1_1;
        this.formatter.setTimeZone((TimeZone)var1_1);
        this.previousTime = Long.MIN_VALUE;
        this.slotBegin = Long.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Date parse(String s, ParsePosition pos) {
        void var2_2;
        void var1_1;
        return this.formatter.parse((String)var1_1, (ParsePosition)var2_2);
    }

    @Override
    public final NumberFormat getNumberFormat() {
        return this.formatter.getNumberFormat();
    }

    /*
     * WARNING - void declaration
     */
    public static int getMaximumCacheValidity(String pattern) {
        String string;
        void var1_1;
        int firstS = pattern.indexOf(83);
        if (firstS >= 0 && var1_1 != string.lastIndexOf("SSS")) {
            return 1;
        }
        return 1000;
    }
}

