/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;

public abstract class AbstractStyleNameConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;
    private final String style;

    /*
     * WARNING - void declaration
     */
    protected AbstractStyleNameConverter(String name, List<PatternFormatter> formatters, String styling) {
        super((String)var1_1, "style");
        void var3_3;
        void var2_2;
        void var1_1;
        this.formatters = var2_2;
        this.style = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected static <T extends AbstractStyleNameConverter> T newInstance(Class<T> asnConverterClass, String name, Configuration config, String[] options) {
        void var3_4;
        List<PatternFormatter> formatters = AbstractStyleNameConverter.toPatternFormatterList(config, (String[])var3_4);
        if (formatters == null) {
            return null;
        }
        try {
            void var1_2;
            void var2_3;
            asnConverterClass = asnConverterClass.getConstructor(List.class, String.class);
            return (T)((AbstractStyleNameConverter)((Constructor)asnConverterClass).newInstance(var2_3, AnsiEscape.createSequence(new String[]{var1_2})));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            void var0_1;
            LOGGER.error(e.toString(), (Throwable)var0_1);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<PatternFormatter> toPatternFormatterList(Configuration config, String[] options) {
        void var1_1;
        void var2_2;
        if (options.length == 0 || options[0] == null) {
            LOGGER.error("No pattern supplied on style for config=" + config);
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser(config);
        if (parser == null) {
            Configuration configuration;
            LOGGER.error("No PatternParser created for config=" + configuration + ", options=" + Arrays.toString(options));
            return null;
        }
        return var2_2.parse((String)var1_1[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @PerformanceSensitive(value={"allocation"})
    public void format(LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        for (int i = 0; i < this.formatters.size(); ++i) {
            PatternFormatter patternFormatter = this.formatters.get(i);
            patternFormatter.format(event, toAppendTo);
        }
        if (toAppendTo.length() > start) {
            void var2_2;
            void var3_3;
            toAppendTo.insert((int)var3_3, this.style);
            var2_2.append(AnsiEscape.getDefaultStyle());
        }
    }

    @Plugin(name="yellow", category="Converter")
    @ConverterKeys(value={"yellow"})
    public static final class Yellow
    extends AbstractStyleNameConverter {
        protected static final String NAME = "yellow";

        /*
         * WARNING - void declaration
         */
        public Yellow(List<PatternFormatter> formatters, String styling) {
            super(NAME, (List<PatternFormatter>)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static Yellow newInstance(Configuration config, String[] options) {
            void var1_1;
            Configuration configuration;
            return Yellow.newInstance(Yellow.class, NAME, configuration, (String[])var1_1);
        }
    }

    @Plugin(name="white", category="Converter")
    @ConverterKeys(value={"white"})
    public static final class White
    extends AbstractStyleNameConverter {
        protected static final String NAME = "white";

        /*
         * WARNING - void declaration
         */
        public White(List<PatternFormatter> formatters, String styling) {
            super(NAME, (List<PatternFormatter>)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static White newInstance(Configuration config, String[] options) {
            void var1_1;
            Configuration configuration;
            return White.newInstance(White.class, NAME, configuration, (String[])var1_1);
        }
    }

    @Plugin(name="red", category="Converter")
    @ConverterKeys(value={"red"})
    public static final class Red
    extends AbstractStyleNameConverter {
        protected static final String NAME = "red";

        /*
         * WARNING - void declaration
         */
        public Red(List<PatternFormatter> formatters, String styling) {
            super(NAME, (List<PatternFormatter>)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static Red newInstance(Configuration config, String[] options) {
            void var1_1;
            Configuration configuration;
            return Red.newInstance(Red.class, NAME, configuration, (String[])var1_1);
        }
    }

    @Plugin(name="magenta", category="Converter")
    @ConverterKeys(value={"magenta"})
    public static final class Magenta
    extends AbstractStyleNameConverter {
        protected static final String NAME = "magenta";

        /*
         * WARNING - void declaration
         */
        public Magenta(List<PatternFormatter> formatters, String styling) {
            super(NAME, (List<PatternFormatter>)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static Magenta newInstance(Configuration config, String[] options) {
            void var1_1;
            Configuration configuration;
            return Magenta.newInstance(Magenta.class, NAME, configuration, (String[])var1_1);
        }
    }

    @Plugin(name="green", category="Converter")
    @ConverterKeys(value={"green"})
    public static final class Green
    extends AbstractStyleNameConverter {
        protected static final String NAME = "green";

        /*
         * WARNING - void declaration
         */
        public Green(List<PatternFormatter> formatters, String styling) {
            super(NAME, (List<PatternFormatter>)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static Green newInstance(Configuration config, String[] options) {
            void var1_1;
            Configuration configuration;
            return Green.newInstance(Green.class, NAME, configuration, (String[])var1_1);
        }
    }

    @Plugin(name="cyan", category="Converter")
    @ConverterKeys(value={"cyan"})
    public static final class Cyan
    extends AbstractStyleNameConverter {
        protected static final String NAME = "cyan";

        /*
         * WARNING - void declaration
         */
        public Cyan(List<PatternFormatter> formatters, String styling) {
            super(NAME, (List<PatternFormatter>)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static Cyan newInstance(Configuration config, String[] options) {
            void var1_1;
            Configuration configuration;
            return Cyan.newInstance(Cyan.class, NAME, configuration, (String[])var1_1);
        }
    }

    @Plugin(name="blue", category="Converter")
    @ConverterKeys(value={"blue"})
    public static final class Blue
    extends AbstractStyleNameConverter {
        protected static final String NAME = "blue";

        /*
         * WARNING - void declaration
         */
        public Blue(List<PatternFormatter> formatters, String styling) {
            super(NAME, (List<PatternFormatter>)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static Blue newInstance(Configuration config, String[] options) {
            void var1_1;
            Configuration configuration;
            return Blue.newInstance(Blue.class, NAME, configuration, (String[])var1_1);
        }
    }

    @Plugin(name="black", category="Converter")
    @ConverterKeys(value={"black"})
    public static final class Black
    extends AbstractStyleNameConverter {
        protected static final String NAME = "black";

        /*
         * WARNING - void declaration
         */
        public Black(List<PatternFormatter> formatters, String styling) {
            super(NAME, (List<PatternFormatter>)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static Black newInstance(Configuration config, String[] options) {
            void var1_1;
            Configuration configuration;
            return Black.newInstance(Black.class, NAME, configuration, (String[])var1_1);
        }
    }
}

