/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.osgi;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.selector.ClassLoaderContextSelector;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;

public class BundleContextSelector
extends ClassLoaderContextSelector {
    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdown(String fqcn, ClassLoader loader, boolean currentContext, boolean allContexts) {
        Bundle[] bundleArray;
        Class callerClass;
        int n;
        LoggerContext ctx = null;
        Bundle bundle = null;
        if (n != 0) {
            ctx = ContextAnchor.THREAD_CONTEXT.get();
            ContextAnchor.THREAD_CONTEXT.remove();
        }
        if (ctx == null && loader instanceof BundleReference) {
            void var2_2;
            bundle = ((BundleReference)var2_2).getBundle();
            ctx = this.getLoggerContext(bundle);
            this.removeLoggerContext(ctx);
        }
        if (ctx == null && (callerClass = StackLocatorUtil.getCallerClass((String)fqcn)) != null) {
            bundle = FrameworkUtil.getBundle((Class)callerClass);
            ctx = this.getLoggerContext(FrameworkUtil.getBundle((Class)bundleArray));
            this.removeLoggerContext(ctx);
        }
        if (ctx == null) {
            ctx = ContextAnchor.THREAD_CONTEXT.get();
            ContextAnchor.THREAD_CONTEXT.remove();
        }
        if (ctx != null) {
            ((AbstractLifeCycle)ctx).stop(50L, TimeUnit.MILLISECONDS);
        }
        if (bundle != null && allContexts) {
            Bundle[] bundleArray2 = bundle.getBundleContext().getBundles();
            bundleArray = bundleArray2;
            bundleArray = bundleArray2;
            int n2 = bundleArray2.length;
            for (n = 0; n < n2; ++n) {
                Bundle bdl = bundleArray[n];
                ctx = this.getLoggerContext(bdl);
                if (ctx == null) continue;
                ((AbstractLifeCycle)ctx).stop(50L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private LoggerContext getLoggerContext(Bundle bundle) {
        String name = Objects.requireNonNull(bundle, "No Bundle provided").getSymbolicName();
        AtomicReference ref = (AtomicReference)CONTEXT_MAP.get(name);
        if (ref != null && ref.get() != null) {
            void var1_1;
            return (LoggerContext)((WeakReference)var1_1.get()).get();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void removeLoggerContext(LoggerContext context) {
        void var1_1;
        CONTEXT_MAP.remove(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasContext(String fqcn, ClassLoader loader, boolean currentContext) {
        if (currentContext && ContextAnchor.THREAD_CONTEXT.get() != null) {
            return ContextAnchor.THREAD_CONTEXT.get().isStarted();
        }
        if (loader instanceof BundleReference) {
            void var2_2;
            return BundleContextSelector.hasContext(((BundleReference)var2_2).getBundle());
        }
        Class callerClass = StackLocatorUtil.getCallerClass((String)fqcn);
        if (callerClass != null) {
            void var1_1;
            return BundleContextSelector.hasContext(FrameworkUtil.getBundle((Class)var1_1));
        }
        return ContextAnchor.THREAD_CONTEXT.get() != null && ContextAnchor.THREAD_CONTEXT.get().isStarted();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation) {
        void var1_1;
        LoggerContext ctx;
        if (currentContext) {
            ctx = ContextAnchor.THREAD_CONTEXT.get();
            if (ctx != null) {
                return ctx;
            }
            return this.getDefault();
        }
        if (loader instanceof BundleReference) {
            void var2_2;
            return BundleContextSelector.locateContext(((BundleReference)var2_2).getBundle(), configLocation);
        }
        Class callerClass = StackLocatorUtil.getCallerClass((String)((Object)ctx));
        if (callerClass != null) {
            return BundleContextSelector.locateContext(FrameworkUtil.getBundle((Class)callerClass), configLocation);
        }
        LoggerContext lc = ContextAnchor.THREAD_CONTEXT.get();
        if (lc == null) {
            return this.getDefault();
        }
        return var1_1;
    }

    private static boolean hasContext(Bundle bundle) {
        String string;
        String name = Objects.requireNonNull(bundle, "No Bundle provided").getSymbolicName();
        String ref = (AtomicReference)CONTEXT_MAP.get(name);
        return ref != null && ((AtomicReference)((Object)ref)).get() != null && ((WeakReference)((AtomicReference)((Object)ref)).get()).get() != null && ((LoggerContext)((WeakReference)((AtomicReference)((Object)string)).get()).get()).isStarted();
    }

    /*
     * WARNING - void declaration
     */
    private static LoggerContext locateContext(Bundle bundle, URI configLocation) {
        String name = Objects.requireNonNull(bundle, "No Bundle provided").getSymbolicName();
        AtomicReference ref = (AtomicReference)CONTEXT_MAP.get(name);
        if (ref == null) {
            LoggerContext context = new LoggerContext(name, (Object)bundle, configLocation);
            CONTEXT_MAP.putIfAbsent(name, new AtomicReference<WeakReference<LoggerContext>>(new WeakReference<LoggerContext>(context)));
            return (LoggerContext)((WeakReference)((AtomicReference)CONTEXT_MAP.get(name)).get()).get();
        }
        WeakReference r = (WeakReference)ref.get();
        LoggerContext ctx = (LoggerContext)r.get();
        if (ctx == null) {
            void var3_3;
            Object context = new LoggerContext(name, (Object)bundle, configLocation);
            ref.compareAndSet(r, new WeakReference<Bundle>((Bundle)context));
            return (LoggerContext)((WeakReference)var3_3.get()).get();
        }
        Object oldConfigLocation = ctx.getConfigLocation();
        if (oldConfigLocation == null && configLocation != null) {
            void var2_2;
            LOGGER.debug("Setting bundle ({}) configuration to {}", (Object)var2_2, (Object)configLocation);
            ctx.setConfigLocation(configLocation);
        } else if (oldConfigLocation != null && configLocation != null && !configLocation.equals(oldConfigLocation)) {
            Object object;
            void var1_1;
            LOGGER.warn("locateContext called with URI [{}], but existing LoggerContext has URI [{}]", (Object)var1_1, object);
        }
        return ctx;
    }
}

