/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.osgi;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.util.PluginRegistry;
import org.apache.logging.log4j.core.impl.Log4jProvider;
import org.apache.logging.log4j.core.impl.ThreadContextDataInjector;
import org.apache.logging.log4j.core.impl.ThreadContextDataProvider;
import org.apache.logging.log4j.core.osgi.BundleContextSelector;
import org.apache.logging.log4j.core.util.ContextDataProvider;
import org.apache.logging.log4j.spi.Provider;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.ProviderActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleWiring;

public final class Activator
extends ProviderActivator
implements SynchronousBundleListener {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final AtomicReference<BundleContext> contextRef = new AtomicReference();
    private ServiceRegistration<ContextDataProvider> contextDataRegistration = null;

    public Activator() {
        super((Provider)new Log4jProvider());
    }

    /*
     * WARNING - void declaration
     */
    public final void start(BundleContext context) throws Exception {
        void var2_2;
        super.start(context);
        ThreadContextDataProvider threadContextProvider = new ThreadContextDataProvider();
        this.contextDataRegistration = context.registerService(ContextDataProvider.class, (Object)var2_2, null);
        Activator.loadContextProviders(context);
        if (PropertiesUtil.getProperties().getStringProperty("Log4jContextSelector") == null) {
            System.setProperty("Log4jContextSelector", BundleContextSelector.class.getName());
        }
        if (this.contextRef.compareAndSet(null, context)) {
            void var1_1;
            context.addBundleListener((BundleListener)this);
            Activator.scanInstalledBundlesForPlugins((BundleContext)var1_1);
        }
    }

    private static void scanInstalledBundlesForPlugins(BundleContext context) {
        Bundle[] bundleArray = context.getBundles();
        Bundle[] bundleArray2 = bundleArray;
        bundleArray2 = bundleArray;
        int n = bundleArray.length;
        for (int i = 0; i < n; ++i) {
            Bundle bundle = bundleArray2[i];
            Activator.scanBundleForPlugins(bundle);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void scanBundleForPlugins(Bundle bundle) {
        long bundleId = bundle.getBundleId();
        if (bundle.getState() == 32 && bundleId != 0L) {
            Bundle bundle2;
            void var1_1;
            LOGGER.trace("Scanning bundle [{}, id=%d] for plugins.", (Object)bundle.getSymbolicName(), (Object)bundleId);
            PluginRegistry.getInstance().loadFromBundle((long)var1_1, ((BundleWiring)bundle2.adapt(BundleWiring.class)).getClassLoader());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void loadContextProviders(BundleContext bundleContext) {
        try {
            Object object = bundleContext.getServiceReferences(ContextDataProvider.class, null);
            object = object.iterator();
            while (object.hasNext()) {
                void var2_3;
                ServiceReference serviceReference = (ServiceReference)object.next();
                ContextDataProvider provider = (ContextDataProvider)bundleContext.getService(serviceReference);
                ThreadContextDataInjector.contextDataProviders.add((ContextDataProvider)var2_3);
            }
            return;
        }
        catch (InvalidSyntaxException ex) {
            void var1_2;
            LOGGER.error("Error accessing context data provider", (Throwable)var1_2);
            return;
        }
    }

    private static void stopBundlePlugins(Bundle bundle) {
        Bundle bundle2;
        LOGGER.trace("Stopping bundle [{}] plugins.", (Object)bundle.getSymbolicName());
        PluginRegistry.getInstance().clearBundlePlugins(bundle2.getBundleId());
    }

    /*
     * WARNING - void declaration
     */
    public final void stop(BundleContext context) throws Exception {
        void var1_1;
        this.contextDataRegistration.unregister();
        this.contextRef.compareAndSet(context, null);
        LogManager.shutdown();
        super.stop((BundleContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                Activator.scanBundleForPlugins(event.getBundle());
                return;
            }
            case 256: {
                void var1_1;
                Activator.stopBundlePlugins(var1_1.getBundle());
            }
        }
    }
}

