/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.net.ssl.AbstractKeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.EnvironmentPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.FilePasswordProvider;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;

@Plugin(name="TrustStore", category="Core", printObject=true)
public class TrustStoreConfiguration
extends AbstractKeyStoreConfiguration {
    private final String trustManagerFactoryAlgorithm;

    /*
     * WARNING - void declaration
     */
    public TrustStoreConfiguration(String location, PasswordProvider passwordProvider, String keyStoreType, String trustManagerFactoryAlgorithm) throws StoreConfigurationException {
        super((String)var1_1, (PasswordProvider)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm == null ? TrustManagerFactory.getDefaultAlgorithm() : trustManagerFactoryAlgorithm;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public TrustStoreConfiguration(String location, char[] password, String keyStoreType, String trustManagerFactoryAlgorithm) throws StoreConfigurationException {
        this((String)var1_1, new MemoryPasswordProvider(password), (String)var3_3, trustManagerFactoryAlgorithm);
        void var3_3;
        void var1_1;
        if (password != null) {
            void var2_2;
            Arrays.fill((char[])var2_2, '\u0000');
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public TrustStoreConfiguration(String location, String password, String keyStoreType, String trustManagerFactoryAlgorithm) throws StoreConfigurationException {
        this((String)var1_1, new MemoryPasswordProvider(password == null ? null : var2_2.toCharArray()), (String)var3_3, trustManagerFactoryAlgorithm);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static TrustStoreConfiguration createKeyStoreConfiguration(@PluginAttribute(value="location") String location, @PluginAttribute(value="password", sensitive=true) char[] password, @PluginAttribute(value="passwordEnvironmentVariable") String passwordEnvironmentVariable, @PluginAttribute(value="passwordFile") String passwordFile, @PluginAttribute(value="type") String keyStoreType, @PluginAttribute(value="trustManagerFactoryAlgorithm") String trustManagerFactoryAlgorithm) throws StoreConfigurationException {
        if (password != null && passwordEnvironmentVariable != null && passwordFile != null) {
            throw new IllegalStateException("You MUST set only one of 'password', 'passwordEnvironmentVariable' or 'passwordFile'.");
        }
        try {
            String string;
            PasswordProvider provider;
            void var3_4;
            PasswordProvider passwordProvider = passwordFile != null ? new FilePasswordProvider((String)var3_4) : (provider = passwordEnvironmentVariable != null ? new EnvironmentPasswordProvider(passwordEnvironmentVariable) : new MemoryPasswordProvider(password));
            if (password != null) {
                void var1_1;
                Arrays.fill((char[])var1_1, '\u0000');
            }
            return new TrustStoreConfiguration(string, provider, keyStoreType, trustManagerFactoryAlgorithm);
        }
        catch (Exception ex) {
            void var2_3;
            throw new StoreConfigurationException("Could not configure TrustStore", (Exception)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static TrustStoreConfiguration createKeyStoreConfiguration(String location, char[] password, String keyStoreType, String trustManagerFactoryAlgorithm) throws StoreConfigurationException {
        void var3_3;
        void var2_2;
        void var1_1;
        return TrustStoreConfiguration.createKeyStoreConfiguration(location, (char[])var1_1, null, null, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static TrustStoreConfiguration createKeyStoreConfiguration(String location, String password, String keyStoreType, String trustManagerFactoryAlgorithm) throws StoreConfigurationException {
        void var3_3;
        void var2_2;
        void var1_1;
        return TrustStoreConfiguration.createKeyStoreConfiguration(location, password == null ? null : var1_1.toCharArray(), null, null, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public TrustManagerFactory initTrustManagerFactory() throws NoSuchAlgorithmException, KeyStoreException {
        void var1_1;
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(this.trustManagerFactoryAlgorithm);
        tmFactory.init(this.getKeyStore());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = super.hashCode();
        var1_1 = var1_1 * 31 + (this.trustManagerFactoryAlgorithm == null ? 0 : this.trustManagerFactoryAlgorithm.hashCode());
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrustStoreConfiguration other = (TrustStoreConfiguration)obj;
        return Objects.equals(this.trustManagerFactoryAlgorithm, var1_1.trustManagerFactoryAlgorithm);
    }

    public String getTrustManagerFactoryAlgorithm() {
        return this.trustManagerFactoryAlgorithm;
    }
}

