/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.net.ssl.AbstractKeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.EnvironmentPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.FilePasswordProvider;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;

@Plugin(name="KeyStore", category="Core", printObject=true)
public class KeyStoreConfiguration
extends AbstractKeyStoreConfiguration {
    private final String keyManagerFactoryAlgorithm;

    /*
     * WARNING - void declaration
     */
    public KeyStoreConfiguration(String location, PasswordProvider passwordProvider, String keyStoreType, String keyManagerFactoryAlgorithm) throws StoreConfigurationException {
        super((String)var1_1, (PasswordProvider)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm == null ? KeyManagerFactory.getDefaultAlgorithm() : keyManagerFactoryAlgorithm;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public KeyStoreConfiguration(String location, char[] password, String keyStoreType, String keyManagerFactoryAlgorithm) throws StoreConfigurationException {
        this((String)var1_1, new MemoryPasswordProvider(password), (String)var3_3, keyManagerFactoryAlgorithm);
        void var3_3;
        void var1_1;
        if (password != null) {
            void var2_2;
            Arrays.fill((char[])var2_2, '\u0000');
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public KeyStoreConfiguration(String location, String password, String keyStoreType, String keyManagerFactoryAlgorithm) throws StoreConfigurationException {
        this((String)var1_1, new MemoryPasswordProvider(password == null ? null : var2_2.toCharArray()), (String)var3_3, keyManagerFactoryAlgorithm);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static KeyStoreConfiguration createKeyStoreConfiguration(@PluginAttribute(value="location") String location, @PluginAttribute(value="password", sensitive=true) char[] password, @PluginAttribute(value="passwordEnvironmentVariable") String passwordEnvironmentVariable, @PluginAttribute(value="passwordFile") String passwordFile, @PluginAttribute(value="type") String keyStoreType, @PluginAttribute(value="keyManagerFactoryAlgorithm") String keyManagerFactoryAlgorithm) throws StoreConfigurationException {
        if (password != null && passwordEnvironmentVariable != null && passwordFile != null) {
            throw new StoreConfigurationException("You MUST set only one of 'password', 'passwordEnvironmentVariable' or 'passwordFile'.");
        }
        try {
            String string;
            PasswordProvider provider;
            void var3_4;
            PasswordProvider passwordProvider = passwordFile != null ? new FilePasswordProvider((String)var3_4) : (provider = passwordEnvironmentVariable != null ? new EnvironmentPasswordProvider(passwordEnvironmentVariable) : new MemoryPasswordProvider(password));
            if (password != null) {
                void var1_1;
                Arrays.fill((char[])var1_1, '\u0000');
            }
            return new KeyStoreConfiguration(string, provider, keyStoreType, keyManagerFactoryAlgorithm);
        }
        catch (Exception ex) {
            void var2_3;
            throw new StoreConfigurationException("Could not configure KeyStore", (Exception)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static KeyStoreConfiguration createKeyStoreConfiguration(String location, char[] password, String keyStoreType, String keyManagerFactoryAlgorithm) throws StoreConfigurationException {
        void var3_3;
        void var2_2;
        void var1_1;
        return KeyStoreConfiguration.createKeyStoreConfiguration(location, (char[])var1_1, null, null, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static KeyStoreConfiguration createKeyStoreConfiguration(String location, String password, String keyStoreType, String keyManagerFactoryAlgorithm) throws StoreConfigurationException {
        void var3_3;
        void var2_2;
        void var1_1;
        return KeyStoreConfiguration.createKeyStoreConfiguration(location, password == null ? null : var1_1.toCharArray(), (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KeyManagerFactory initKeyManagerFactory() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        void var1_1;
        KeyManagerFactory kmFactory22 = KeyManagerFactory.getInstance(this.keyManagerFactoryAlgorithm);
        char[] password = this.getPasswordAsCharArray();
        try {
            kmFactory22.init(this.getKeyStore(), password);
            if (password == null) return var1_1;
        }
        catch (Throwable kmFactory22) {
            void var2_3;
            if (password == null) throw kmFactory22;
            Arrays.fill((char[])var2_3, '\u0000');
            throw kmFactory22;
        }
        Arrays.fill(password, '\u0000');
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = super.hashCode();
        var1_1 = var1_1 * 31 + (this.keyManagerFactoryAlgorithm == null ? 0 : this.keyManagerFactoryAlgorithm.hashCode());
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyStoreConfiguration other = (KeyStoreConfiguration)obj;
        return Objects.equals(this.keyManagerFactoryAlgorithm, var1_1.keyManagerFactoryAlgorithm);
    }

    public String getKeyManagerFactoryAlgorithm() {
        return this.keyManagerFactoryAlgorithm;
    }
}

