/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;

class FilePasswordProvider
implements PasswordProvider {
    private final Path passwordPath;

    /*
     * WARNING - void declaration
     */
    public FilePasswordProvider(String passwordFile) throws NoSuchFileException {
        this.passwordPath = Paths.get(passwordFile, new String[0]);
        if (!Files.exists(this.passwordPath, new LinkOption[0])) {
            void var1_1;
            throw new NoSuchFileException("PasswordFile '" + (String)var1_1 + "' does not exist");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public char[] getPassword() {
        CharBuffer decoded;
        block5: {
            byte[] bytes = null;
            try {
                void var3_5;
                bytes = Files.readAllBytes(this.passwordPath);
                ByteBuffer bb = ByteBuffer.wrap(bytes);
                decoded = Charset.defaultCharset().decode(bb);
                char[] result = new char[decoded.limit()];
                decoded.get(result, 0, result.length);
                decoded.rewind();
                decoded.put(new char[result.length]);
                decoded = var3_5;
                if (bytes == null) break block5;
            }
            catch (IOException e) {
                try {
                    void var2_3;
                    throw new IllegalStateException("Could not read password from " + this.passwordPath + ": " + e, (Throwable)var2_3);
                }
                catch (Throwable throwable) {
                    if (bytes != null) {
                        void var1_1;
                        Arrays.fill((byte[])var1_1, (byte)0);
                    }
                    throw throwable;
                }
            }
            Arrays.fill(bytes, (byte)0);
        }
        return decoded;
    }
}

