/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationDefaults;
import org.apache.logging.log4j.core.net.ssl.StoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;
import org.apache.logging.log4j.core.util.NetUtils;

public class AbstractKeyStoreConfiguration
extends StoreConfiguration<KeyStore> {
    private final KeyStore keyStore;
    private final String keyStoreType;

    /*
     * WARNING - void declaration
     */
    public AbstractKeyStoreConfiguration(String location, PasswordProvider passwordProvider, String keyStoreType) throws StoreConfigurationException {
        super((String)var1_1, (PasswordProvider)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.keyStoreType = keyStoreType == null ? SslConfigurationDefaults.KEYSTORE_TYPE : var3_3;
        this.keyStore = this.load();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public AbstractKeyStoreConfiguration(String location, char[] password, String keyStoreType) throws StoreConfigurationException {
        this((String)var1_1, new MemoryPasswordProvider((char[])var2_2), (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public AbstractKeyStoreConfiguration(String location, String password, String keyStoreType) throws StoreConfigurationException {
        this((String)var1_1, new MemoryPasswordProvider(password == null ? null : var2_2.toCharArray()), (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    protected KeyStore load() throws StoreConfigurationException {
        Throwable throwable;
        InputStream fin2222;
        Object ks2222;
        char[] password;
        String loadLocation;
        block24: {
            block23: {
                block21: {
                    Object object;
                    block22: {
                        loadLocation = this.getLocation();
                        password = this.getPasswordAsCharArray();
                        LOGGER.debug("Loading keystore from location {}", (Object)loadLocation);
                        ks2222 = KeyStore.getInstance(this.keyStoreType);
                        if (loadLocation != null) break block21;
                        if (this.keyStoreType.equalsIgnoreCase("JKS") || this.keyStoreType.equalsIgnoreCase("PKCS12")) {
                            throw new IOException("The location is null");
                        }
                        ((KeyStore)ks2222).load(null, password);
                        LOGGER.debug("KeyStore successfully loaded");
                        object = ks2222;
                        if (password == null) break block22;
                        Arrays.fill(password, '\u0000');
                    }
                    return object;
                }
                fin2222 = this.openInputStream(loadLocation);
                throwable = null;
                ((KeyStore)ks2222).load(fin2222, password);
                LOGGER.debug("KeyStore successfully loaded from location {}", (Object)loadLocation);
                if (fin2222 == null) break block23;
                fin2222.close();
            }
            if (password == null) break block24;
            Arrays.fill(password, '\u0000');
        }
        return ks2222;
        {
            catch (Throwable throwable2) {
                try {
                    try {
                        try {
                            ks2222 = throwable2;
                            throwable = throwable2;
                            throw ks2222;
                        }
                        catch (Throwable ks2222) {
                            if (fin2222 != null) {
                                if (throwable != null) {
                                    try {
                                        fin2222.close();
                                    }
                                    catch (Throwable fin2222) {
                                        throwable.addSuppressed(fin2222);
                                    }
                                } else {
                                    fin2222.close();
                                }
                            }
                            throw ks2222;
                        }
                    }
                    catch (CertificateException e) {
                        LOGGER.error("No Provider supports a KeyStoreSpi implementation for the specified type {} for location {}", (Object)this.keyStoreType, (Object)loadLocation, (Object)e);
                        throw new StoreConfigurationException(loadLocation, e);
                    }
                    catch (NoSuchAlgorithmException e) {
                        LOGGER.error("The algorithm used to check the integrity of the keystore cannot be found for location {}", (Object)loadLocation, (Object)e);
                        throw new StoreConfigurationException(loadLocation, e);
                    }
                    catch (KeyStoreException e) {
                        LOGGER.error("KeyStoreException for location {}", (Object)loadLocation, (Object)e);
                        throw new StoreConfigurationException(loadLocation, e);
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.error("The keystore file {} is not found", (Object)loadLocation, (Object)e);
                        throw new StoreConfigurationException(loadLocation, e);
                    }
                    catch (IOException e) {
                        void var3_10;
                        void var1_1;
                        LOGGER.error("Something is wrong with the format of the keystore or the given password for location {}", (Object)loadLocation, (Object)e);
                        throw new StoreConfigurationException((String)var1_1, (Exception)var3_10);
                    }
                }
                catch (Throwable throwable3) {
                    if (password != null) {
                        void var2_3;
                        Arrays.fill((char[])var2_3, '\u0000');
                    }
                    throw throwable3;
                }
            }
        }
    }

    private InputStream openInputStream(String filePathOrUri) {
        return ConfigurationSource.fromUri(NetUtils.toURI(filePathOrUri)).getInputStream();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = super.hashCode();
        result = result * 31 + (this.keyStore == null ? 0 : this.keyStore.hashCode());
        var1_1 = var1_1 * 31 + (this.keyStoreType == null ? 0 : this.keyStoreType.hashCode());
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractKeyStoreConfiguration other = (AbstractKeyStoreConfiguration)obj;
        if (!Objects.equals(this.keyStore, other.keyStore)) {
            return false;
        }
        return Objects.equals(this.keyStoreType, var1_1.keyStoreType);
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }
}

