/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.net.ssl.LaxHostnameVerifier;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

public class UrlConnectionFactory {
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int connectTimeoutMillis = 60000;
    private static final int readTimeoutMillis = 60000;
    private static final String JSON = "application/json";
    private static final String XML = "application/xml";
    private static final String PROPERTIES = "text/x-java-properties";
    private static final String TEXT = "text/plain";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String JAR = "jar";
    private static final String DEFAULT_ALLOWED_PROTOCOLS = "https, file, jar";
    private static final String NO_PROTOCOLS = "_none";
    public static final String ALLOWED_PROTOCOLS = "log4j2.Configuration.allowedProtocols";

    /*
     * WARNING - void declaration
     */
    public static <T extends URLConnection> T createConnection(URL url, long lastModifiedMillis, SslConfiguration sslConfiguration, AuthorizationProvider authorizationProvider) throws IOException {
        Object object;
        Object urlConnection;
        PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
        List<String> allowed = Arrays.asList(Strings.splitList((String)propertiesUtil.getStringProperty(ALLOWED_PROTOCOLS, DEFAULT_ALLOWED_PROTOCOLS).toLowerCase(Locale.ROOT)));
        if (allowed.size() == 1 && NO_PROTOCOLS.equals(allowed.get(0))) {
            throw new ProtocolException("No external protocols have been enabled");
        }
        String protocol = url.getProtocol();
        if (protocol == null) {
            throw new ProtocolException("No protocol was specified on " + url.toString());
        }
        if (!allowed.contains(protocol)) {
            throw new ProtocolException("Protocol " + protocol + " has not been enabled as an allowed protocol");
        }
        if (url.getProtocol().equals(HTTP) || url.getProtocol().equals(HTTPS)) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            if (authorizationProvider != null) {
                authorizationProvider.addAuthorization(httpURLConnection);
            }
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setConnectTimeout(60000);
            httpURLConnection.setReadTimeout(60000);
            String[] fileParts = url.getFile().split("\\.");
            String type = fileParts[fileParts.length - 1].trim();
            String contentType = UrlConnectionFactory.isXml(type) ? XML : (UrlConnectionFactory.isJson(type) ? JSON : (UrlConnectionFactory.isProperties(type) ? PROPERTIES : TEXT));
            httpURLConnection.setRequestProperty("Content-Type", contentType);
            if (lastModifiedMillis > 0L) {
                void var1_1;
                httpURLConnection.setIfModifiedSince((long)var1_1);
            }
            if (url.getProtocol().equals(HTTPS) && sslConfiguration != null) {
                void var3_2;
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(sslConfiguration.getSslSocketFactory());
                if (!var3_2.isVerifyHostName()) {
                    ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
                }
            }
            urlConnection = httpURLConnection;
        } else if (((URL)urlConnection).getProtocol().equals(JAR)) {
            urlConnection = ((URL)urlConnection).openConnection();
            ((URLConnection)urlConnection).setUseCaches(false);
        } else {
            urlConnection = ((URL)urlConnection).openConnection();
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public static URLConnection createConnection(URL url) throws IOException {
        Object object;
        Object urlConnection;
        if (url.getProtocol().equals(HTTPS) || url.getProtocol().equals(HTTP)) {
            void var1_1;
            AuthorizationProvider provider = ConfigurationFactory.authorizationProvider(PropertiesUtil.getProperties());
            urlConnection = UrlConnectionFactory.createConnection(url, 0L, SslConfigurationFactory.getSslConfiguration(), (AuthorizationProvider)var1_1);
        } else if ((urlConnection = ((URL)urlConnection).openConnection()) instanceof JarURLConnection) {
            ((URLConnection)urlConnection).setUseCaches(false);
        }
        return object;
    }

    private static boolean isXml(String type) {
        return type.equalsIgnoreCase("xml");
    }

    private static boolean isJson(String type) {
        String string;
        return type.equalsIgnoreCase("json") || string.equalsIgnoreCase("jsn");
    }

    private static boolean isProperties(String type) {
        return type.equalsIgnoreCase("properties");
    }
}

