/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.Log4jThread;
import org.apache.logging.log4j.core.util.NullOutputStream;
import org.apache.logging.log4j.util.Strings;

public class TcpSocketManager
extends AbstractSocketManager {
    public static final int DEFAULT_RECONNECTION_DELAY_MILLIS = 30000;
    private static final int DEFAULT_PORT = 4560;
    private static final TcpSocketManagerFactory<TcpSocketManager, FactoryData> FACTORY = new TcpSocketManagerFactory();
    private final int reconnectionDelayMillis;
    private Reconnector reconnector;
    private Socket socket;
    private final SocketOptions socketOptions;
    private final boolean retry;
    private final boolean immediateFail;
    private final int connectTimeoutMillis;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public TcpSocketManager(String name, OutputStream os, Socket socket, InetAddress inetAddress, String host, int port, int connectTimeoutMillis, int reconnectionDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize) {
        this((String)var1_1, (OutputStream)var2_2, (Socket)var3_3, inetAddress, host, port, connectTimeoutMillis, reconnectionDelayMillis, immediateFail, layout, bufferSize, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TcpSocketManager(String name, OutputStream os, Socket socket, InetAddress inetAddress, String host, int port, int connectTimeoutMillis, int reconnectionDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
        super((String)var1_1, (OutputStream)var2_2, inetAddress, host, port, layout, true, bufferSize);
        void var3_3;
        void var2_2;
        void var1_1;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.reconnectionDelayMillis = reconnectionDelayMillis;
        this.socket = socket;
        this.immediateFail = immediateFail;
        boolean bl = this.retry = reconnectionDelayMillis > 0;
        if (var3_3 == null) {
            this.reconnector = this.createReconnector();
            this.reconnector.start();
        }
        this.socketOptions = socketOptions;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static TcpSocketManager getSocketManager(String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        return TcpSocketManager.getSocketManager(host, (int)var1_1, (int)var2_2, (int)var3_3, immediateFail, layout, bufferSize, null);
    }

    /*
     * WARNING - void declaration
     */
    public static TcpSocketManager getSocketManager(String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        if (Strings.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (port <= 0) {
            port = 4560;
        }
        if (reconnectDelayMillis == 0) {
            reconnectDelayMillis = 30000;
        }
        return (TcpSocketManager)TcpSocketManager.getManager("TCP:" + host + ':' + port, new FactoryData(string, (int)var1_1, (int)var2_2, (int)var3_3, immediateFail, layout, bufferSize, socketOptions), FACTORY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void write(byte[] bytes, int offset, int length, boolean immediateFlush) {
        if (this.socket == null) {
            if (this.reconnector != null && !this.immediateFail) {
                this.reconnector.latch();
            }
            if (this.socket == null) {
                throw new AppenderLoggingException("Error writing to " + this.getName() + ": socket not available");
            }
        }
        TcpSocketManager tcpSocketManager = this;
        synchronized (tcpSocketManager) {
            try {
                this.writeAndFlush(bytes, offset, length, immediateFlush);
            }
            catch (IOException causeEx) {
                void var1_1;
                String config = this.inetAddress + ":" + this.port;
                if (this.retry && this.reconnector == null) {
                    this.reconnector = this.createReconnector();
                    try {
                        this.reconnector.reconnect();
                    }
                    catch (IOException reconnEx) {
                        LOGGER.debug("Cannot reestablish socket connection to {}: {}; starting reconnector thread {}", (Object)config, (Object)reconnEx.getLocalizedMessage(), (Object)this.reconnector.getName(), (Object)reconnEx);
                        this.reconnector.start();
                        throw new AppenderLoggingException(String.format("Error sending to %s for %s", this.getName(), config), causeEx);
                    }
                    try {
                        void var3_5;
                        void var2_4;
                        this.writeAndFlush((byte[])reconnEx, (int)var2_4, (int)var3_5, immediateFlush);
                    }
                    catch (IOException iOException) {
                        throw new AppenderLoggingException(String.format("Error writing to %s after reestablishing connection for %s", this.getName(), config), causeEx);
                    }
                    return;
                }
                String message = String.format("Error writing to %s for connection %s", this.getName(), config);
                throw new AppenderLoggingException((String)var1_1, causeEx);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeAndFlush(byte[] bytes, int offset, int length, boolean immediateFlush) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        OutputStream outputStream = this.getOutputStream();
        outputStream.write((byte[])var1_1, (int)var2_2, (int)var3_3);
        if (immediateFlush) {
            outputStream.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized boolean closeOutputStream() {
        void var1_1;
        boolean closed = super.closeOutputStream();
        if (this.reconnector != null) {
            this.reconnector.shutdown();
            this.reconnector.interrupt();
            this.reconnector = null;
        }
        Socket oldSocket = this.socket;
        this.socket = null;
        if (oldSocket != null) {
            try {
                void var2_2;
                var2_2.close();
            }
            catch (IOException iOException) {
                LOGGER.error("Could not close socket {}", (Object)this.socket);
                return false;
            }
        }
        return (boolean)var1_1;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> getContentFormat() {
        void var1_1;
        HashMap<String, String> result = new HashMap<String, String>(super.getContentFormat());
        result.put("protocol", "tcp");
        result.put("direction", "out");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Reconnector createReconnector() {
        void var1_1;
        TcpSocketManager tcpSocketManager = this;
        Reconnector recon = tcpSocketManager.new Reconnector(tcpSocketManager);
        recon.setDaemon(true);
        recon.setPriority(1);
        return var1_1;
    }

    protected Socket createSocket(InetSocketAddress socketAddress) throws IOException {
        return TcpSocketManager.createSocket(socketAddress, this.socketOptions, this.connectTimeoutMillis);
    }

    /*
     * WARNING - void declaration
     */
    protected static Socket createSocket(InetSocketAddress socketAddress, SocketOptions socketOptions, int connectTimeoutMillis) throws IOException {
        void var3_3;
        void var2_2;
        InetSocketAddress inetSocketAddress;
        LOGGER.debug("Creating socket {}", (Object)socketAddress.toString());
        Socket newSocket = new Socket();
        if (socketOptions != null) {
            socketOptions.apply(newSocket);
        }
        newSocket.connect(inetSocketAddress, (int)var2_2);
        if (socketOptions != null) {
            void var1_1;
            var1_1.apply(newSocket);
        }
        return var3_3;
    }

    public static void setHostResolver(HostResolver resolver) {
        TcpSocketManagerFactory.RESOLVER = resolver;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getReconnectionDelayMillis() {
        return this.reconnectionDelayMillis;
    }

    public String toString() {
        return "TcpSocketManager [reconnectionDelayMillis=" + this.reconnectionDelayMillis + ", reconnector=" + this.reconnector + ", socket=" + this.socket + ", socketOptions=" + this.socketOptions + ", retry=" + this.retry + ", immediateFail=" + this.immediateFail + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", inetAddress=" + this.inetAddress + ", host=" + this.host + ", port=" + this.port + ", layout=" + this.layout + ", byteBuffer=" + this.byteBuffer + ", count=" + this.count + "]";
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$800(TcpSocketManager x0, OutputStream x1) {
        void var1_1;
        x0.setOutputStream((OutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Socket access$602(TcpSocketManager x0, Socket x1) {
        void var1_1;
        x0.socket = var1_1;
        return x0.socket;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Reconnector access$902(TcpSocketManager x0, Reconnector x1) {
        void var1_1;
        x0.reconnector = var1_1;
        return x0.reconnector;
    }

    public static class HostResolver {
        public static final HostResolver INSTANCE = new HostResolver();

        /*
         * WARNING - void declaration
         */
        public List<InetSocketAddress> resolveHost(String host, int port) throws UnknownHostException {
            void var3_3;
            void var1_1;
            InetAddress[] addresses = InetAddress.getAllByName(host);
            ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>(addresses.length);
            for (void address : var1_1) {
                socketAddresses.add(new InetSocketAddress((InetAddress)address, port));
            }
            return var3_3;
        }
    }

    protected static class TcpSocketManagerFactory<M extends TcpSocketManager, T extends FactoryData>
    implements ManagerFactory<M, T> {
        static volatile HostResolver RESOLVER = HostResolver.INSTANCE;

        protected TcpSocketManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public M createManager(String name, T data) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(((FactoryData)data).host);
            }
            catch (UnknownHostException ex) {
                UnknownHostException unknownHostException = ex;
                LOGGER.error("Could not find address of {}: {}", (Object)((FactoryData)data).host, (Object)unknownHostException, (Object)unknownHostException);
                return null;
            }
            Socket socket = null;
            try {
                socket = this.createSocket(data);
                OutputStream os = socket.getOutputStream();
                return this.createManager(name, os, socket, inetAddress, data);
            }
            catch (IOException ex) {
                void var2_2;
                void var3_3;
                void var1_1;
                LOGGER.error("TcpSocketManager ({}) caught exception and will continue:", (Object)name, (Object)ex);
                NullOutputStream os = NullOutputStream.getInstance();
                if (((FactoryData)data).reconnectDelayMillis == 0) {
                    Closer.closeSilently(socket);
                    return null;
                }
                return this.createManager((String)var1_1, os, null, (InetAddress)var3_3, var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        M createManager(String name, OutputStream os, Socket socket, InetAddress inetAddress, T data) {
            void var3_3;
            void var2_2;
            void var1_1;
            return (M)new TcpSocketManager((String)var1_1, (OutputStream)var2_2, (Socket)var3_3, inetAddress, ((FactoryData)data).host, ((FactoryData)data).port, ((FactoryData)data).connectTimeoutMillis, ((FactoryData)data).reconnectDelayMillis, ((FactoryData)data).immediateFail, ((FactoryData)data).layout, ((FactoryData)data).bufferSize, ((FactoryData)data).socketOptions);
        }

        /*
         * WARNING - void declaration
         */
        Socket createSocket(T data) throws IOException {
            void var2_2;
            void var1_1;
            IOException iOException;
            List<InetSocketAddress> socketAddresses = RESOLVER.resolveHost(((FactoryData)data).host, ((FactoryData)data).port);
            Object ioe = null;
            for (InetSocketAddress socketAddress : socketAddresses) {
                try {
                    return TcpSocketManager.createSocket((InetSocketAddress)((Object)iOException), ((FactoryData)data).socketOptions, ((FactoryData)data).connectTimeoutMillis);
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    iOException = iOException2;
                }
            }
            throw new IOException(this.errorMessage(var1_1, (List<InetSocketAddress>)var2_2), iOException);
        }

        /*
         * WARNING - void declaration
         */
        protected String errorMessage(T data, List<InetSocketAddress> socketAddresses) {
            void var3_4;
            StringBuilder sb = new StringBuilder("Unable to create socket for ");
            sb.append(((FactoryData)data).host).append(" at port ").append(((FactoryData)data).port);
            if (socketAddresses.size() == 1) {
                if (!socketAddresses.get(0).getAddress().getHostAddress().equals(((FactoryData)data).host)) {
                    sb.append(" using ip address ").append(socketAddresses.get(0).getAddress().getHostAddress());
                    sb.append(" and port ").append(socketAddresses.get(0).getPort());
                }
            } else {
                sb.append(" using ip addresses and ports ");
                for (int i = 0; i < socketAddresses.size(); ++i) {
                    if (i <= 0) continue;
                    sb.append(", ");
                    sb.append(socketAddresses.get(i).getAddress().getHostAddress());
                    sb.append(":").append(socketAddresses.get(i).getPort());
                }
            }
            return var3_4.toString();
        }
    }

    static class FactoryData {
        protected final String host;
        protected final int port;
        protected final int connectTimeoutMillis;
        protected final int reconnectDelayMillis;
        protected final boolean immediateFail;
        protected final Layout<? extends Serializable> layout;
        protected final int bufferSize;
        protected final SocketOptions socketOptions;

        /*
         * WARNING - void declaration
         */
        public FactoryData(String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.host = var1_1;
            this.port = var2_2;
            this.connectTimeoutMillis = var3_3;
            this.reconnectDelayMillis = reconnectDelayMillis;
            this.immediateFail = immediateFail;
            this.layout = layout;
            this.bufferSize = bufferSize;
            this.socketOptions = socketOptions;
        }

        public String toString() {
            return "FactoryData [host=" + this.host + ", port=" + this.port + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", reconnectDelayMillis=" + this.reconnectDelayMillis + ", immediateFail=" + this.immediateFail + ", layout=" + this.layout + ", bufferSize=" + this.bufferSize + ", socketOptions=" + this.socketOptions + "]";
        }
    }

    private class Reconnector
    extends Log4jThread {
        private final CountDownLatch latch;
        private boolean shutdown;
        private final Object owner;

        /*
         * WARNING - void declaration
         */
        public Reconnector(OutputStreamManager owner) {
            void var2_2;
            super("TcpSocketManager-Reconnector");
            this.latch = new CountDownLatch(1);
            this.shutdown = false;
            this.owner = var2_2;
        }

        public void latch() {
            try {
                this.latch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void shutdown() {
            this.shutdown = true;
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    Reconnector.sleep(TcpSocketManager.this.reconnectionDelayMillis);
                    this.reconnect();
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.debug("Reconnection interrupted.");
                }
                catch (ConnectException connectException) {
                    LOGGER.debug("{}:{} refused connection", (Object)TcpSocketManager.this.host, (Object)TcpSocketManager.this.port);
                }
                catch (IOException iOException) {
                    LOGGER.debug("Unable to reconnect to {}:{}", (Object)TcpSocketManager.this.host, (Object)TcpSocketManager.this.port);
                }
                finally {
                    this.latch.countDown();
                }
            }
        }

        void reconnect() throws IOException {
            IOException iOException;
            Iterator iterator;
            List<InetSocketAddress> socketAddresses = TcpSocketManagerFactory.RESOLVER.resolveHost(TcpSocketManager.this.host, TcpSocketManager.this.port);
            if (socketAddresses.size() == 1) {
                LOGGER.debug("Reconnecting " + socketAddresses.get(0));
                this.connect(socketAddresses.get(0));
                return;
            }
            Object ioe = null;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                InetSocketAddress socketAddress = (InetSocketAddress)iterator.next();
                try {
                    LOGGER.debug("Reconnecting " + socketAddress);
                    this.connect((InetSocketAddress)((Object)iOException));
                    return;
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    iOException = iOException2;
                }
            }
            throw iOException;
        }

        /*
         * WARNING - void declaration
         */
        private void connect(InetSocketAddress socketAddress) throws IOException {
            void var1_1;
            Socket sock = TcpSocketManager.this.createSocket(socketAddress);
            OutputStream newOS = sock.getOutputStream();
            InetAddress prev = TcpSocketManager.this.socket != null ? TcpSocketManager.this.socket.getInetAddress() : null;
            Object object = this.owner;
            synchronized (object) {
                void var2_3;
                void var3_4;
                Closer.closeSilently(TcpSocketManager.this.getOutputStream());
                TcpSocketManager.access$800(TcpSocketManager.this, (OutputStream)var3_4);
                TcpSocketManager.access$602(TcpSocketManager.this, (Socket)var2_3);
                TcpSocketManager.access$902(TcpSocketManager.this, null);
                this.shutdown = true;
            }
            String type = prev != null && prev.getHostAddress().equals(var1_1.getAddress().getHostAddress()) ? "reestablished" : "established";
            LOGGER.debug("Connection to {}:{} {}: {}", (Object)TcpSocketManager.this.host, (Object)TcpSocketManager.this.port, (Object)type, (Object)TcpSocketManager.this.socket);
        }

        @Override
        public String toString() {
            return "Reconnector [latch=" + this.latch + ", shutdown=" + this.shutdown + "]";
        }
    }
}

