/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.util.Strings;

public class SslSocketManager
extends TcpSocketManager {
    public static final int DEFAULT_PORT = 6514;
    private static final SslSocketManagerFactory FACTORY = new SslSocketManagerFactory();
    private final SslConfiguration sslConfig;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public SslSocketManager(String name, OutputStream os, Socket sock, SslConfiguration sslConfig, InetAddress inetAddress, String host, int port, int connectTimeoutMillis, int reconnectionDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize) {
        super((String)var1_1, (OutputStream)var2_2, (Socket)var3_3, inetAddress, host, port, connectTimeoutMillis, reconnectionDelayMillis, immediateFail, layout, bufferSize, null);
        void var3_3;
        void var2_2;
        void var1_1;
        this.sslConfig = sslConfig;
    }

    /*
     * WARNING - void declaration
     */
    public SslSocketManager(String name, OutputStream os, Socket sock, SslConfiguration sslConfig, InetAddress inetAddress, String host, int port, int connectTimeoutMillis, int reconnectionDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
        super((String)var1_1, (OutputStream)var2_2, (Socket)var3_3, inetAddress, host, port, connectTimeoutMillis, reconnectionDelayMillis, immediateFail, layout, bufferSize, socketOptions);
        void var3_3;
        void var2_2;
        void var1_1;
        this.sslConfig = sslConfig;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslSocketManager getSocketManager(SslConfiguration sslConfig, String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        return SslSocketManager.getSocketManager(sslConfig, (String)var1_1, (int)var2_2, (int)var3_3, reconnectDelayMillis, immediateFail, layout, bufferSize, null);
    }

    /*
     * WARNING - void declaration
     */
    public static SslSocketManager getSocketManager(SslConfiguration sslConfig, String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
        void var3_3;
        void var2_2;
        void var1_1;
        SslConfiguration sslConfiguration;
        if (Strings.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (port <= 0) {
            port = 6514;
        }
        if (reconnectDelayMillis == 0) {
            reconnectDelayMillis = 30000;
        }
        String string = "TLS:" + host + ':' + port;
        return (SslSocketManager)SslSocketManager.getManager(string, new SslFactoryData(sslConfiguration, (String)var1_1, (int)var2_2, (int)var3_3, reconnectDelayMillis, immediateFail, layout, bufferSize, socketOptions), FACTORY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Socket createSocket(InetSocketAddress socketAddress) throws IOException {
        void var1_1;
        SSLSocketFactory sSLSocketFactory = SslSocketManager.createSslSocketFactory(this.sslConfig);
        Socket newSocket = sSLSocketFactory.createSocket();
        newSocket.connect((SocketAddress)var1_1, this.getConnectTimeoutMillis());
        return sSLSocketFactory;
    }

    private static SSLSocketFactory createSslSocketFactory(SslConfiguration sslConf) {
        SSLSocketFactory sSLSocketFactory;
        SSLSocketFactory socketFactory = sslConf != null ? sslConf.getSslSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
        return sSLSocketFactory;
    }

    /*
     * WARNING - void declaration
     */
    static Socket createSocket(InetSocketAddress socketAddress, int connectTimeoutMillis, SslConfiguration sslConfiguration, SocketOptions socketOptions) throws IOException {
        void var2_2;
        void var1_1;
        InetSocketAddress inetSocketAddress;
        sslConfiguration = SslSocketManager.createSslSocketFactory((SslConfiguration)sslConfiguration);
        SSLSocket socket = (SSLSocket)((SocketFactory)sslConfiguration).createSocket();
        if (socketOptions != null) {
            socketOptions.apply(socket);
        }
        socket.connect(inetSocketAddress, (int)var1_1);
        if (socketOptions != null) {
            void var3_3;
            var3_3.apply(socket);
        }
        return var2_2;
    }

    private static class SslSocketManagerFactory
    extends TcpSocketManager.TcpSocketManagerFactory<SslSocketManager, SslFactoryData> {
        private SslSocketManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        SslSocketManager createManager(String name, OutputStream os, Socket socket, InetAddress inetAddress, SslFactoryData data) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new SslSocketManager((String)var1_1, (OutputStream)var2_2, (Socket)var3_3, data.sslConfiguration, inetAddress, data.host, data.port, data.connectTimeoutMillis, data.reconnectDelayMillis, data.immediateFail, data.layout, data.bufferSize, data.socketOptions);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Socket createSocket(SslFactoryData data) throws IOException {
            void var2_2;
            void var1_1;
            IOException iOException;
            List<InetSocketAddress> socketAddresses = RESOLVER.resolveHost(data.host, data.port);
            Object ioe = null;
            for (InetSocketAddress socketAddress : socketAddresses) {
                try {
                    return SslSocketManager.createSocket((InetSocketAddress)((Object)iOException), data.connectTimeoutMillis, data.sslConfiguration, data.socketOptions);
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    iOException = iOException2;
                }
            }
            throw new IOException(this.errorMessage(var1_1, (List<InetSocketAddress>)var2_2), iOException);
        }
    }

    private static class SslFactoryData
    extends TcpSocketManager.FactoryData {
        protected SslConfiguration sslConfiguration;

        /*
         * WARNING - void declaration
         */
        public SslFactoryData(SslConfiguration sslConfiguration, String host, int port, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
            super((String)var2_2, (int)var3_3, connectTimeoutMillis, reconnectDelayMillis, immediateFail, layout, bufferSize, socketOptions);
            void var1_1;
            void var3_3;
            void var2_2;
            this.sslConfiguration = var1_1;
        }

        @Override
        public String toString() {
            return "SslFactoryData [sslConfiguration=" + this.sslConfiguration + ", host=" + this.host + ", port=" + this.port + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", reconnectDelayMillis=" + this.reconnectDelayMillis + ", immediateFail=" + this.immediateFail + ", layout=" + this.layout + ", bufferSize=" + this.bufferSize + ", socketOptions=" + this.socketOptions + "]";
        }
    }
}

