/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidHost;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidPort;

@Plugin(name="SocketAddress", category="Core", printObject=true)
public class SocketAddress {
    private final InetSocketAddress socketAddress;

    public static SocketAddress getLoopback() {
        return new SocketAddress(InetAddress.getLoopbackAddress(), 0);
    }

    /*
     * WARNING - void declaration
     */
    private SocketAddress(InetAddress host, int port) {
        void var2_2;
        void var1_1;
        this.socketAddress = new InetSocketAddress((InetAddress)var1_1, (int)var2_2);
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public int getPort() {
        return this.socketAddress.getPort();
    }

    public InetAddress getAddress() {
        return this.socketAddress.getAddress();
    }

    public String getHostName() {
        return this.socketAddress.getHostName();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return this.socketAddress.toString();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<SocketAddress> {
        @PluginBuilderAttribute
        @ValidHost
        private InetAddress host;
        @PluginBuilderAttribute
        @ValidPort
        private int port;

        /*
         * WARNING - void declaration
         */
        public Builder setHost(InetAddress host) {
            void var1_1;
            this.host = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setPort(int port) {
            void var1_1;
            this.port = var1_1;
            return this;
        }

        @Override
        public SocketAddress build() {
            return new SocketAddress(this.host, this.port);
        }
    }
}

