/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.MailManager;
import org.apache.logging.log4j.core.net.MailManagerFactory;
import org.apache.logging.log4j.core.net.MimeMessageBuilder;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.util.CyclicBuffer;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.util.PropertiesUtil;

public class SmtpManager
extends MailManager {
    public static final SMTPManagerFactory FACTORY = new SMTPManagerFactory();
    private final Session session;
    private final CyclicBuffer<LogEvent> buffer;
    private volatile MimeMessage message;
    private final MailManager.FactoryData data;

    /*
     * WARNING - void declaration
     */
    private static MimeMessage createMimeMessage(MailManager.FactoryData data, Session session, LogEvent appendEvent) throws MessagingException {
        void var2_2;
        MailManager.FactoryData factoryData;
        void var1_1;
        return new MimeMessageBuilder((Session)var1_1).setFrom(data.getFrom()).setReplyTo(data.getReplyTo()).setRecipients(Message.RecipientType.TO, data.getTo()).setRecipients(Message.RecipientType.CC, data.getCc()).setRecipients(Message.RecipientType.BCC, data.getBcc()).setSubject(factoryData.getSubjectSerializer().toSerializable((LogEvent)var2_2)).build();
    }

    /*
     * WARNING - void declaration
     */
    protected SmtpManager(String name, Session session, MimeMessage message, MailManager.FactoryData data) {
        super(null, (String)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.session = var2_2;
        this.message = var3_3;
        this.data = data;
        this.buffer = new CyclicBuffer<LogEvent>(LogEvent.class, data.getBufferSize());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(LogEvent event) {
        void var1_1;
        this.buffer.add(var1_1.toImmutable());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SmtpManager getSmtpManager(Configuration config, String to, String cc, String bcc, String from, String replyTo, String subject, String protocol, String host, int port, String username, String password, boolean isDebug, String filterName, int numElements, SslConfiguration sslConfiguration) {
        MailManager.FactoryData factoryData;
        void var3_3;
        void var2_2;
        void var1_1;
        MailManager.FactoryData subjectSerializer = PatternLayout.newSerializerBuilder().setConfiguration(config).setPattern(subject).build();
        MailManager.FactoryData data = new MailManager.FactoryData((String)var1_1, (String)var2_2, (String)var3_3, from, replyTo, subject, (AbstractStringLayout.Serializer)((Object)subjectSerializer), protocol, host, port, username, password, isDebug, numElements, sslConfiguration, filterName);
        return (SmtpManager)SmtpManager.getManager(data.getManagerName(), FACTORY, factoryData);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendEvents(Layout<?> layout, LogEvent appendEvent) {
        if (this.message == null) {
            this.connect(appendEvent);
        }
        try {
            void var2_2;
            void var1_1;
            LogEvent[] priorEvents = this.removeAllBufferedEvents();
            byte[] rawBytes = this.formatContentToBytes(priorEvents, appendEvent, layout);
            String contentType = layout.getContentType();
            String encoding = this.getEncoding(rawBytes, contentType);
            byte[] encodedBytes = this.encodeContentToBytes(rawBytes, encoding);
            InternetHeaders headers = this.getHeaders(contentType, encoding);
            MimeMultipart mp = this.getMimeMultipart(encodedBytes, headers);
            String subject = this.data.getSubjectSerializer().toSerializable(appendEvent);
            SmtpManager smtpManager = this;
            smtpManager.sendMultipartMessage(smtpManager.message, (MimeMultipart)var1_1, (String)var2_2);
            return;
        }
        catch (IOException | RuntimeException | MessagingException e) {
            void var3_4;
            this.logError("Caught exception while sending e-mail notification.", e);
            throw new LoggingException("Error occurred while sending email", (Throwable)var3_4);
        }
    }

    LogEvent[] removeAllBufferedEvents() {
        return this.buffer.removeAll();
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] formatContentToBytes(LogEvent[] priorEvents, LogEvent appendEvent, Layout<?> layout) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteArrayOutputStream raw = new ByteArrayOutputStream();
        this.writeContent((LogEvent[])var1_1, (LogEvent)var2_2, (Layout<?>)var3_3, raw);
        return raw.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    private void writeContent(LogEvent[] priorEvents, LogEvent appendEvent, Layout<?> layout, ByteArrayOutputStream out) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writeHeader(layout, out);
        this.writeBuffer((LogEvent[])var1_1, (LogEvent)var2_2, layout, out);
        this.writeFooter((Layout<?>)var3_3, out);
    }

    /*
     * WARNING - void declaration
     */
    protected void writeHeader(Layout<?> layout, OutputStream out) throws IOException {
        byte[] header = layout.getHeader();
        if (header != null) {
            void var1_1;
            void var2_2;
            var2_2.write((byte[])var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void writeBuffer(LogEvent[] priorEvents, LogEvent appendEvent, Layout<?> layout, OutputStream out) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        for (LogEvent priorEvent : priorEvents) {
            byte[] bytes = layout.toByteArray(priorEvent);
            out.write(bytes);
        }
        byte[] bytes = var3_3.toByteArray((LogEvent)var2_2);
        out.write((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void writeFooter(Layout<?> layout, OutputStream out) throws IOException {
        byte[] footer = layout.getFooter();
        if (footer != null) {
            void var1_1;
            void var2_2;
            var2_2.write((byte[])var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String getEncoding(byte[] rawBytes, String contentType) {
        void var2_2;
        ByteArrayDataSource byteArrayDataSource;
        byteArrayDataSource = new ByteArrayDataSource((byte[])byteArrayDataSource, (String)var2_2);
        return MimeUtility.getEncoding((DataSource)byteArrayDataSource);
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] encodeContentToBytes(byte[] rawBytes, String encoding) throws MessagingException, IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteArrayOutputStream encoded = new ByteArrayOutputStream();
        this.encodeContent((byte[])var1_1, (String)var2_2, encoded);
        return var3_3.toByteArray();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void encodeContent(byte[] bytes, String encoding, ByteArrayOutputStream out) throws MessagingException, IOException {
        Throwable throwable;
        OutputStream encoder2 = MimeUtility.encode((OutputStream)out, (String)encoding);
        Throwable throwable2 = null;
        try {
            encoder2.write((byte[])throwable);
            if (encoder2 == null) return;
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throwable2 = throwable3;
                throw throwable;
            }
            catch (Throwable throwable4) {
                if (encoder2 == null) throw throwable4;
                if (throwable2 != null) {
                    try {
                        encoder2.close();
                        throw throwable4;
                    }
                    catch (Throwable encoder2) {
                        throwable2.addSuppressed(encoder2);
                    }
                    throw throwable4;
                } else {
                    void var2_3;
                    var2_3.close();
                }
                throw throwable4;
            }
        }
        encoder2.close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    protected InternetHeaders getHeaders(String contentType, String encoding) {
        void var3_3;
        void var2_2;
        void var1_1;
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Type", (String)var1_1 + "; charset=UTF-8");
        headers.setHeader("Content-Transfer-Encoding", (String)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected MimeMultipart getMimeMultipart(byte[] encodedBytes, InternetHeaders headers) throws MessagingException {
        void var3_3;
        void var1_1;
        void var2_2;
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart part = new MimeBodyPart((InternetHeaders)var2_2, encodedBytes);
        mp.addBodyPart((BodyPart)var1_1);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected void sendMultipartMessage(MimeMessage msg, MimeMultipart mp) throws MessagingException {
        MimeMessage mimeMessage = msg;
        synchronized (mimeMessage) {
            void var1_1;
            void var2_3;
            msg.setContent((Multipart)var2_3);
            msg.setSentDate(new Date());
            Transport.send((Message)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void sendMultipartMessage(MimeMessage msg, MimeMultipart mp, String subject) throws MessagingException {
        MimeMessage mimeMessage = msg;
        synchronized (mimeMessage) {
            void var1_1;
            void var3_4;
            void var2_3;
            msg.setContent((Multipart)var2_3);
            msg.setSentDate(new Date());
            msg.setSubject((String)var3_4);
            Transport.send((Message)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void connect(LogEvent appendEvent) {
        if (this.message != null) {
            return;
        }
        try {
            this.message = SmtpManager.createMimeMessage(this.data, this.session, appendEvent);
            return;
        }
        catch (MessagingException e) {
            void var1_2;
            this.logError("Could not set SmtpAppender message options", (Throwable)var1_2);
            this.message = null;
            return;
        }
    }

    public static class SMTPManagerFactory
    implements MailManagerFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        public SmtpManager createManager(String name, MailManager.FactoryData data) {
            void var2_2;
            void var1_1;
            void var3_3;
            SslConfiguration sslConfiguration;
            Authenticator authenticator;
            String smtpHost;
            String smtpProtocol = data.getSmtpProtocol();
            String prefix = "mail." + smtpProtocol;
            Properties properties = PropertiesUtil.getSystemProperties();
            properties.setProperty("mail.transport.protocol", smtpProtocol);
            if (properties.getProperty("mail.host") == null) {
                properties.setProperty("mail.host", NetUtils.getLocalHostname());
            }
            if ((smtpHost = data.getSmtpHost()) != null) {
                properties.setProperty(prefix + ".host", smtpHost);
            }
            if (data.getSmtpPort() > 0) {
                properties.setProperty(prefix + ".port", String.valueOf(data.getSmtpPort()));
            }
            if ((authenticator = this.buildAuthenticator(data.getSmtpUsername(), data.getSmtpPassword())) != null) {
                properties.setProperty(prefix + ".auth", "true");
            }
            if (smtpProtocol.equals("smtps") && (sslConfiguration = data.getSslConfiguration()) != null) {
                SSLSocketFactory sslSocketFactory = sslConfiguration.getSslSocketFactory();
                properties.put(prefix + ".ssl.socketFactory", sslSocketFactory);
                properties.setProperty(prefix + ".ssl.checkserveridentity", Boolean.toString(sslConfiguration.isVerifyHostName()));
            }
            Session session = Session.getInstance((Properties)properties, (Authenticator)authenticator);
            session.setProtocolForAddress("rfc822", (String)var3_3);
            session.setDebug(data.isSmtpDebug());
            return new SmtpManager((String)var1_1, session, null, (MailManager.FactoryData)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private Authenticator buildAuthenticator(String username, String password) {
            if (password != null && username != null) {
                void var2_2;
                void var1_1;
                return new Authenticator(this, (String)var1_1, (String)var2_2){
                    private final PasswordAuthentication passwordAuthentication;
                    final /* synthetic */ String val$username;
                    final /* synthetic */ String val$password;
                    final /* synthetic */ SMTPManagerFactory this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$username = string;
                        this.val$password = string2;
                        this.passwordAuthentication = new PasswordAuthentication(this.val$username, this.val$password);
                    }

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return this.passwordAuthentication;
                    }
                };
            }
            return null;
        }
    }
}

