/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

@Plugin(name="multicastdns", category="Core", elementType="advertiser", printObject=false)
public class MulticastDnsAdvertiser
implements Advertiser {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private static final int MAX_LENGTH = 255;
    private static final int DEFAULT_PORT = 4555;
    private static Object jmDNS = MulticastDnsAdvertiser.initializeJmDns();
    private static Class<?> jmDNSClass;
    private static Class<?> serviceInfoClass;

    /*
     * WARNING - void declaration
     */
    @Override
    public Object advertise(Map<String, String> properties) {
        Object truncatedProperties = new HashMap<String, String>();
        for (Map.Entry entry : properties.entrySet()) {
            if (((String)entry.getKey()).length() > 255 || ((String)entry.getValue()).length() > 255) continue;
            truncatedProperties.put(entry.getKey(), entry.getValue());
        }
        String protocol = (String)truncatedProperties.get("protocol");
        String string = "._log4j._" + (protocol != null ? protocol : "tcp") + ".local.";
        protocol = (String)truncatedProperties.get("port");
        int port = Integers.parseInt(protocol, 4555);
        String name = (String)truncatedProperties.get("name");
        if (jmDNS != null) {
            void var1_3;
            Object serviceInfo;
            boolean isVersion3 = false;
            try {
                jmDNSClass.getMethod("create", new Class[0]);
                isVersion3 = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (isVersion3) {
                Object serviceInfo22 = MulticastDnsAdvertiser.buildServiceInfoVersion3(string, port, name, truncatedProperties);
            } else {
                void serviceInfo22;
                serviceInfo = MulticastDnsAdvertiser.buildServiceInfoVersion1(string, (int)serviceInfo22, name, truncatedProperties);
            }
            try {
                truncatedProperties = jmDNSClass.getMethod("registerService", serviceInfoClass);
                ((Method)truncatedProperties).invoke(jmDNS, serviceInfo);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("Unable to invoke registerService method", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                void var2_6;
                LOGGER.warn("No registerService method", (Throwable)var2_6);
            }
            return var1_3;
        }
        LOGGER.warn("JMDNS not available - will not advertise ZeroConf support");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unadvertise(Object serviceInfo) {
        if (jmDNS != null) {
            try {
                void var1_1;
                Method method = jmDNSClass.getMethod("unregisterService", serviceInfoClass);
                method.invoke(jmDNS, var1_1);
                return;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("Unable to invoke unregisterService method", (Throwable)e);
                return;
            }
            catch (NoSuchMethodException e) {
                void var2_4;
                LOGGER.warn("No unregisterService method", (Throwable)var2_4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Object createJmDnsVersion1() {
        try {
            return jmDNSClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            void var0;
            LOGGER.warn("Unable to instantiate JMDNS", (Throwable)var0);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Object createJmDnsVersion3() {
        try {
            Method method = jmDNSClass.getMethod("create", new Class[0]);
            return method.invoke(null, null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.warn("Unable to invoke create method", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            void var0_2;
            LOGGER.warn("Unable to get create method", (Throwable)var0_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Object buildServiceInfoVersion1(String zone, int port, String name, Map<String, String> properties) {
        Hashtable<String, String> hashtableProperties = new Hashtable<String, String>(properties);
        try {
            void var3_5;
            void var1_3;
            void var2_4;
            return serviceInfoClass.getConstructor(String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Hashtable.class).newInstance(zone, var2_4, (int)var1_3, 0, 0, var3_5);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOGGER.warn("Unable to construct ServiceInfo instance", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            void var0_2;
            LOGGER.warn("Unable to get ServiceInfo constructor", (Throwable)var0_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Object buildServiceInfoVersion3(String zone, int port, String name, Map<String, String> properties) {
        try {
            void var3_5;
            void var1_3;
            void var2_4;
            return serviceInfoClass.getMethod("create", String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Map.class).invoke(null, zone, var2_4, (int)var1_3, 0, 0, var3_5);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.warn("Unable to invoke create method", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            void var0_2;
            LOGGER.warn("Unable to find create method", (Throwable)var0_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Object initializeJmDns() {
        try {
            jmDNSClass = LoaderUtil.loadClass((String)"javax.jmdns.JmDNS");
            serviceInfoClass = LoaderUtil.loadClass((String)"javax.jmdns.ServiceInfo");
            boolean isVersion3 = false;
            try {
                jmDNSClass.getMethod("create", new Class[0]);
                isVersion3 = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (isVersion3) {
                return MulticastDnsAdvertiser.createJmDnsVersion3();
            }
            return MulticastDnsAdvertiser.createJmDnsVersion1();
        }
        catch (ClassNotFoundException | ExceptionInInitializerError e) {
            void var0_1;
            LOGGER.warn("JmDNS or serviceInfo class not found", (Throwable)var0_1);
            return null;
        }
    }
}

