/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.util.JndiCloser;
import org.apache.logging.log4j.util.PropertiesUtil;

public class JndiManager
extends AbstractManager {
    private static final JndiManagerFactory FACTORY = new JndiManagerFactory();
    private static final String PREFIX = "log4j2.enableJndi";
    private static final String JAVA_SCHEME = "java";
    private final InitialContext context;

    private static boolean isJndiEnabled(String subKey) {
        String string;
        return PropertiesUtil.getProperties().getBooleanProperty(PREFIX + string, false);
    }

    public static boolean isJndiEnabled() {
        return JndiManager.isJndiContextSelectorEnabled() || JndiManager.isJndiJdbcEnabled() || JndiManager.isJndiJmsEnabled() || JndiManager.isJndiLookupEnabled();
    }

    public static boolean isJndiContextSelectorEnabled() {
        return JndiManager.isJndiEnabled("ContextSelector");
    }

    public static boolean isJndiJdbcEnabled() {
        return JndiManager.isJndiEnabled("Jdbc");
    }

    public static boolean isJndiJmsEnabled() {
        return JndiManager.isJndiEnabled("Jms");
    }

    public static boolean isJndiLookupEnabled() {
        return JndiManager.isJndiEnabled("Lookup");
    }

    /*
     * WARNING - void declaration
     */
    private JndiManager(String name, InitialContext context) {
        super(null, (String)var1_1);
        void var2_2;
        void var1_1;
        this.context = var2_2;
    }

    public static JndiManager getDefaultManager() {
        return JndiManager.getManager(JndiManager.class.getName(), FACTORY, null);
    }

    public static JndiManager getDefaultManager(String name) {
        return JndiManager.getManager(name, FACTORY, null);
    }

    /*
     * WARNING - void declaration
     */
    public static JndiManager getJndiManager(String initialContextFactoryName, String providerURL, String urlPkgPrefixes, String securityPrincipal, String securityCredentials, Properties additionalProperties) {
        Properties properties;
        void var3_3;
        void var2_2;
        void var1_1;
        Properties properties2 = JndiManager.createProperties(initialContextFactoryName, (String)var1_1, (String)var2_2, (String)var3_3, securityCredentials, additionalProperties);
        return JndiManager.getManager(JndiManager.createManagerName(), FACTORY, properties);
    }

    public static JndiManager getJndiManager(Properties properties) {
        Properties properties2;
        return JndiManager.getManager(JndiManager.createManagerName(), FACTORY, properties2);
    }

    private static String createManagerName() {
        return JndiManager.class.getName() + '@' + JndiManager.class.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public static Properties createProperties(String initialContextFactoryName, String providerURL, String urlPkgPrefixes, String securityPrincipal, String securityCredentials, Properties additionalProperties) {
        if (initialContextFactoryName == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.setProperty("java.naming.factory.initial", initialContextFactoryName);
        if (providerURL != null) {
            void var1_1;
            properties.setProperty("java.naming.provider.url", (String)var1_1);
        } else {
            String string;
            LOGGER.warn("The JNDI InitialContextFactory class name [{}] was provided, but there was no associated provider URL. This is likely to cause problems.", (Object)string);
        }
        if (urlPkgPrefixes != null) {
            void var2_2;
            properties.setProperty("java.naming.factory.url.pkgs", (String)var2_2);
        }
        if (securityPrincipal != null) {
            properties.setProperty("java.naming.security.principal", securityPrincipal);
            if (securityCredentials != null) {
                properties.setProperty("java.naming.security.credentials", securityCredentials);
            } else {
                void var3_3;
                LOGGER.warn("A security principal [{}] was provided, but with no corresponding security credentials.", (Object)var3_3);
            }
        }
        if (additionalProperties != null) {
            properties.putAll((Map<?, ?>)additionalProperties);
        }
        return properties;
    }

    @Override
    protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
        return JndiCloser.closeSilently(this.context);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T lookup(String name) throws NamingException {
        if (this.context == null) {
            return null;
        }
        try {
            void var2_2;
            URI uri = new URI(name);
            if (uri.getScheme() == null || var2_2.getScheme().equals(JAVA_SCHEME)) {
                return (T)this.context.lookup(name);
            }
            LOGGER.warn("Unsupported JNDI URI - {}", (Object)name);
        }
        catch (URISyntaxException uRISyntaxException) {
            void var1_1;
            LOGGER.warn("Invalid JNDI URI - {}", (Object)var1_1);
        }
        return null;
    }

    public String toString() {
        return "JndiManager [context=" + this.context + ", count=" + this.count + "]";
    }

    private static class JndiManagerFactory
    implements ManagerFactory<JndiManager, Properties> {
        private JndiManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public JndiManager createManager(String name, Properties data) {
            if (!JndiManager.isJndiEnabled()) {
                throw new IllegalStateException(String.format("JNDI must be enabled by setting one of the %s* properties to true", JndiManager.PREFIX));
            }
            try {
                return new JndiManager(name, new InitialContext(data));
            }
            catch (NamingException e) {
                void var2_3;
                void var1_1;
                LOGGER.error("Error creating JNDI InitialContext for '{}'.", (Object)var1_1, (Object)var2_3);
                return null;
            }
        }
    }
}

