/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.DatagramOutputStream;
import org.apache.logging.log4j.util.Strings;

public class DatagramSocketManager
extends AbstractSocketManager {
    private static final DatagramSocketManagerFactory FACTORY = new DatagramSocketManagerFactory();

    /*
     * WARNING - void declaration
     */
    protected DatagramSocketManager(String name, OutputStream os, InetAddress inetAddress, String host, int port, Layout<? extends Serializable> layout, int bufferSize) {
        super((String)var1_1, (OutputStream)var2_2, (InetAddress)var3_3, host, port, layout, true, bufferSize);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static DatagramSocketManager getSocketManager(String host, int port, Layout<? extends Serializable> layout, int bufferSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        if (Strings.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("A port value is required");
        }
        return (DatagramSocketManager)DatagramSocketManager.getManager("UDP:" + host + ':' + port, new FactoryData(string, (int)var1_1, (Layout<? extends Serializable>)var2_2, (int)var3_3), FACTORY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> getContentFormat() {
        void var1_1;
        HashMap<String, String> result = new HashMap<String, String>(super.getContentFormat());
        result.put("protocol", "udp");
        result.put("direction", "out");
        return var1_1;
    }

    private static class DatagramSocketManagerFactory
    implements ManagerFactory<DatagramSocketManager, FactoryData> {
        private DatagramSocketManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public DatagramSocketManager createManager(String name, FactoryData data) {
            void var2_2;
            void var3_3;
            void var1_1;
            try {
                InetAddress inetAddress = InetAddress.getByName(data.host);
            }
            catch (UnknownHostException ex) {
                LOGGER.error("Could not find address of " + data.host, (Throwable)ex);
                return null;
            }
            DatagramOutputStream os = new DatagramOutputStream(data.host, data.port, data.layout.getHeader(), data.layout.getFooter());
            return new DatagramSocketManager((String)var1_1, (OutputStream)os, (InetAddress)var3_3, data.host, data.port, data.layout, ((FactoryData)var2_2).bufferSize);
        }
    }

    private static class FactoryData {
        private final String host;
        private final int port;
        private final Layout<? extends Serializable> layout;
        private final int bufferSize;

        /*
         * WARNING - void declaration
         */
        public FactoryData(String host, int port, Layout<? extends Serializable> layout, int bufferSize) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.host = var1_1;
            this.port = var2_2;
            this.layout = var3_3;
            this.bufferSize = bufferSize;
        }
    }
}

