/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.status.StatusLogger;

public class DatagramOutputStream
extends OutputStream {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private static final int SHIFT_1 = 8;
    private static final int SHIFT_2 = 16;
    private static final int SHIFT_3 = 24;
    private DatagramSocket datagramSocket;
    private final InetAddress inetAddress;
    private final int port;
    private byte[] data;
    private final byte[] header;
    private final byte[] footer;

    /*
     * WARNING - void declaration
     */
    public DatagramOutputStream(String host, int port, byte[] header, byte[] footer) {
        String msg;
        void var3_5;
        this.port = port;
        this.header = var3_5;
        this.footer = footer;
        try {
            this.inetAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            msg = "Could not find host " + host;
            LOGGER.error(msg, (Throwable)ex);
            throw new AppenderLoggingException(msg, ex);
        }
        try {
            this.datagramSocket = new DatagramSocket();
            return;
        }
        catch (SocketException ex) {
            void var2_4;
            void var1_1;
            msg = "Could not instantiate DatagramSocket to " + msg;
            LOGGER.error(msg, (Throwable)ex);
            throw new AppenderLoggingException((String)var1_1, (Throwable)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void write(byte[] bytes, int offset, int length) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.copy((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void write(int i) throws IOException {
        void var1_1;
        this.copy(new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)var1_1}, 0, 4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void write(byte[] bytes) throws IOException {
        void var1_1;
        this.copy(bytes, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void flush() throws IOException {
        try {
            if (this.data != null && this.datagramSocket != null && this.inetAddress != null) {
                void var1_1;
                if (this.footer != null) {
                    DatagramOutputStream datagramOutputStream = this;
                    datagramOutputStream.copy(datagramOutputStream.footer, 0, this.footer.length);
                }
                DatagramPacket packet = new DatagramPacket(this.data, this.data.length, this.inetAddress, this.port);
                this.datagramSocket.send((DatagramPacket)var1_1);
            }
            this.data = null;
            if (this.header != null) {
                DatagramOutputStream datagramOutputStream = this;
                datagramOutputStream.copy(datagramOutputStream.header, 0, this.header.length);
                return;
            }
        }
        catch (Throwable throwable) {
            this.data = null;
            if (this.header != null) {
                DatagramOutputStream datagramOutputStream = this;
                datagramOutputStream.copy(datagramOutputStream.header, 0, this.header.length);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.datagramSocket != null) {
            if (this.data != null) {
                this.flush();
            }
            this.datagramSocket.close();
            this.datagramSocket = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void copy(byte[] bytes, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        int index = this.data == null ? 0 : this.data.length;
        byte[] copy = new byte[length + index];
        if (this.data != null) {
            System.arraycopy(this.data, 0, copy, 0, this.data.length);
        }
        System.arraycopy(var1_1, (int)var2_2, copy, index, (int)var3_3);
        this.data = copy;
    }
}

