/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.message;

import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import org.apache.logging.log4j.message.ThreadInformation;
import org.apache.logging.log4j.util.StringBuilders;

class ExtendedThreadInformation
implements ThreadInformation {
    private final ThreadInfo threadInfo;

    /*
     * WARNING - void declaration
     */
    ExtendedThreadInformation(ThreadInfo thread) {
        void var1_1;
        this.threadInfo = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void printThreadInfo(StringBuilder sb) {
        void var1_1;
        StringBuilders.appendDqValue((StringBuilder)sb, (Object)this.threadInfo.getThreadName());
        sb.append(" Id=").append(this.threadInfo.getThreadId()).append(' ');
        this.formatState(sb, this.threadInfo);
        if (this.threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (this.threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        var1_1.append('\n');
    }

    /*
     * WARNING - void declaration
     */
    public void printStack(StringBuilder sb, StackTraceElement[] stack) {
        int i = 0;
        for (StackTraceElement element : stack) {
            Object ts;
            sb.append("\tat ").append(element.toString());
            sb.append('\n');
            if (i == 0 && this.threadInfo.getLockInfo() != null) {
                ts = this.threadInfo.getThreadState();
                switch (1.$SwitchMap$java$lang$Thread$State[((Enum)ts).ordinal()]) {
                    case 1: {
                        sb.append("\t-  blocked on ");
                        this.formatLock(sb, this.threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case 2: {
                        sb.append("\t-  waiting on ");
                        this.formatLock(sb, this.threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case 3: {
                        sb.append("\t-  waiting on ");
                        this.formatLock(sb, this.threadInfo.getLockInfo());
                        sb.append('\n');
                    }
                }
            }
            ts = this.threadInfo.getLockedMonitors();
            int n = ((MonitorInfo[])ts).length;
            for (int j = 0; j < n; ++j) {
                Object mi = ts[j];
                if (((MonitorInfo)mi).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ");
                this.formatLock(sb, (LockInfo)mi);
                sb.append('\n');
            }
            ++i;
        }
        LockInfo[] locks = this.threadInfo.getLockedSynchronizers();
        if (locks.length > 0) {
            void var2_2;
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length).append('\n');
            for (void li : var2_2) {
                sb.append("\t- ");
                this.formatLock(sb, (LockInfo)li);
                sb.append('\n');
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void formatLock(StringBuilder sb, LockInfo lock) {
        void var2_2;
        void var1_1;
        sb.append('<').append(lock.getIdentityHashCode()).append("> (a ");
        var1_1.append(var2_2.getClassName()).append(')');
    }

    /*
     * WARNING - void declaration
     */
    private void formatState(StringBuilder sb, ThreadInfo info) {
        Thread.State state = info.getThreadState();
        sb.append((Object)state);
        switch (state) {
            case BLOCKED: {
                sb.append(" (on object monitor owned by \"");
                sb.append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId()).append(')');
                return;
            }
            case WAITING: {
                StackTraceElement element = info.getStackTrace()[0];
                String className = element.getClassName();
                String method = element.getMethodName();
                if (className.equals("java.lang.Object") && method.equals("wait")) {
                    sb.append(" (on object monitor");
                    if (info.getLockOwnerName() != null) {
                        sb.append(" owned by \"");
                        sb.append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
                    }
                    sb.append(')');
                    return;
                }
                if (className.equals("java.lang.Thread") && method.equals("join")) {
                    sb.append(" (on completion of thread ").append(info.getLockOwnerId()).append(')');
                    return;
                }
                sb.append(" (parking for lock");
                if (info.getLockOwnerName() != null) {
                    sb.append(" owned by \"");
                    sb.append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
                }
                sb.append(')');
                return;
            }
            case TIMED_WAITING: {
                void var1_1;
                void var3_3;
                StackTraceElement element = info.getStackTrace()[0];
                String className = element.getClassName();
                String method = element.getMethodName();
                if (className.equals("java.lang.Object") && method.equals("wait")) {
                    sb.append(" (on object monitor");
                    if (info.getLockOwnerName() != null) {
                        sb.append(" owned by \"");
                        sb.append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
                    }
                    sb.append(')');
                    return;
                }
                if (className.equals("java.lang.Thread") && method.equals("sleep")) {
                    sb.append(" (sleeping)");
                    return;
                }
                if (className.equals("java.lang.Thread") && var3_3.equals("join")) {
                    sb.append(" (on completion of thread ").append(info.getLockOwnerId()).append(')');
                    return;
                }
                sb.append(" (parking for lock");
                if (info.getLockOwnerName() != null) {
                    void var2_2;
                    sb.append(" owned by \"");
                    sb.append(info.getLockOwnerName()).append("\" Id=").append(var2_2.getLockOwnerId());
                }
                var1_1.append(')');
            }
        }
    }
}

