/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationAware;
import org.apache.logging.log4j.core.lookup.LookupResult;
import org.apache.logging.log4j.core.lookup.PropertiesLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrMatcher;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public class StrSubstitutor
implements ConfigurationAware {
    public static final char DEFAULT_ESCAPE = '$';
    public static final StrMatcher DEFAULT_PREFIX = StrMatcher.stringMatcher("${");
    public static final StrMatcher DEFAULT_SUFFIX = StrMatcher.stringMatcher("}");
    public static final String DEFAULT_VALUE_DELIMITER_STRING = ":-";
    public static final StrMatcher DEFAULT_VALUE_DELIMITER = StrMatcher.stringMatcher(":-");
    public static final String ESCAPE_DELIMITER_STRING = ":\\-";
    public static final StrMatcher DEFAULT_VALUE_ESCAPE_DELIMITER = StrMatcher.stringMatcher(":\\-");
    private static final int BUF_SIZE = 256;
    private char escapeChar;
    private StrMatcher prefixMatcher;
    private StrMatcher suffixMatcher;
    private String valueDelimiterString;
    private StrMatcher valueDelimiterMatcher;
    private StrMatcher valueEscapeDelimiterMatcher;
    private StrLookup variableResolver;
    private boolean enableSubstitutionInVariables = true;
    private Configuration configuration;

    public StrSubstitutor() {
        this(null, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor(Map<String, String> valueMap) {
        this((StrLookup)new PropertiesLookup((Map<String, String>)var1_1), DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor(Map<String, String> valueMap, String prefix, String suffix) {
        this((StrLookup)new PropertiesLookup((Map<String, String>)var1_1), (String)var2_2, (String)var3_3, '$');
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor(Map<String, String> valueMap, String prefix, String suffix, char escape) {
        this((StrLookup)new PropertiesLookup((Map<String, String>)var1_1), (String)var2_2, (String)var3_3, escape);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor(Map<String, String> valueMap, String prefix, String suffix, char escape, String valueDelimiter) {
        this((StrLookup)new PropertiesLookup((Map<String, String>)var1_1), (String)var2_2, (String)var3_3, escape, valueDelimiter);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor(Properties properties) {
        this(StrSubstitutor.toTypeSafeMap((Properties)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor(StrLookup variableResolver) {
        this((StrLookup)var1_1, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor(StrLookup variableResolver, String prefix, String suffix, char escape) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setVariableResolver((StrLookup)var1_1);
        this.setVariablePrefix((String)var2_2);
        this.setVariableSuffix((String)var3_3);
        this.setEscapeChar(escape);
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor(StrLookup variableResolver, String prefix, String suffix, char escape, String valueDelimiter) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setVariableResolver((StrLookup)var1_1);
        this.setVariablePrefix((String)var2_2);
        this.setVariableSuffix((String)var3_3);
        this.setEscapeChar(escape);
        this.setValueDelimiter(valueDelimiter);
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor(StrLookup variableResolver, StrMatcher prefixMatcher, StrMatcher suffixMatcher, char escape) {
        this((StrLookup)var1_1, (StrMatcher)var2_2, (StrMatcher)var3_3, escape, DEFAULT_VALUE_DELIMITER, DEFAULT_VALUE_ESCAPE_DELIMITER);
        void var3_3;
        void var2_2;
        void var1_1;
        this.valueDelimiterString = DEFAULT_VALUE_DELIMITER_STRING;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor(StrLookup variableResolver, StrMatcher prefixMatcher, StrMatcher suffixMatcher, char escape, StrMatcher valueDelimiterMatcher) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setVariableResolver((StrLookup)var1_1);
        this.setVariablePrefixMatcher((StrMatcher)var2_2);
        this.setVariableSuffixMatcher((StrMatcher)var3_3);
        this.setEscapeChar(escape);
        this.setValueDelimiterMatcher(valueDelimiterMatcher);
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor(StrLookup variableResolver, StrMatcher prefixMatcher, StrMatcher suffixMatcher, char escape, StrMatcher valueDelimiterMatcher, StrMatcher valueEscapeMatcher) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setVariableResolver((StrLookup)var1_1);
        this.setVariablePrefixMatcher((StrMatcher)var2_2);
        this.setVariableSuffixMatcher((StrMatcher)var3_3);
        this.setEscapeChar(escape);
        this.setValueDelimiterMatcher(valueDelimiterMatcher);
        this.valueEscapeDelimiterMatcher = valueEscapeMatcher;
    }

    /*
     * WARNING - void declaration
     */
    StrSubstitutor(StrSubstitutor other) {
        void var1_1;
        Objects.requireNonNull(other, "other");
        this.setVariableResolver(other.getVariableResolver());
        this.setVariablePrefixMatcher(other.getVariablePrefixMatcher());
        this.setVariableSuffixMatcher(other.getVariableSuffixMatcher());
        this.setEscapeChar(other.getEscapeChar());
        this.setValueDelimiterMatcher(other.valueDelimiterMatcher);
        this.valueEscapeDelimiterMatcher = other.valueEscapeDelimiterMatcher;
        this.configuration = other.configuration;
        this.enableSubstitutionInVariables = other.isEnableSubstitutionInVariables();
        this.valueDelimiterString = var1_1.valueDelimiterString;
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(Object source, Map<String, String> valueMap) {
        Object object;
        void var1_1;
        return new StrSubstitutor((Map<String, String>)var1_1).replace(object);
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(Object source, Map<String, String> valueMap, String prefix, String suffix) {
        Object object;
        void var3_3;
        void var2_2;
        void var1_1;
        return new StrSubstitutor((Map<String, String>)var1_1, (String)var2_2, (String)var3_3).replace(object);
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(Object source, Properties valueProperties) {
        void var2_2;
        Object object;
        if (valueProperties == null) {
            return Objects.toString(source, null);
        }
        HashMap<String, String> valueMap = new HashMap<String, String>();
        Enumeration<?> propNames = valueProperties.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = valueProperties.getProperty(propName);
            valueMap.put(propName, propValue);
        }
        return StrSubstitutor.replace(object, (Map<String, String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> toTypeSafeMap(Properties properties) {
        void var1_1;
        HashMap<String, String> map = new HashMap<String, String>(properties.size());
        for (String name : properties.stringPropertyNames()) {
            void var3_3;
            map.put(name, properties.getProperty((String)var3_3));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String handleFailedReplacement(String input, Throwable throwable) {
        String string;
        void var1_1;
        StatusLogger.getLogger().error("Replacement failed on {}", (Object)input, (Object)var1_1);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String replace(String source) {
        void var1_1;
        return this.replace(null, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String replace(LogEvent event, String source) {
        void var3_4;
        if (source == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(source);
        try {
            if (!this.substitute(event, buf, 0, source.length())) {
                return source;
            }
        }
        catch (Throwable t) {
            void var1_2;
            void var2_3;
            return StrSubstitutor.handleFailedReplacement((String)var2_3, (Throwable)var1_2);
        }
        return var3_4.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String replace(String source, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.replace(null, (String)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String replace(LogEvent event, String source, int offset, int length) {
        if (source == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(length).append(source, offset, length);
        try {
            if (!this.substitute(event, buf, 0, length)) {
                void var3_4;
                void v0 = var3_4;
                return source.substring((int)v0, (int)(v0 + length));
            }
        }
        catch (Throwable t) {
            void var1_2;
            void var2_3;
            return StrSubstitutor.handleFailedReplacement((String)var2_3, (Throwable)var1_2);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String replace(char[] source) {
        void var1_1;
        return this.replace((LogEvent)null, (char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String replace(LogEvent event, char[] source) {
        void var3_4;
        if (source == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(source.length).append(source);
        try {
            this.substitute(event, buf, 0, source.length);
        }
        catch (Throwable t) {
            void var1_2;
            void var2_3;
            return StrSubstitutor.handleFailedReplacement(new String((char[])var2_3), (Throwable)var1_2);
        }
        return var3_4.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String replace(char[] source, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.replace(null, (char[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String replace(LogEvent event, char[] source, int offset, int length) {
        if (source == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(length).append(source, offset, length);
        try {
            this.substitute(event, buf, 0, length);
        }
        catch (Throwable t) {
            void var1_2;
            void var3_4;
            void var2_3;
            return StrSubstitutor.handleFailedReplacement(new String((char[])var2_3, (int)var3_4, length), (Throwable)var1_2);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String replace(StringBuffer source) {
        void var1_1;
        return this.replace(null, (StringBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String replace(LogEvent event, StringBuffer source) {
        void var3_4;
        if (source == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(source.length()).append(source);
        try {
            this.substitute(event, buf, 0, buf.length());
        }
        catch (Throwable t) {
            void var1_2;
            void var2_3;
            return StrSubstitutor.handleFailedReplacement(var2_3.toString(), (Throwable)var1_2);
        }
        return var3_4.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String replace(StringBuffer source, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.replace(null, (StringBuffer)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String replace(LogEvent event, StringBuffer source, int offset, int length) {
        if (source == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(length).append(source, offset, length);
        try {
            this.substitute(event, buf, 0, length);
        }
        catch (Throwable t) {
            void var1_2;
            void var2_3;
            void var3_4;
            void v0 = var3_4;
            return StrSubstitutor.handleFailedReplacement(var2_3.substring((int)v0, (int)(v0 + length)), (Throwable)var1_2);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String replace(StringBuilder source) {
        void var1_1;
        return this.replace(null, (StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String replace(LogEvent event, StringBuilder source) {
        void var3_4;
        if (source == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(source.length()).append((CharSequence)source);
        try {
            this.substitute(event, buf, 0, buf.length());
        }
        catch (Throwable t) {
            void var1_2;
            void var2_3;
            return StrSubstitutor.handleFailedReplacement(var2_3.toString(), (Throwable)var1_2);
        }
        return var3_4.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String replace(StringBuilder source, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.replace(null, (StringBuilder)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String replace(LogEvent event, StringBuilder source, int offset, int length) {
        if (source == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(length).append(source, offset, length);
        try {
            this.substitute(event, buf, 0, length);
        }
        catch (Throwable t) {
            void var1_2;
            void var2_3;
            void var3_4;
            void v0 = var3_4;
            return StrSubstitutor.handleFailedReplacement(var2_3.substring((int)v0, (int)(v0 + length)), (Throwable)var1_2);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String replace(Object source) {
        void var1_1;
        return this.replace(null, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String replace(LogEvent event, Object source) {
        void var3_4;
        if (source == null) {
            return null;
        }
        String stringValue = String.valueOf(source);
        StringBuilder buf = new StringBuilder(stringValue.length()).append(stringValue);
        try {
            this.substitute(event, buf, 0, buf.length());
        }
        catch (Throwable t) {
            void var1_2;
            void var2_3;
            return StrSubstitutor.handleFailedReplacement((String)var2_3, (Throwable)var1_2);
        }
        return var3_4.toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean replaceIn(StringBuffer source) {
        void var1_1;
        if (source == null) {
            return false;
        }
        return this.replaceIn(source, 0, var1_1.length());
    }

    /*
     * WARNING - void declaration
     */
    public boolean replaceIn(StringBuffer source, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.replaceIn(null, (StringBuffer)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean replaceIn(LogEvent event, StringBuffer source, int offset, int length) {
        void var2_3;
        void var3_4;
        if (source == null) {
            return false;
        }
        StringBuilder buf = new StringBuilder(length).append(source, offset, length);
        try {
            if (!this.substitute(event, buf, 0, length)) {
                return false;
            }
        }
        catch (Throwable t) {
            void var1_2;
            StatusLogger.getLogger().error("Replacement failed on {}", (Object)source, (Object)var1_2);
            return false;
        }
        void v0 = var3_4;
        var2_3.replace((int)v0, (int)(v0 + length), buf.toString());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean replaceIn(StringBuilder source) {
        void var1_1;
        return this.replaceIn(null, (StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean replaceIn(LogEvent event, StringBuilder source) {
        void var2_2;
        void var1_1;
        if (source == null) {
            return false;
        }
        return this.substitute((LogEvent)var1_1, source, 0, var2_2.length());
    }

    /*
     * WARNING - void declaration
     */
    public boolean replaceIn(StringBuilder source, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.replaceIn(null, (StringBuilder)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean replaceIn(LogEvent event, StringBuilder source, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (source == null) {
            return false;
        }
        return this.substitute((LogEvent)var1_1, (StringBuilder)var2_2, (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean substitute(LogEvent event, StringBuilder buf, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.substitute((LogEvent)var1_1, (StringBuilder)var2_2, (int)var3_3, length, null) > 0;
    }

    /*
     * WARNING - void declaration
     */
    private int substitute(LogEvent event, StringBuilder buf, int offset, int length, List<String> priorVariables) {
        StrMatcher prefixMatcher = this.getVariablePrefixMatcher();
        StrMatcher suffixMatcher = this.getVariableSuffixMatcher();
        char escape = this.getEscapeChar();
        StrMatcher valueDelimiterMatcher = this.getValueDelimiterMatcher();
        boolean substitutionInVariablesEnabled = this.isEnableSubstitutionInVariables();
        boolean top = priorVariables == null;
        boolean altered = false;
        int lengthChange = 0;
        char[] chars = this.getChars(buf);
        int bufEnd = offset + length;
        int pos = offset;
        block0: while (pos < bufEnd) {
            int startMatchLen = prefixMatcher.isMatch(chars, pos, offset, bufEnd);
            if (startMatchLen == 0) {
                ++pos;
                continue;
            }
            if (pos > offset && chars[pos - 1] == escape) {
                buf.deleteCharAt(pos - 1);
                chars = this.getChars(buf);
                --lengthChange;
                altered = true;
                --bufEnd;
                continue;
            }
            int startPos = pos;
            pos += startMatchLen;
            int nestedVarCount = 0;
            while (pos < bufEnd) {
                void var19_20;
                void var20_22;
                int endMatchLen;
                if (substitutionInVariablesEnabled && (endMatchLen = prefixMatcher.isMatch(chars, pos, offset, bufEnd)) != 0) {
                    ++nestedVarCount;
                    pos += endMatchLen;
                    continue;
                }
                endMatchLen = suffixMatcher.isMatch(chars, pos, offset, bufEnd);
                if (endMatchLen == 0) {
                    ++pos;
                    continue;
                }
                if (nestedVarCount == 0) {
                    boolean isCyclic;
                    LookupResult resolvedResult;
                    String varValue;
                    String varNameExpr = new String(chars, startPos + startMatchLen, pos - startPos - startMatchLen);
                    if (substitutionInVariablesEnabled) {
                        if (priorVariables == null) {
                            priorVariables = new ArrayList<String>();
                        }
                        StringBuilder bufName = new StringBuilder(varNameExpr);
                        this.substitute(event, bufName, 0, bufName.length(), priorVariables);
                        varNameExpr = bufName.toString();
                    }
                    int endPos = pos += endMatchLen;
                    String varName = varNameExpr;
                    String varDefaultValue = null;
                    if (valueDelimiterMatcher != null) {
                        char[] varNameExprChars = varNameExpr.toCharArray();
                        block2: for (int i = 0; i < varNameExprChars.length; ++i) {
                            int valueDelimiterMatchLen2;
                            if (!substitutionInVariablesEnabled) {
                                int n = i;
                                if (prefixMatcher.isMatch(varNameExprChars, n, n, varNameExprChars.length) != 0) break;
                            }
                            if (this.valueEscapeDelimiterMatcher != null) {
                                int matchLen = this.valueEscapeDelimiterMatcher.isMatch(varNameExprChars, i);
                                if (matchLen != 0) {
                                    String varNamePrefix = varNameExpr.substring(0, i) + ':';
                                    varName = varNamePrefix + varNameExpr.substring(i + matchLen - 1);
                                    for (int j = i + matchLen; j < varNameExprChars.length; ++j) {
                                        int valueDelimiterMatchLen2 = valueDelimiterMatcher.isMatch(varNameExprChars, j);
                                        if (valueDelimiterMatchLen2 == 0) continue;
                                        varName = varNamePrefix + varNameExpr.substring(i + matchLen, j);
                                        varDefaultValue = varNameExpr.substring(j + valueDelimiterMatchLen2);
                                        break block2;
                                    }
                                    break;
                                }
                                valueDelimiterMatchLen2 = valueDelimiterMatcher.isMatch(varNameExprChars, i);
                                if (valueDelimiterMatchLen2 == 0) continue;
                                varName = varNameExpr.substring(0, i);
                                varDefaultValue = varNameExpr.substring(i + valueDelimiterMatchLen2);
                                break;
                            }
                            valueDelimiterMatchLen2 = valueDelimiterMatcher.isMatch(varNameExprChars, i);
                            if (valueDelimiterMatchLen2 == 0) continue;
                            varName = varNameExpr.substring(0, i);
                            varDefaultValue = varNameExpr.substring(i + valueDelimiterMatchLen2);
                            break;
                        }
                    }
                    if (priorVariables == null) {
                        priorVariables = new ArrayList<String>();
                        priorVariables.add(new String(chars, offset, length + lengthChange));
                    }
                    if ((varValue = (resolvedResult = (isCyclic = this.isCyclicSubstitution(varName, priorVariables)) ? null : this.resolveVariable(event, varName, buf, startPos, endPos)) == null ? null : resolvedResult.value()) == null) {
                        varValue = varDefaultValue;
                    }
                    if (varValue != null) {
                        int varLen = varValue.length();
                        buf.replace(startPos, endPos, varValue);
                        altered = true;
                        int varNamePrefix = resolvedResult != null && resolvedResult.isLookupEvaluationAllowedInValue() ? this.substitute(event, buf, startPos, varLen, priorVariables) : 0;
                        int change = varNamePrefix + (varLen - (endPos - startPos));
                        pos += change;
                        bufEnd += change;
                        lengthChange += change;
                        chars = this.getChars(buf);
                    }
                    if (isCyclic) continue block0;
                    List<String> list = priorVariables;
                    list.remove(list.size() - 1);
                    continue block0;
                }
                --var20_22;
                pos += var19_20;
            }
        }
        if (top) {
            if (altered) {
                return 1;
            }
            return 0;
        }
        return lengthChange;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isCyclicSubstitution(String varName, List<String> priorVariables) {
        void var1_1;
        void var2_2;
        if (!priorVariables.contains(varName)) {
            priorVariables.add(varName);
            return false;
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append("Infinite loop in property interpolation of ");
        this.appendWithSeparators(buf, (Iterable<?>)var2_2, "->");
        StatusLogger.getLogger().warn((CharSequence)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected LookupResult resolveVariable(LogEvent event, String variableName, StringBuilder buf, int startPos, int endPos) {
        StrLookup resolver = this.getVariableResolver();
        if (resolver == null) {
            return null;
        }
        try {
            void var3_4;
            return var3_4.evaluate(event, variableName);
        }
        catch (Throwable t) {
            void var1_2;
            void var2_3;
            StatusLogger.getLogger().error("Resolver failed to lookup {}", (Object)var2_3, (Object)var1_2);
            return null;
        }
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    /*
     * WARNING - void declaration
     */
    public void setEscapeChar(char escapeCharacter) {
        void var1_1;
        this.escapeChar = var1_1;
    }

    public StrMatcher getVariablePrefixMatcher() {
        return this.prefixMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor setVariablePrefixMatcher(StrMatcher prefixMatcher) {
        void var1_1;
        if (prefixMatcher == null) {
            throw new IllegalArgumentException("Variable prefix matcher must not be null!");
        }
        this.prefixMatcher = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor setVariablePrefix(char prefix) {
        void var1_1;
        return this.setVariablePrefixMatcher(StrMatcher.charMatcher((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor setVariablePrefix(String prefix) {
        void var1_1;
        if (prefix == null) {
            throw new IllegalArgumentException("Variable prefix must not be null!");
        }
        return this.setVariablePrefixMatcher(StrMatcher.stringMatcher((String)var1_1));
    }

    public StrMatcher getVariableSuffixMatcher() {
        return this.suffixMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor setVariableSuffixMatcher(StrMatcher suffixMatcher) {
        void var1_1;
        if (suffixMatcher == null) {
            throw new IllegalArgumentException("Variable suffix matcher must not be null!");
        }
        this.suffixMatcher = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor setVariableSuffix(char suffix) {
        void var1_1;
        return this.setVariableSuffixMatcher(StrMatcher.charMatcher((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor setVariableSuffix(String suffix) {
        void var1_1;
        if (suffix == null) {
            throw new IllegalArgumentException("Variable suffix must not be null!");
        }
        return this.setVariableSuffixMatcher(StrMatcher.stringMatcher((String)var1_1));
    }

    public StrMatcher getValueDelimiterMatcher() {
        return this.valueDelimiterMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor setValueDelimiterMatcher(StrMatcher valueDelimiterMatcher) {
        void var1_1;
        this.valueDelimiterMatcher = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor setValueDelimiter(char valueDelimiter) {
        void var1_1;
        return this.setValueDelimiterMatcher(StrMatcher.charMatcher((char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public StrSubstitutor setValueDelimiter(String valueDelimiter) {
        void var1_1;
        void var2_2;
        if (Strings.isEmpty((CharSequence)valueDelimiter)) {
            this.setValueDelimiterMatcher(null);
            return this;
        }
        String string = valueDelimiter;
        String escapeValue = valueDelimiter.substring(0, valueDelimiter.length() - 1) + "\\" + string.substring(string.length() - 1);
        this.valueEscapeDelimiterMatcher = StrMatcher.stringMatcher((String)var2_2);
        return this.setValueDelimiterMatcher(StrMatcher.stringMatcher((String)var1_1));
    }

    public StrLookup getVariableResolver() {
        return this.variableResolver;
    }

    /*
     * WARNING - void declaration
     */
    public void setVariableResolver(StrLookup variableResolver) {
        void var1_1;
        if (variableResolver instanceof ConfigurationAware && this.configuration != null) {
            ((ConfigurationAware)((Object)variableResolver)).setConfiguration(this.configuration);
        }
        this.variableResolver = var1_1;
    }

    public boolean isEnableSubstitutionInVariables() {
        return this.enableSubstitutionInVariables;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableSubstitutionInVariables(boolean enableSubstitutionInVariables) {
        void var1_1;
        this.enableSubstitutionInVariables = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private char[] getChars(StringBuilder sb) {
        void var2_2;
        void var1_1;
        char[] chars = new char[sb.length()];
        sb.getChars(0, var1_1.length(), chars, 0);
        return var2_2;
    }

    public void appendWithSeparators(StringBuilder sb, Iterable<?> iterable, String separator) {
        if (iterable != null) {
            separator = separator == null ? "" : separator;
            Iterator<?> it = iterable.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(separator);
            }
        }
    }

    public String toString() {
        return "StrSubstitutor(" + this.variableResolver.toString() + ')';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConfiguration(Configuration configuration) {
        void var1_1;
        this.configuration = var1_1;
        if (this.variableResolver instanceof ConfigurationAware) {
            ((ConfigurationAware)((Object)this.variableResolver)).setConfiguration(this.configuration);
        }
    }
}

