/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.lookup.LookupResult;
import org.apache.logging.log4j.core.lookup.StrLookup;

public final class PropertiesLookup
implements StrLookup {
    private final Map<String, String> contextProperties;
    private final Map<String, ConfigurationPropertyResult> configurationProperties;

    /*
     * WARNING - void declaration
     */
    public PropertiesLookup(Property[] configProperties, Map<String, String> contextProperties) {
        void var1_1;
        void var2_2;
        this.contextProperties = contextProperties == null ? Collections.emptyMap() : var2_2;
        this.configurationProperties = configProperties == null ? Collections.emptyMap() : PropertiesLookup.createConfigurationPropertyMap((Property[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public PropertiesLookup(Map<String, String> properties) {
        this(Property.EMPTY_ARRAY, (Map<String, String>)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String lookup(LogEvent event, String key) {
        void var2_2;
        return this.lookup((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String lookup(String key) {
        void var1_1;
        LookupResult result = this.evaluate(key);
        if (result == null) {
            return null;
        }
        return var1_1.value();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final LookupResult evaluate(String key) {
        void var1_1;
        if (key == null) {
            return null;
        }
        LookupResult configResult = this.configurationProperties.get(key);
        if (configResult != null) {
            void var2_2;
            return var2_2;
        }
        String contextResult = this.contextProperties.get(key);
        if (contextResult == null) {
            return null;
        }
        return new ContextPropertyResult((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final LookupResult evaluate(LogEvent event, String key) {
        void var2_2;
        return this.evaluate((String)var2_2);
    }

    public final String toString() {
        return "PropertiesLookup{contextProperties=" + this.contextProperties + ", configurationProperties=" + this.configurationProperties + '}';
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, ConfigurationPropertyResult> createConfigurationPropertyMap(Property[] props) {
        void var1_1;
        Property[] propertyArray;
        HashMap<String, ConfigurationPropertyResult> result = new HashMap<String, ConfigurationPropertyResult>(props.length);
        for (Property property : propertyArray) {
            result.put(property.getName(), new ConfigurationPropertyResult(property.getRawValue()));
        }
        return var1_1;
    }

    private static final class ContextPropertyResult
    implements LookupResult {
        private final String value;

        /*
         * WARNING - void declaration
         */
        ContextPropertyResult(String value) {
            void var1_1;
            this.value = (String)Objects.requireNonNull(var1_1, "value is required");
        }

        @Override
        public final String value() {
            return this.value;
        }

        @Override
        public final boolean isLookupEvaluationAllowedInValue() {
            return false;
        }

        public final String toString() {
            return "ContextPropertyResult{'" + this.value + "'}";
        }
    }

    private static final class ConfigurationPropertyResult
    implements LookupResult {
        private final String value;

        /*
         * WARNING - void declaration
         */
        ConfigurationPropertyResult(String value) {
            void var1_1;
            this.value = (String)Objects.requireNonNull(var1_1, "value is required");
        }

        @Override
        public final String value() {
            return this.value;
        }

        @Override
        public final boolean isLookupEvaluationAllowedInValue() {
            return true;
        }

        public final String toString() {
            return "ConfigurationPropertyResult{'" + this.value + "'}";
        }
    }
}

