/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.AbstractConfigurationAwareLookup;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="log4j", category="Lookup")
public class Log4jLookup
extends AbstractConfigurationAwareLookup {
    public static final String KEY_CONFIG_LOCATION = "configLocation";
    public static final String KEY_CONFIG_PARENT_LOCATION = "configParentLocation";
    private static final Logger LOGGER = StatusLogger.getLogger();

    private static String asPath(URI uri) {
        URI uRI;
        if (uri.getScheme() == null || uri.getScheme().equals("file")) {
            return uri.getPath();
        }
        return uRI.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static URI getParent(URI uri) throws URISyntaxException {
        String s = uri.toString();
        int offset = s.lastIndexOf(47);
        if (offset >= 0) {
            void var1_1;
            String string;
            return new URI(string.substring(0, (int)var1_1));
        }
        return new URI("../");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String lookup(LogEvent event, String key) {
        if (this.configuration != null) {
            Object configSrc = this.configuration.getConfigurationSource();
            File file = ((ConfigurationSource)configSrc).getFile();
            if (file != null) {
                switch (key) {
                    case "configLocation": {
                        return file.getAbsolutePath();
                    }
                    case "configParentLocation": {
                        void var3_5;
                        return var3_5.getParentFile().getAbsolutePath();
                    }
                }
                return null;
            }
            URL url = ((ConfigurationSource)configSrc).getURL();
            if (url != null) {
                try {
                    int n = -1;
                    switch (key.hashCode()) {
                        case -1277483753: {
                            if (!key.equals(KEY_CONFIG_LOCATION)) break;
                            n = 0;
                            break;
                        }
                        case -1024117151: {
                            if (!key.equals(KEY_CONFIG_PARENT_LOCATION)) break;
                            n = 1;
                        }
                    }
                    switch (n) {
                        case 0: {
                            return Log4jLookup.asPath(url.toURI());
                        }
                        case 1: {
                            void var1_1;
                            return Log4jLookup.asPath(Log4jLookup.getParent(var1_1.toURI()));
                        }
                    }
                    return null;
                }
                catch (URISyntaxException use) {
                    void var2_4;
                    LOGGER.error((Object)var2_4);
                }
            }
        }
        return null;
    }
}

