/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.Objects;
import javax.naming.NamingException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.core.net.JndiManager;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="jndi", category="Lookup")
public class JndiLookup
extends AbstractLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Marker LOOKUP = MarkerManager.getMarker((String)"LOOKUP");
    static final String CONTAINER_JNDI_RESOURCE_PATH_PREFIX = "java:comp/env/";

    public JndiLookup() {
        if (!JndiManager.isJndiLookupEnabled()) {
            throw new IllegalStateException("JNDI must be enabled by setting log4j2.enableJndiLookup=true");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String lookup(LogEvent event, String key) {
        if (key == null) {
            return null;
        }
        String jndiName = this.convertJndiName(key);
        JndiManager jndiManager2 = JndiManager.getDefaultManager();
        Throwable throwable = null;
        try {
            String string = Objects.toString(jndiManager2.lookup(jndiName), null);
            if (jndiManager2 != null) {
                jndiManager2.close();
            }
            return string;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (jndiManager2 != null) {
                        if (throwable != null) {
                            try {
                                jndiManager2.close();
                            }
                            catch (Throwable jndiManager2) {
                                throwable.addSuppressed(jndiManager2);
                            }
                        } else {
                            jndiManager2.close();
                        }
                    }
                    throw throwable4;
                }
            }
            catch (NamingException e) {
                void var2_4;
                void var1_1;
                LOGGER.warn(LOOKUP, "Error looking up JNDI resource [{}].", (Object)var1_1, (Object)var2_4);
                return null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String convertJndiName(String jndiName) {
        void var1_1;
        if (!jndiName.startsWith(CONTAINER_JNDI_RESOURCE_PATH_PREFIX) && jndiName.indexOf(58) == -1) {
            return CONTAINER_JNDI_RESOURCE_PATH_PREFIX + jndiName;
        }
        return var1_1;
    }
}

