/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationAware;
import org.apache.logging.log4j.core.config.LoggerContextAware;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.lookup.AbstractConfigurationAwareLookup;
import org.apache.logging.log4j.core.lookup.LookupResult;
import org.apache.logging.log4j.core.lookup.PropertiesLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.net.JndiManager;
import org.apache.logging.log4j.core.util.ReflectionUtil;
import org.apache.logging.log4j.status.StatusLogger;

public class Interpolator
extends AbstractConfigurationAwareLookup
implements LoggerContextAware {
    public static final char PREFIX_SEPARATOR = ':';
    private static final String LOOKUP_KEY_WEB = "web";
    private static final String LOOKUP_KEY_DOCKER = "docker";
    private static final String LOOKUP_KEY_KUBERNETES = "kubernetes";
    private static final String LOOKUP_KEY_SPRING = "spring";
    private static final String LOOKUP_KEY_JNDI = "jndi";
    private static final String LOOKUP_KEY_JVMRUNARGS = "jvmrunargs";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Map<String, StrLookup> strLookupMap = new HashMap<String, StrLookup>();
    private final StrLookup defaultLookup;
    protected WeakReference<LoggerContext> loggerContext;

    /*
     * WARNING - void declaration
     */
    public Interpolator(StrLookup defaultLookup) {
        this((StrLookup)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Interpolator(StrLookup defaultLookup, List<String> pluginPackages) {
        Map<String, PluginType<?>> map;
        this.defaultLookup = defaultLookup == null ? new PropertiesLookup(new HashMap<String, String>()) : defaultLookup;
        PluginManager manager = new PluginManager("Lookup");
        manager.collectPlugins(pluginPackages);
        map = ((PluginManager)((Object)map)).getPlugins();
        for (Map.Entry entry : map.entrySet()) {
            try {
                Class<StrLookup> clazz = ((PluginType)entry.getValue()).getPluginClass().asSubclass(StrLookup.class);
                if (clazz.getName().equals("org.apache.logging.log4j.core.lookup.JndiLookup") && !JndiManager.isJndiLookupEnabled()) continue;
                this.strLookupMap.put(((String)entry.getKey()).toLowerCase(), ReflectionUtil.instantiate(clazz));
            }
            catch (Throwable t) {
                void var3_6;
                void var2_4;
                this.handleError((String)var2_4.getKey(), (Throwable)var3_6);
            }
        }
    }

    public Interpolator() {
        this((Map<String, String>)null);
    }

    /*
     * WARNING - void declaration
     */
    public Interpolator(Map<String, String> properties) {
        this(new PropertiesLookup((Map<String, String>)var1_1), Collections.emptyList());
        void var1_1;
    }

    public StrLookup getDefaultLookup() {
        return this.defaultLookup;
    }

    public Map<String, StrLookup> getStrLookupMap() {
        return this.strLookupMap;
    }

    /*
     * WARNING - void declaration
     */
    private void handleError(String lookupKey, Throwable t) {
        switch (lookupKey) {
            case "jndi": {
                LOGGER.warn("JNDI lookup class is not available because this JRE does not support JNDI. JNDI string lookups will not be available, continuing configuration. Ignoring " + t);
                return;
            }
            case "jvmrunargs": {
                LOGGER.warn("JMX runtime input lookup class is not available because this JRE does not support JMX. JMX lookups will not be available, continuing configuration. Ignoring " + t);
                return;
            }
            case "web": {
                LOGGER.info("Log4j appears to be running in a Servlet environment, but there's no log4j-web module available. If you want better web container support, please add the log4j-web JAR to your web archive or server lib directory.");
                return;
            }
            case "docker": 
            case "spring": {
                return;
            }
            case "kubernetes": {
                if (!(t instanceof NoClassDefFoundError)) break;
                LOGGER.warn("Unable to create Kubernetes lookup due to missing dependency: {}", (Object)t.getMessage());
                return;
            }
            default: {
                void var2_2;
                void var1_1;
                LOGGER.error("Unable to create Lookup for {}", (Object)var1_1, (Object)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String lookup(LogEvent event, String var) {
        void var1_1;
        void var2_2;
        LookupResult result = this.evaluate(event, (String)var2_2);
        if (result == null) {
            return null;
        }
        return var1_1.value();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LookupResult evaluate(LogEvent event, String var) {
        if (var == null) {
            return null;
        }
        int prefixPos = var.indexOf(58);
        if (prefixPos >= 0) {
            void var3_3;
            String prefix = var.substring(0, prefixPos).toLowerCase(Locale.US);
            String name = var.substring(prefixPos + 1);
            StrLookup lookup = this.strLookupMap.get(prefix);
            if (lookup instanceof ConfigurationAware) {
                ((ConfigurationAware)((Object)lookup)).setConfiguration(this.configuration);
            }
            if (lookup instanceof LoggerContextAware) {
                ((LoggerContextAware)((Object)lookup)).setLoggerContext((LoggerContext)this.loggerContext.get());
            }
            LookupResult value = null;
            if (lookup != null) {
                LookupResult lookupResult = value = event == null ? lookup.evaluate(name) : lookup.evaluate(event, name);
            }
            if (value != null) {
                return value;
            }
            var = var.substring((int)(var3_3 + true));
        }
        if (this.defaultLookup != null) {
            void var2_2;
            void var1_1;
            if (event == null) {
                return this.defaultLookup.evaluate(var);
            }
            return this.defaultLookup.evaluate((LogEvent)var1_1, (String)var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLoggerContext(LoggerContext loggerContext) {
        void var1_1;
        if (loggerContext == null) {
            return;
        }
        this.loggerContext = new WeakReference<void>(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        for (String name : this.strLookupMap.keySet()) {
            void var3_3;
            if (sb.length() == 0) {
                sb.append('{');
            } else {
                sb.append(", ");
            }
            sb.append((String)var3_3);
        }
        if (sb.length() > 0) {
            sb.append('}');
        }
        return var1_1.toString();
    }
}

