/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="date", category="Lookup")
public class DateLookup
implements StrLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Marker LOOKUP = MarkerManager.getMarker((String)"LOOKUP");

    /*
     * WARNING - void declaration
     */
    @Override
    public String lookup(String key) {
        void var1_1;
        return this.formatDate(System.currentTimeMillis(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String lookup(LogEvent event, String key) {
        void var2_2;
        void var1_1;
        if (event == null) {
            return this.lookup(key);
        }
        return this.formatDate(var1_1.getTimeMillis(), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private String formatDate(long date, String format) {
        void var1_1;
        DateFormat dateFormat = null;
        if (format != null) {
            try {
                dateFormat = new SimpleDateFormat(format);
            }
            catch (Exception ex) {
                void var3_2;
                LOGGER.error(LOOKUP, "Invalid date format: [{}], using default", (Object)var3_2, (Object)ex);
            }
        }
        if (dateFormat == null) {
            dateFormat = DateFormat.getInstance();
        }
        return dateFormat.format(new Date((long)var1_1));
    }
}

