/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.ByteBufferDestinationHelper;

public class TextEncoderHelper {
    private TextEncoderHelper() {
    }

    /*
     * WARNING - void declaration
     */
    static void encodeTextFallBack(Charset charset, StringBuilder text, ByteBufferDestination destination) {
        Object object;
        void var2_2;
        Object bytes = text.toString().getBytes(charset);
        var2_2.writeBytes((byte[])bytes, 0, ((Object)object).length);
    }

    /*
     * WARNING - void declaration
     */
    public static void encodeText(CharsetEncoder charsetEncoder, CharBuffer charBuf, ByteBuffer byteBuf, StringBuilder text, ByteBufferDestination destination) {
        void var3_3;
        void var2_2;
        void var1_1;
        CharsetEncoder charsetEncoder2;
        charsetEncoder.reset();
        if (text.length() > charBuf.capacity()) {
            TextEncoderHelper.encodeChunkedText(charsetEncoder, charBuf, byteBuf, text, destination);
            return;
        }
        charBuf.clear();
        text.getChars(0, text.length(), charBuf.array(), charBuf.arrayOffset());
        charBuf.limit(text.length());
        CoderResult result = charsetEncoder.encode(charBuf, byteBuf, true);
        TextEncoderHelper.writeEncodedText(charsetEncoder2, (CharBuffer)var1_1, (ByteBuffer)var2_2, destination, (CoderResult)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeEncodedText(CharsetEncoder charsetEncoder, CharBuffer charBuf, ByteBuffer byteBuf, ByteBufferDestination destination, CoderResult result) {
        ByteBufferDestination byteBufferDestination;
        if (!result.isUnderflow()) {
            TextEncoderHelper.writeChunkedEncodedText(charsetEncoder, (CharBuffer)((Object)byteBufferDestination), destination, byteBuf, result);
            return;
        }
        CoderResult coderResult = charsetEncoder.flush(byteBuf);
        if (!coderResult.isUnderflow()) {
            byteBufferDestination = destination;
            synchronized (byteBufferDestination) {
                CharsetEncoder charsetEncoder2;
                TextEncoderHelper.flushRemainingBytes(charsetEncoder2, destination, byteBuf);
                return;
            }
        }
        if (byteBuf != destination.getByteBuffer()) {
            void var2_3;
            void var3_4;
            byteBuf.flip();
            var3_4.writeBytes(byteBuf);
            var2_3.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writeChunkedEncodedText(CharsetEncoder charsetEncoder, CharBuffer charBuf, ByteBufferDestination destination, ByteBuffer byteBuf, CoderResult result) {
        ByteBufferDestination byteBufferDestination = destination;
        synchronized (byteBufferDestination) {
            void var3_4;
            void var2_3;
            CharsetEncoder charsetEncoder2;
            void var1_2;
            byteBuf = TextEncoderHelper.writeAndEncodeAsMuchAsPossible(charsetEncoder, (CharBuffer)var1_2, true, destination, byteBuf, result);
            TextEncoderHelper.flushRemainingBytes(charsetEncoder2, (ByteBufferDestination)var2_3, (ByteBuffer)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void encodeChunkedText(CharsetEncoder charsetEncoder, CharBuffer charBuf, ByteBuffer byteBuf, StringBuilder text, ByteBufferDestination destination) {
        int start = 0;
        CoderResult result = CoderResult.UNDERFLOW;
        boolean endOfInput = false;
        while (!endOfInput && result.isUnderflow()) {
            charBuf.clear();
            int copied = TextEncoderHelper.copy(text, start, charBuf);
            endOfInput = (start += copied) >= text.length();
            charBuf.flip();
            result = charsetEncoder.encode(charBuf, byteBuf, endOfInput);
        }
        if (endOfInput) {
            TextEncoderHelper.writeEncodedText(charsetEncoder, charBuf, byteBuf, destination, result);
            return;
        }
        ByteBufferDestination byteBufferDestination = destination;
        synchronized (byteBufferDestination) {
            void var2_3;
            CharsetEncoder charsetEncoder2;
            byteBuf = TextEncoderHelper.writeAndEncodeAsMuchAsPossible(charsetEncoder, charBuf, endOfInput, destination, byteBuf, result);
            while (!endOfInput) {
                CoderResult coderResult;
                result = CoderResult.UNDERFLOW;
                while (!endOfInput && result.isUnderflow()) {
                    charBuf.clear();
                    int copied = TextEncoderHelper.copy(text, start, charBuf);
                    endOfInput = (start += copied) >= text.length();
                    charBuf.flip();
                    coderResult = charsetEncoder.encode(charBuf, byteBuf, endOfInput);
                }
                byteBuf = TextEncoderHelper.writeAndEncodeAsMuchAsPossible(charsetEncoder, charBuf, endOfInput, destination, byteBuf, coderResult);
            }
            TextEncoderHelper.flushRemainingBytes(charsetEncoder2, destination, (ByteBuffer)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void encodeText(CharsetEncoder charsetEncoder, CharBuffer charBuf, ByteBufferDestination destination) {
        charsetEncoder.reset();
        ByteBufferDestination byteBufferDestination = destination;
        synchronized (byteBufferDestination) {
            void var2_3;
            CharsetEncoder charsetEncoder2;
            void var1_2;
            ByteBuffer byteBuf = destination.getByteBuffer();
            byteBuf = TextEncoderHelper.encodeAsMuchAsPossible(charsetEncoder, (CharBuffer)var1_2, true, destination, byteBuf);
            TextEncoderHelper.flushRemainingBytes(charsetEncoder2, (ByteBufferDestination)var2_3, byteBuf);
            return;
        }
    }

    private static ByteBuffer writeAndEncodeAsMuchAsPossible(CharsetEncoder charsetEncoder, CharBuffer charBuf, boolean endOfInput, ByteBufferDestination destination, ByteBuffer temp, CoderResult result) {
        while (true) {
            temp = TextEncoderHelper.drainIfByteBufferFull(destination, temp, result);
            if (!result.isOverflow()) break;
            result = charsetEncoder.encode(charBuf, temp, endOfInput);
        }
        if (!result.isUnderflow()) {
            TextEncoderHelper.throwException(result);
        }
        return temp;
    }

    /*
     * WARNING - void declaration
     */
    private static void throwException(CoderResult result) {
        try {
            result.throwException();
            return;
        }
        catch (CharacterCodingException e) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    private static ByteBuffer encodeAsMuchAsPossible(CharsetEncoder charsetEncoder, CharBuffer charBuf, boolean endOfInput, ByteBufferDestination destination, ByteBuffer temp) {
        CoderResult result;
        do {
            result = charsetEncoder.encode(charBuf, temp, endOfInput);
            temp = TextEncoderHelper.drainIfByteBufferFull(destination, temp, result);
        } while (result.isOverflow());
        if (!result.isUnderflow()) {
            TextEncoderHelper.throwException(result);
        }
        return temp;
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuffer drainIfByteBufferFull(ByteBufferDestination destination, ByteBuffer temp, CoderResult result) {
        void var1_2;
        if (result.isOverflow()) {
            ByteBufferDestination byteBufferDestination = destination;
            synchronized (byteBufferDestination) {
                void var3_4;
                ByteBufferDestination byteBufferDestination2;
                ByteBuffer destinationBuffer = destination.getByteBuffer();
                if (destinationBuffer != temp) {
                    temp.flip();
                    ByteBufferDestinationHelper.writeToUnsynchronized(temp, destination);
                    temp.clear();
                    return destination.getByteBuffer();
                }
                return byteBufferDestination2.drain((ByteBuffer)var3_4);
            }
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private static void flushRemainingBytes(CharsetEncoder charsetEncoder, ByteBufferDestination destination, ByteBuffer temp) {
        CoderResult result;
        do {
            result = charsetEncoder.flush(temp);
            temp = TextEncoderHelper.drainIfByteBufferFull(destination, temp, result);
        } while (result.isOverflow());
        if (!result.isUnderflow()) {
            void var3_3;
            TextEncoderHelper.throwException((CoderResult)var3_3);
        }
        if (temp.remaining() > 0 && temp != destination.getByteBuffer()) {
            void var2_2;
            void var1_1;
            temp.flip();
            ByteBufferDestinationHelper.writeToUnsynchronized(temp, (ByteBufferDestination)var1_1);
            var2_2.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    static int copy(StringBuilder source, int offset, CharBuffer destination) {
        void var3_3;
        void var2_2;
        StringBuilder stringBuilder;
        void var1_1;
        int length = Math.min(source.length() - offset, destination.remaining());
        char[] array = destination.array();
        int start = destination.position();
        void v0 = var1_1;
        stringBuilder.getChars((int)v0, (int)(v0 + length), array, destination.arrayOffset() + start);
        var2_2.position(start + length);
        return (int)var3_3;
    }
}

