/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.net.Priority;
import org.apache.logging.log4j.core.util.NetUtils;

@Plugin(name="SyslogLayout", category="Core", elementType="layout", printObject=true)
public final class SyslogLayout
extends AbstractStringLayout {
    public static final Pattern NEWLINE_PATTERN = Pattern.compile("\\r?\\n");
    private final Facility facility;
    private final boolean includeNewLine;
    private final String escapeNewLine;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.ENGLISH);
    private final String localHostname = NetUtils.getLocalHostname();

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    /*
     * WARNING - void declaration
     */
    protected SyslogLayout(Facility facility, boolean includeNL, String escapeNL, Charset charset) {
        super(charset);
        void var3_3;
        void var2_2;
        void var1_1;
        this.facility = var1_1;
        this.includeNewLine = var2_2;
        this.escapeNewLine = escapeNL == null ? null : Matcher.quoteReplacement((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toSerializable(LogEvent event) {
        void var2_2;
        void var1_1;
        StringBuilder buf = SyslogLayout.getStringBuilder();
        buf.append('<');
        buf.append(Priority.getPriority(this.facility, event.getLevel()));
        buf.append('>');
        this.addDate(event.getTimeMillis(), buf);
        buf.append(' ');
        buf.append(this.localHostname);
        buf.append(' ');
        String message = event.getMessage().getFormattedMessage();
        if (this.escapeNewLine != null) {
            message = NEWLINE_PATTERN.matcher(message).replaceAll(this.escapeNewLine);
        }
        buf.append((String)var1_1);
        if (this.includeNewLine) {
            buf.append('\n');
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void addDate(long timestamp, StringBuilder buf) {
        void var1_1;
        int index = buf.length() + 4;
        buf.append(this.dateFormat.format(new Date((long)var1_1)));
        if (buf.charAt(index) == '0') {
            void var3_2;
            var3_2.setCharAt(index, ' ');
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<String, String> getContentFormat() {
        void var1_1;
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("structured", "false");
        result.put("formatType", "logfilepatternreceiver");
        result.put("dateFormat", this.dateFormat.toPattern());
        result.put("format", "<LEVEL>TIMESTAMP PROP(HOSTNAME) MESSAGE");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SyslogLayout createLayout(Facility facility, boolean includeNewLine, String escapeNL, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        Facility facility2;
        return new SyslogLayout(facility2, (boolean)var1_1, (String)var2_2, (Charset)var3_3);
    }

    public final Facility getFacility() {
        return this.facility;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractStringLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<SyslogLayout> {
        @PluginBuilderAttribute
        private Facility facility = Facility.LOCAL0;
        @PluginBuilderAttribute(value="newLine")
        private boolean includeNewLine;
        @PluginBuilderAttribute(value="newLineEscape")
        private String escapeNL;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        @Override
        public SyslogLayout build() {
            return new SyslogLayout(this.facility, this.includeNewLine, this.escapeNL, this.getCharset());
        }

        public Facility getFacility() {
            return this.facility;
        }

        public boolean isIncludeNewLine() {
            return this.includeNewLine;
        }

        public String getEscapeNL() {
            return this.escapeNL;
        }

        /*
         * WARNING - void declaration
         */
        public B setFacility(Facility facility) {
            void var1_1;
            this.facility = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setIncludeNewLine(boolean includeNewLine) {
            void var1_1;
            this.includeNewLine = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setEscapeNL(String escapeNL) {
            void var1_1;
            this.escapeNL = var1_1;
            return (B)((Builder)this.asBuilder());
        }
    }
}

