/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.TextEncoderHelper;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.status.StatusLogger;

public class StringBuilderEncoder
implements Encoder<StringBuilder> {
    private final ThreadLocal<Object[]> threadLocal = new ThreadLocal();
    private final Charset charset;
    private final int charBufferSize;
    private final int byteBufferSize;

    /*
     * WARNING - void declaration
     */
    public StringBuilderEncoder(Charset charset) {
        this((Charset)var1_1, Constants.ENCODER_CHAR_BUFFER_SIZE, Constants.ENCODER_BYTE_BUFFER_SIZE);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StringBuilderEncoder(Charset charset, int charBufferSize, int byteBufferSize) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.charBufferSize = var2_2;
        this.byteBufferSize = var3_3;
        this.charset = (Charset)Objects.requireNonNull(var1_1, "charset");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void encode(StringBuilder source, ByteBufferDestination destination) {
        try {
            void var3_3;
            Object[] threadLocalState = this.getThreadLocalState();
            CharsetEncoder charsetEncoder = (CharsetEncoder)threadLocalState[0];
            CharBuffer charBuffer = (CharBuffer)threadLocalState[1];
            ByteBuffer byteBuffer = (ByteBuffer)threadLocalState[2];
            TextEncoderHelper.encodeText(charsetEncoder, charBuffer, (ByteBuffer)var3_3, source, destination);
            return;
        }
        catch (Exception exception) {
            void var2_2;
            void var1_1;
            Exception exception2 = exception;
            StringBuilderEncoder.logEncodeTextException(exception, source);
            TextEncoderHelper.encodeTextFallBack(this.charset, (StringBuilder)var1_1, (ByteBufferDestination)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object[] getThreadLocalState() {
        void var1_1;
        Object[] threadLocalState = this.threadLocal.get();
        if (threadLocalState == null) {
            threadLocalState = new Object[]{this.charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), CharBuffer.allocate(this.charBufferSize), ByteBuffer.allocate(this.byteBufferSize)};
            this.threadLocal.set(threadLocalState);
        } else {
            ((CharsetEncoder)threadLocalState[0]).reset();
            ((CharBuffer)threadLocalState[1]).clear();
            ((ByteBuffer)threadLocalState[2]).clear();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static void logEncodeTextException(Exception ex, StringBuilder text) {
        void var1_1;
        Exception exception;
        Exception exception2 = exception;
        StatusLogger.getLogger().error("Recovering from StringBuilderEncoder.encode('{}') error: {}", (Object)var1_1, (Object)exception2, (Object)exception2);
    }
}

