/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.PatternMatch;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptRef;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="ScriptPatternSelector", category="Core", elementType="patternSelector", printObject=true)
public class ScriptPatternSelector
implements LocationAware,
PatternSelector {
    private final Map<String, PatternFormatter[]> formatterMap = new HashMap<String, PatternFormatter[]>();
    private final Map<String, String> patternMap = new HashMap<String, String>();
    private final PatternFormatter[] defaultFormatters;
    private final String defaultPattern;
    private static Logger LOGGER = StatusLogger.getLogger();
    private final AbstractScript script;
    private final Configuration configuration;
    private final boolean requiresLocation;

    /*
     * WARNING - void declaration
     */
    private ScriptPatternSelector(Configuration config, AbstractScript script, PatternMatch[] properties, String defaultPattern, boolean alwaysWriteExceptions, boolean disableAnsi, boolean noConsoleNoAnsi) {
        void var2_3;
        this.script = script;
        this.configuration = config;
        PatternParser parser = PatternLayout.createPatternParser(config);
        boolean needsLocation = false;
        for (PatternMatch property : properties) {
            try {
                List<PatternFormatter> list = parser.parse(property.getPattern(), alwaysWriteExceptions, disableAnsi, noConsoleNoAnsi);
                PatternFormatter[] formatters = list.toArray(PatternFormatter.EMPTY_ARRAY);
                this.formatterMap.put(property.getKey(), formatters);
                this.patternMap.put(property.getKey(), property.getPattern());
                for (int i = 0; !needsLocation && i < formatters.length; ++i) {
                    needsLocation = formatters[i].requiresLocation();
                }
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException("Cannot parse pattern '" + property.getPattern() + "'", ex);
            }
        }
        try {
            void var1_1;
            List<PatternFormatter> list = var1_1.parse(defaultPattern, alwaysWriteExceptions, disableAnsi, noConsoleNoAnsi);
            this.defaultFormatters = list.toArray(PatternFormatter.EMPTY_ARRAY);
            this.defaultPattern = defaultPattern;
            for (int i = 0; !needsLocation && i < this.defaultFormatters.length; ++i) {
                needsLocation = this.defaultFormatters[i].requiresLocation();
            }
        }
        catch (RuntimeException ex) {
            void var3_5;
            throw new IllegalArgumentException("Cannot parse pattern '" + defaultPattern + "'", (Throwable)var3_5);
        }
        this.requiresLocation = var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ScriptPatternSelector(AbstractScript script, PatternMatch[] properties, String defaultPattern, boolean alwaysWriteExceptions, boolean disableAnsi, boolean noConsoleNoAnsi, Configuration config) {
        this.script = script;
        this.configuration = config;
        if (!(script instanceof ScriptRef)) {
            config.getScriptManager().addScript(script);
        }
        PatternParser parser = PatternLayout.createPatternParser(config);
        boolean needsLocation = false;
        for (PatternMatch property : properties) {
            try {
                List<PatternFormatter> list = parser.parse(property.getPattern(), alwaysWriteExceptions, disableAnsi, noConsoleNoAnsi);
                PatternFormatter[] formatters = list.toArray(PatternFormatter.EMPTY_ARRAY);
                this.formatterMap.put(property.getKey(), formatters);
                this.patternMap.put(property.getKey(), property.getPattern());
                for (int i = 0; !needsLocation && i < formatters.length; ++i) {
                    needsLocation = formatters[i].requiresLocation();
                }
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException("Cannot parse pattern '" + property.getPattern() + "'", ex);
            }
        }
        try {
            void var1_1;
            List<PatternFormatter> list = var1_1.parse(defaultPattern, alwaysWriteExceptions, disableAnsi, noConsoleNoAnsi);
            this.defaultFormatters = list.toArray(PatternFormatter.EMPTY_ARRAY);
            this.defaultPattern = defaultPattern;
            for (int i = 0; !needsLocation && i < this.defaultFormatters.length; ++i) {
                needsLocation = this.defaultFormatters[i].requiresLocation();
            }
        }
        catch (RuntimeException ex) {
            void var2_3;
            void var3_4;
            throw new IllegalArgumentException("Cannot parse pattern '" + (String)var3_4 + "'", (Throwable)var2_3);
        }
        this.requiresLocation = needsLocation;
    }

    @Override
    public boolean requiresLocation() {
        return this.requiresLocation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PatternFormatter[] getFormatters(LogEvent event) {
        void var1_1;
        void var2_2;
        SimpleBindings bindings = new SimpleBindings();
        bindings.putAll((Map<? extends String, ? extends Object>)this.configuration.getProperties());
        bindings.put("substitutor", (Object)this.configuration.getStrSubstitutor());
        bindings.put("logEvent", (Object)event);
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), (Bindings)var2_2);
        if (object == null) {
            return this.defaultFormatters;
        }
        PatternFormatter[] patternFormatter = this.formatterMap.get(object.toString());
        if (patternFormatter == null) {
            return this.defaultFormatters;
        }
        return var1_1;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static ScriptPatternSelector createSelector(AbstractScript script, PatternMatch[] properties, String defaultPattern, boolean alwaysWriteExceptions, boolean noConsoleNoAnsi, Configuration configuration) {
        void var3_3;
        void var2_2;
        void var1_1;
        AbstractScript abstractScript;
        Builder builder = ScriptPatternSelector.newBuilder();
        builder.setScript(abstractScript);
        builder.setProperties((PatternMatch[])var1_1);
        builder.setDefaultPattern((String)var2_2);
        builder.setAlwaysWriteExceptions((boolean)var3_3);
        builder.setNoConsoleNoAnsi(noConsoleNoAnsi);
        builder.setConfiguration(configuration);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        void var2_2;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.patternMap.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("key=\"").append(entry.getKey()).append("\", pattern=\"").append(entry.getValue()).append("\"");
            first = false;
        }
        if (var2_2 == false) {
            sb.append(", ");
        }
        sb.append("default=\"").append(this.defaultPattern).append("\"");
        return var1_1.toString();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ScriptPatternSelector> {
        @PluginElement(value="Script")
        private AbstractScript script;
        @PluginElement(value="PatternMatch")
        private PatternMatch[] properties;
        @PluginBuilderAttribute(value="defaultPattern")
        private String defaultPattern;
        @PluginBuilderAttribute(value="alwaysWriteExceptions")
        private boolean alwaysWriteExceptions = true;
        @PluginBuilderAttribute(value="disableAnsi")
        private boolean disableAnsi;
        @PluginBuilderAttribute(value="noConsoleNoAnsi")
        private boolean noConsoleNoAnsi;
        @PluginConfiguration
        private Configuration configuration;

        private Builder() {
        }

        @Override
        public ScriptPatternSelector build() {
            if (this.script == null) {
                LOGGER.error("A Script, ScriptFile or ScriptRef element must be provided for this ScriptFilter");
                return null;
            }
            if (this.configuration.getScriptManager() == null) {
                LOGGER.error("Script support is not enabled");
                return null;
            }
            if (this.script instanceof ScriptRef) {
                if (this.configuration.getScriptManager().getScript(this.script.getName()) == null) {
                    LOGGER.error("No script with name {} has been declared.", (Object)this.script.getName());
                    return null;
                }
            } else if (!this.configuration.getScriptManager().addScript(this.script)) {
                return null;
            }
            if (this.defaultPattern == null) {
                this.defaultPattern = "%m%n";
            }
            if (this.properties == null || this.properties.length == 0) {
                LOGGER.warn("No marker patterns were provided");
                return null;
            }
            return new ScriptPatternSelector(this.configuration, this.script, this.properties, this.defaultPattern, this.alwaysWriteExceptions, this.disableAnsi, this.noConsoleNoAnsi);
        }

        /*
         * WARNING - void declaration
         */
        public Builder setScript(AbstractScript script) {
            void var1_1;
            this.script = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setProperties(PatternMatch[] properties) {
            void var1_1;
            this.properties = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setDefaultPattern(String defaultPattern) {
            void var1_1;
            this.defaultPattern = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAlwaysWriteExceptions(boolean alwaysWriteExceptions) {
            void var1_1;
            this.alwaysWriteExceptions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setDisableAnsi(boolean disableAnsi) {
            void var1_1;
            this.disableAnsi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setNoConsoleNoAnsi(boolean noConsoleNoAnsi) {
            void var1_1;
            this.noConsoleNoAnsi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setConfiguration(Configuration config) {
            void var1_1;
            this.configuration = var1_1;
            return this;
        }
    }
}

