/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.pattern.FormattingInfo;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.pattern.RegexReplacement;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="PatternLayout", category="Core", elementType="layout", printObject=true)
public final class PatternLayout
extends AbstractStringLayout {
    public static final String DEFAULT_CONVERSION_PATTERN = "%m%n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %notEmpty{%x }- %m%n";
    public static final String SIMPLE_CONVERSION_PATTERN = "%d [%t] %p %c - %m%n";
    public static final String KEY = "Converter";
    private final String conversionPattern;
    private final PatternSelector patternSelector;
    private final AbstractStringLayout.Serializer eventSerializer;

    /*
     * WARNING - void declaration
     */
    private PatternLayout(Configuration config, RegexReplacement replace, String eventPattern, PatternSelector patternSelector, Charset charset, boolean alwaysWriteExceptions, boolean disableAnsi, boolean noConsoleNoAnsi, String headerPattern, String footerPattern) {
        super(config, charset, PatternLayout.newSerializerBuilder().setConfiguration(config).setReplace(replace).setPatternSelector(patternSelector).setAlwaysWriteExceptions(alwaysWriteExceptions).setDisableAnsi(disableAnsi).setNoConsoleNoAnsi(noConsoleNoAnsi).setPattern(headerPattern).build(), PatternLayout.newSerializerBuilder().setConfiguration(config).setReplace(replace).setPatternSelector(patternSelector).setAlwaysWriteExceptions(alwaysWriteExceptions).setDisableAnsi(disableAnsi).setNoConsoleNoAnsi(noConsoleNoAnsi).setPattern(footerPattern).build());
        void var3_3;
        void var2_2;
        void var1_1;
        this.conversionPattern = eventPattern;
        this.patternSelector = patternSelector;
        this.eventSerializer = PatternLayout.newSerializerBuilder().setConfiguration((Configuration)var1_1).setReplace((RegexReplacement)var2_2).setPatternSelector(patternSelector).setAlwaysWriteExceptions(alwaysWriteExceptions).setDisableAnsi(disableAnsi).setNoConsoleNoAnsi(noConsoleNoAnsi).setPattern((String)var3_3).setDefaultPattern(DEFAULT_CONVERSION_PATTERN).build();
    }

    public static SerializerBuilder newSerializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    public final boolean requiresLocation() {
        return this.eventSerializer instanceof LocationAware && ((LocationAware)((Object)this.eventSerializer)).requiresLocation();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static AbstractStringLayout.Serializer createSerializer(Configuration configuration, RegexReplacement replace, String pattern, String defaultPattern, PatternSelector patternSelector, boolean alwaysWriteExceptions, boolean noConsoleNoAnsi) {
        void var1_1;
        void var2_2;
        void var3_3;
        Configuration configuration2;
        SerializerBuilder builder = PatternLayout.newSerializerBuilder();
        builder.setAlwaysWriteExceptions(alwaysWriteExceptions);
        builder.setConfiguration(configuration2);
        builder.setDefaultPattern((String)var3_3);
        builder.setNoConsoleNoAnsi(noConsoleNoAnsi);
        builder.setPattern((String)var2_2);
        builder.setPatternSelector(patternSelector);
        builder.setReplace((RegexReplacement)var1_1);
        return builder.build();
    }

    public final String getConversionPattern() {
        return this.conversionPattern;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<String, String> getContentFormat() {
        void var1_1;
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("structured", "false");
        result.put("formatType", "conversion");
        result.put("format", this.conversionPattern);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toSerializable(LogEvent event) {
        void var1_1;
        return this.eventSerializer.toSerializable((LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void serialize(LogEvent event, StringBuilder stringBuilder) {
        void var2_2;
        void var1_1;
        this.eventSerializer.toSerializable((LogEvent)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void encode(LogEvent event, ByteBufferDestination destination) {
        void var1_1;
        void var2_2;
        PatternLayout patternLayout = this;
        StringBuilder text = patternLayout.toText(patternLayout.eventSerializer, event, PatternLayout.getStringBuilder());
        Encoder<StringBuilder> encoder = this.getStringBuilderEncoder();
        encoder.encode(text, (ByteBufferDestination)var2_2);
        PatternLayout.trimToMaxSize((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder toText(AbstractStringLayout.Serializer2 serializer, LogEvent event, StringBuilder destination) {
        void var3_3;
        void var2_2;
        return serializer.toSerializable((LogEvent)var2_2, (StringBuilder)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static PatternParser createPatternParser(Configuration config) {
        void var1_1;
        if (config == null) {
            return new PatternParser(config, KEY, LogEventPatternConverter.class);
        }
        PatternParser parser = (PatternParser)config.getComponent(KEY);
        if (parser == null) {
            Configuration configuration;
            parser = new PatternParser(config, KEY, LogEventPatternConverter.class);
            config.addComponent(KEY, parser);
            parser = (PatternParser)configuration.getComponent(KEY);
        }
        return var1_1;
    }

    public final String toString() {
        if (this.patternSelector == null) {
            return this.conversionPattern;
        }
        return this.patternSelector.toString();
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    @Deprecated
    public static PatternLayout createLayout(@PluginAttribute(value="pattern", defaultString="%m%n") String pattern, @PluginElement(value="PatternSelector") PatternSelector patternSelector, @PluginConfiguration Configuration config, @PluginElement(value="Replace") RegexReplacement replace, @PluginAttribute(value="charset") Charset charset, @PluginAttribute(value="alwaysWriteExceptions", defaultBoolean=true) boolean alwaysWriteExceptions, @PluginAttribute(value="noConsoleNoAnsi") boolean noConsoleNoAnsi, @PluginAttribute(value="header") String headerPattern, @PluginAttribute(value="footer") String footerPattern) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return PatternLayout.newBuilder().withPattern(string).withPatternSelector((PatternSelector)var1_1).withConfiguration((Configuration)var2_2).withRegexReplacement((RegexReplacement)var3_3).withCharset(charset).withAlwaysWriteExceptions(alwaysWriteExceptions).withNoConsoleNoAnsi(noConsoleNoAnsi).withHeader(headerPattern).withFooter(footerPattern).build();
    }

    public static PatternLayout createDefaultLayout() {
        return PatternLayout.newBuilder().build();
    }

    public static PatternLayout createDefaultLayout(Configuration configuration) {
        Configuration configuration2;
        return PatternLayout.newBuilder().withConfiguration(configuration2).build();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public final AbstractStringLayout.Serializer getEventSerializer() {
        return this.eventSerializer;
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<PatternLayout> {
        @PluginBuilderAttribute
        private String pattern = "%m%n";
        @PluginElement(value="PatternSelector")
        private PatternSelector patternSelector;
        @PluginConfiguration
        private Configuration configuration;
        @PluginElement(value="Replace")
        private RegexReplacement regexReplacement;
        @PluginBuilderAttribute
        private Charset charset = Charset.defaultCharset();
        @PluginBuilderAttribute
        private boolean alwaysWriteExceptions = true;
        @PluginBuilderAttribute
        private boolean disableAnsi = !this.useAnsiEscapeCodes();
        @PluginBuilderAttribute
        private boolean noConsoleNoAnsi;
        @PluginBuilderAttribute
        private String header;
        @PluginBuilderAttribute
        private String footer;

        private Builder() {
        }

        /*
         * WARNING - void declaration
         */
        private boolean useAnsiEscapeCodes() {
            void var1_2;
            void var2_3;
            boolean isJansiRequested;
            PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
            boolean isPlatformSupportsAnsi = !propertiesUtil.isOsWindows();
            boolean bl = isJansiRequested = !propertiesUtil.getBooleanProperty("log4j.skipJansi", true);
            return var2_3 != false || var1_2 != false;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withPattern(String pattern) {
            void var1_1;
            this.pattern = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withPatternSelector(PatternSelector patternSelector) {
            void var1_1;
            this.patternSelector = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withConfiguration(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withRegexReplacement(RegexReplacement regexReplacement) {
            void var1_1;
            this.regexReplacement = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withCharset(Charset charset) {
            if (charset != null) {
                void var1_1;
                this.charset = var1_1;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withAlwaysWriteExceptions(boolean alwaysWriteExceptions) {
            void var1_1;
            this.alwaysWriteExceptions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withDisableAnsi(boolean disableAnsi) {
            void var1_1;
            this.disableAnsi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withNoConsoleNoAnsi(boolean noConsoleNoAnsi) {
            void var1_1;
            this.noConsoleNoAnsi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withHeader(String header) {
            void var1_1;
            this.header = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withFooter(String footer) {
            void var1_1;
            this.footer = var1_1;
            return this;
        }

        @Override
        public PatternLayout build() {
            return new PatternLayout(this.configuration, this.regexReplacement, this.pattern, this.patternSelector, this.charset, this.alwaysWriteExceptions, this.disableAnsi, this.noConsoleNoAnsi, this.header, this.footer);
        }
    }

    private static final class PatternSelectorSerializer
    implements LocationAware,
    AbstractStringLayout.Serializer {
        private final PatternSelector patternSelector;
        private final RegexReplacement replace;

        /*
         * WARNING - void declaration
         */
        private PatternSelectorSerializer(PatternSelector patternSelector, RegexReplacement replace) {
            void var2_2;
            void var1_1;
            this.patternSelector = var1_1;
            this.replace = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String toSerializable(LogEvent event) {
            String string;
            StringBuilder sb = AbstractStringLayout.getStringBuilder();
            try {
                string = this.toSerializable((LogEvent)((Object)string), sb).toString();
            }
            catch (Throwable throwable) {
                void var2_3;
                AbstractStringLayout.trimToMaxSize((StringBuilder)var2_3);
                throw throwable;
            }
            AbstractStringLayout.trimToMaxSize(sb);
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final StringBuilder toSerializable(LogEvent event, StringBuilder buffer) {
            void var2_2;
            PatternFormatter[] patternFormatterArray = this.patternSelector.getFormatters(event);
            int n = patternFormatterArray.length;
            for (int i = 0; i < n; ++i) {
                PatternFormatter patternFormatter = patternFormatterArray[i];
                patternFormatter.format(event, buffer);
            }
            if (this.replace != null) {
                String str = buffer.toString();
                str = this.replace.format(str);
                buffer.setLength(0);
                buffer.append((String)patternFormatterArray);
            }
            return var2_2;
        }

        @Override
        public final boolean requiresLocation() {
            return this.patternSelector instanceof LocationAware && ((LocationAware)((Object)this.patternSelector)).requiresLocation();
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder();
            builder.append(super.toString());
            builder.append("[patternSelector=");
            builder.append(this.patternSelector);
            builder.append(", replace=");
            builder.append(this.replace);
            builder.append("]");
            return var1_1.toString();
        }
    }

    public static class SerializerBuilder
    implements org.apache.logging.log4j.core.util.Builder<AbstractStringLayout.Serializer> {
        private Configuration configuration;
        private RegexReplacement replace;
        private String pattern;
        private String defaultPattern;
        private PatternSelector patternSelector;
        private boolean alwaysWriteExceptions;
        private boolean disableAnsi;
        private boolean noConsoleNoAnsi;

        /*
         * WARNING - void declaration
         */
        @Override
        public AbstractStringLayout.Serializer build() {
            if (Strings.isEmpty((CharSequence)this.pattern) && Strings.isEmpty((CharSequence)this.defaultPattern)) {
                return null;
            }
            if (this.patternSelector == null) {
                try {
                    void var2_3;
                    PatternSerializer serializer;
                    Object object = PatternLayout.createPatternParser(this.configuration);
                    object = ((PatternParser)object).parse(this.pattern == null ? this.defaultPattern : this.pattern, this.alwaysWriteExceptions, this.disableAnsi, this.noConsoleNoAnsi);
                    PatternFormatter[] formatters = object.toArray(PatternFormatter.EMPTY_ARRAY);
                    boolean hasFormattingInfo = false;
                    PatternFormatter[] patternFormatterArray = formatters;
                    int n = formatters.length;
                    for (int i = 0; i < n; ++i) {
                        PatternFormatter patternFormatter = patternFormatterArray[i];
                        FormattingInfo info = patternFormatter.getFormattingInfo();
                        if (info == null || info == FormattingInfo.getDefault()) continue;
                        hasFormattingInfo = true;
                        break;
                    }
                    PatternSerializer patternSerializer = serializer = var2_3 != false ? new PatternFormatterPatternSerializer(formatters) : new NoFormatPatternSerializer(formatters);
                    if (this.replace == null) {
                        return serializer;
                    }
                    return new PatternSerializerWithReplacement((PatternSerializer)patternFormatterArray, this.replace);
                }
                catch (RuntimeException ex) {
                    void var1_2;
                    throw new IllegalArgumentException("Cannot parse pattern '" + this.pattern + "'", (Throwable)var1_2);
                }
            }
            return new PatternSelectorSerializer(this.patternSelector, this.replace);
        }

        /*
         * WARNING - void declaration
         */
        public SerializerBuilder setConfiguration(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public SerializerBuilder setReplace(RegexReplacement replace) {
            void var1_1;
            this.replace = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public SerializerBuilder setPattern(String pattern) {
            void var1_1;
            this.pattern = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public SerializerBuilder setDefaultPattern(String defaultPattern) {
            void var1_1;
            this.defaultPattern = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public SerializerBuilder setPatternSelector(PatternSelector patternSelector) {
            void var1_1;
            this.patternSelector = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public SerializerBuilder setAlwaysWriteExceptions(boolean alwaysWriteExceptions) {
            void var1_1;
            this.alwaysWriteExceptions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public SerializerBuilder setDisableAnsi(boolean disableAnsi) {
            void var1_1;
            this.disableAnsi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public SerializerBuilder setNoConsoleNoAnsi(boolean noConsoleNoAnsi) {
            void var1_1;
            this.noConsoleNoAnsi = var1_1;
            return this;
        }
    }

    private static final class PatternSerializerWithReplacement
    implements LocationAware,
    AbstractStringLayout.Serializer {
        private final PatternSerializer delegate;
        private final RegexReplacement replace;

        /*
         * WARNING - void declaration
         */
        private PatternSerializerWithReplacement(PatternSerializer delegate, RegexReplacement replace) {
            void var2_2;
            void var1_1;
            this.delegate = var1_1;
            this.replace = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String toSerializable(LogEvent event) {
            String string;
            StringBuilder sb = AbstractStringLayout.getStringBuilder();
            try {
                string = this.toSerializable((LogEvent)((Object)string), sb).toString();
            }
            catch (Throwable throwable) {
                void var2_3;
                AbstractStringLayout.trimToMaxSize((StringBuilder)var2_3);
                throw throwable;
            }
            AbstractStringLayout.trimToMaxSize(sb);
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final StringBuilder toSerializable(LogEvent event, StringBuilder buf) {
            void var1_1;
            void var2_2;
            StringBuilder buffer = this.delegate.toSerializable(event, buf);
            String str = buffer.toString();
            str = this.replace.format(str);
            buffer.setLength(0);
            buffer.append((String)var2_2);
            return var1_1;
        }

        @Override
        public final boolean requiresLocation() {
            return this.delegate.requiresLocation();
        }

        public final String toString() {
            return super.toString() + "[delegate=" + this.delegate + ", replace=" + this.replace + "]";
        }
    }

    private static final class PatternFormatterPatternSerializer
    implements PatternSerializer {
        private final PatternFormatter[] formatters;

        /*
         * WARNING - void declaration
         */
        private PatternFormatterPatternSerializer(PatternFormatter[] formatters) {
            void var1_1;
            this.formatters = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String toSerializable(LogEvent event) {
            String string;
            StringBuilder sb = AbstractStringLayout.getStringBuilder();
            try {
                string = this.toSerializable((LogEvent)((Object)string), sb).toString();
            }
            catch (Throwable throwable) {
                void var2_3;
                AbstractStringLayout.trimToMaxSize((StringBuilder)var2_3);
                throw throwable;
            }
            AbstractStringLayout.trimToMaxSize(sb);
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final StringBuilder toSerializable(LogEvent event, StringBuilder buffer) {
            void var2_2;
            PatternFormatter[] patternFormatterArray = this.formatters;
            int n = this.formatters.length;
            for (int i = 0; i < n; ++i) {
                PatternFormatter patternFormatter = patternFormatterArray[i];
                patternFormatter.format(event, buffer);
            }
            return var2_2;
        }

        @Override
        public final boolean requiresLocation() {
            PatternFormatter[] patternFormatterArray = this.formatters;
            int n = this.formatters.length;
            for (int i = 0; i < n; ++i) {
                PatternFormatter patternFormatter = patternFormatterArray[i];
                if (!patternFormatter.requiresLocation()) continue;
                return true;
            }
            return false;
        }

        public final String toString() {
            return super.toString() + "[formatters=" + Arrays.toString(this.formatters) + "]";
        }
    }

    private static final class NoFormatPatternSerializer
    implements PatternSerializer {
        private final LogEventPatternConverter[] converters;

        private NoFormatPatternSerializer(PatternFormatter[] formatters) {
            this.converters = new LogEventPatternConverter[formatters.length];
            for (int i = 0; i < formatters.length; ++i) {
                this.converters[i] = formatters[i].getConverter();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String toSerializable(LogEvent event) {
            String string;
            StringBuilder sb = AbstractStringLayout.getStringBuilder();
            try {
                string = this.toSerializable((LogEvent)((Object)string), sb).toString();
            }
            catch (Throwable throwable) {
                void var2_3;
                AbstractStringLayout.trimToMaxSize((StringBuilder)var2_3);
                throw throwable;
            }
            AbstractStringLayout.trimToMaxSize(sb);
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final StringBuilder toSerializable(LogEvent event, StringBuilder buffer) {
            void var2_2;
            LogEventPatternConverter[] logEventPatternConverterArray = this.converters;
            int n = this.converters.length;
            for (int i = 0; i < n; ++i) {
                LogEventPatternConverter logEventPatternConverter = logEventPatternConverterArray[i];
                logEventPatternConverter.format(event, buffer);
            }
            return var2_2;
        }

        @Override
        public final boolean requiresLocation() {
            LogEventPatternConverter[] logEventPatternConverterArray = this.converters;
            int n = this.converters.length;
            for (int i = 0; i < n; ++i) {
                LogEventPatternConverter converter = logEventPatternConverterArray[i];
                if (!(converter instanceof LocationAware) || !((LocationAware)((Object)converter)).requiresLocation()) continue;
                return true;
            }
            return false;
        }

        public final String toString() {
            return super.toString() + "[converters=" + Arrays.toString(this.converters) + "]";
        }
    }

    private static interface PatternSerializer
    extends LocationAware,
    AbstractStringLayout.Serializer {
    }
}

