/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.TextEncoderHelper;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.status.StatusLogger;

public class LockingStringBuilderEncoder
implements Encoder<StringBuilder> {
    private final Charset charset;
    private final CharsetEncoder charsetEncoder;
    private final CharBuffer cachedCharBuffer;

    /*
     * WARNING - void declaration
     */
    public LockingStringBuilderEncoder(Charset charset) {
        this((Charset)var1_1, Constants.ENCODER_CHAR_BUFFER_SIZE);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LockingStringBuilderEncoder(Charset charset, int charBufferSize) {
        void var2_2;
        void var1_1;
        this.charset = Objects.requireNonNull(charset, "charset");
        this.charsetEncoder = var1_1.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.cachedCharBuffer = CharBuffer.wrap(new char[var2_2]);
    }

    private CharBuffer getCharBuffer() {
        return this.cachedCharBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void encode(StringBuilder source, ByteBufferDestination destination) {
        try {
            ByteBufferDestination byteBufferDestination = destination;
            synchronized (byteBufferDestination) {
                TextEncoderHelper.encodeText(this.charsetEncoder, this.cachedCharBuffer, destination.getByteBuffer(), source, destination);
            }
        }
        catch (Exception ex) {
            void var2_2;
            void var1_1;
            void var3_4;
            this.logEncodeTextException((Exception)var3_4, source, destination);
            TextEncoderHelper.encodeTextFallBack(this.charset, (StringBuilder)var1_1, (ByteBufferDestination)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logEncodeTextException(Exception ex, StringBuilder text, ByteBufferDestination destination) {
        void var1_1;
        void var2_2;
        StatusLogger.getLogger().error("Recovering from LockingStringBuilderEncoder.encode('{}') error", (Object)var2_2, (Object)var1_1);
    }
}

