/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.PatternMatch;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="LevelPatternSelector", category="Core", elementType="patternSelector", printObject=true)
public class LevelPatternSelector
implements LocationAware,
PatternSelector {
    private final Map<String, PatternFormatter[]> formatterMap = new HashMap<String, PatternFormatter[]>();
    private final Map<String, String> patternMap = new HashMap<String, String>();
    private final PatternFormatter[] defaultFormatters;
    private final String defaultPattern;
    private static Logger LOGGER = StatusLogger.getLogger();
    private final boolean requiresLocation;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public LevelPatternSelector(PatternMatch[] properties, String defaultPattern, boolean alwaysWriteExceptions, boolean noConsoleNoAnsi, Configuration config) {
        this((PatternMatch[])var1_1, (String)var2_2, (boolean)var3_3, false, noConsoleNoAnsi, config);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private LevelPatternSelector(PatternMatch[] properties, String defaultPattern, boolean alwaysWriteExceptions, boolean disableAnsi, boolean noConsoleNoAnsi, Configuration config) {
        boolean needsLocation = false;
        PatternParser parser = PatternLayout.createPatternParser(config);
        for (PatternMatch property : properties) {
            try {
                List<PatternFormatter> list = parser.parse(property.getPattern(), alwaysWriteExceptions, disableAnsi, noConsoleNoAnsi);
                PatternFormatter[] formatters = list.toArray(PatternFormatter.EMPTY_ARRAY);
                this.formatterMap.put(property.getKey(), formatters);
                for (int i = 0; !needsLocation && i < formatters.length; ++i) {
                    needsLocation = formatters[i].requiresLocation();
                }
                this.patternMap.put(property.getKey(), property.getPattern());
            }
            catch (RuntimeException ex) {
                throw new IllegalArgumentException("Cannot parse pattern '" + property.getPattern() + "'", ex);
            }
        }
        try {
            void var3_4;
            List<PatternFormatter> list = parser.parse(defaultPattern, (boolean)var3_4, disableAnsi, noConsoleNoAnsi);
            this.defaultFormatters = list.toArray(PatternFormatter.EMPTY_ARRAY);
            this.defaultPattern = defaultPattern;
            for (int i = 0; !needsLocation && i < this.defaultFormatters.length; ++i) {
                needsLocation = this.defaultFormatters[i].requiresLocation();
            }
        }
        catch (RuntimeException ex) {
            void var1_2;
            void var2_3;
            throw new IllegalArgumentException("Cannot parse pattern '" + (String)var2_3 + "'", (Throwable)var1_2);
        }
        this.requiresLocation = needsLocation;
    }

    @Override
    public boolean requiresLocation() {
        return this.requiresLocation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PatternFormatter[] getFormatters(LogEvent event) {
        Level level = event.getLevel();
        if (level == null) {
            return this.defaultFormatters;
        }
        for (String key : this.formatterMap.keySet()) {
            void var3_3;
            if (!level.name().equalsIgnoreCase(key)) continue;
            return this.formatterMap.get(var3_3);
        }
        return this.defaultFormatters;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static LevelPatternSelector createSelector(PatternMatch[] properties, String defaultPattern, boolean alwaysWriteExceptions, boolean noConsoleNoAnsi, Configuration configuration) {
        void var3_3;
        void var2_2;
        void var1_1;
        PatternMatch[] patternMatchArray;
        Builder builder = LevelPatternSelector.newBuilder();
        builder.setProperties(patternMatchArray);
        builder.setDefaultPattern((String)var1_1);
        builder.setAlwaysWriteExceptions((boolean)var2_2);
        builder.setNoConsoleNoAnsi((boolean)var3_3);
        builder.setConfiguration(configuration);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        void var2_2;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.patternMap.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("key=\"").append(entry.getKey()).append("\", pattern=\"").append(entry.getValue()).append("\"");
            first = false;
        }
        if (var2_2 == false) {
            sb.append(", ");
        }
        sb.append("default=\"").append(this.defaultPattern).append("\"");
        return var1_1.toString();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<LevelPatternSelector> {
        @PluginElement(value="PatternMatch")
        private PatternMatch[] properties;
        @PluginBuilderAttribute(value="defaultPattern")
        private String defaultPattern;
        @PluginBuilderAttribute(value="alwaysWriteExceptions")
        private boolean alwaysWriteExceptions = true;
        @PluginBuilderAttribute(value="disableAnsi")
        private boolean disableAnsi;
        @PluginBuilderAttribute(value="noConsoleNoAnsi")
        private boolean noConsoleNoAnsi;
        @PluginConfiguration
        private Configuration configuration;

        @Override
        public LevelPatternSelector build() {
            if (this.defaultPattern == null) {
                this.defaultPattern = "%m%n";
            }
            if (this.properties == null || this.properties.length == 0) {
                LOGGER.warn("No marker patterns were provided with PatternMatch");
                return null;
            }
            return new LevelPatternSelector(this.properties, this.defaultPattern, this.alwaysWriteExceptions, this.disableAnsi, this.noConsoleNoAnsi, this.configuration);
        }

        /*
         * WARNING - void declaration
         */
        public Builder setProperties(PatternMatch[] properties) {
            void var1_1;
            this.properties = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setDefaultPattern(String defaultPattern) {
            void var1_1;
            this.defaultPattern = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAlwaysWriteExceptions(boolean alwaysWriteExceptions) {
            void var1_1;
            this.alwaysWriteExceptions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setDisableAnsi(boolean disableAnsi) {
            void var1_1;
            this.disableAnsi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setNoConsoleNoAnsi(boolean noConsoleNoAnsi) {
            void var1_1;
            this.noConsoleNoAnsi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setConfiguration(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return this;
        }
    }
}

