/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.layout.AbstractJacksonLayout;
import org.apache.logging.log4j.core.layout.JacksonFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.KeyValuePair;

@Plugin(name="JsonLayout", category="Core", elementType="layout", printObject=true)
public final class JsonLayout
extends AbstractJacksonLayout {
    private static final String DEFAULT_FOOTER = "]";
    private static final String DEFAULT_HEADER = "[";
    static final String CONTENT_TYPE = "application/json";

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected JsonLayout(Configuration config, boolean locationInfo, boolean properties, boolean encodeThreadContextAsList, boolean complete, boolean compact, boolean eventEol, String endOfLine, String headerPattern, String footerPattern, Charset charset, boolean includeStacktrace) {
        super(config, new JacksonFactory.JSON(encodeThreadContextAsList, includeStacktrace, false, false).newWriter((boolean)var2_2, (boolean)var3_3, compact), charset, compact, complete, eventEol, endOfLine, PatternLayout.newSerializerBuilder().setConfiguration(config).setPattern(headerPattern).setDefaultPattern(DEFAULT_HEADER).build(), PatternLayout.newSerializerBuilder().setConfiguration((Configuration)var1_1).setPattern(footerPattern).setDefaultPattern(DEFAULT_FOOTER).build(), false, null);
        void var1_1;
        void var3_3;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private JsonLayout(Configuration config, boolean locationInfo, boolean properties, boolean encodeThreadContextAsList, boolean complete, boolean compact, boolean eventEol, String endOfLine, String headerPattern, String footerPattern, Charset charset, boolean includeStacktrace, boolean stacktraceAsString, boolean includeNullDelimiter, boolean includeTimeMillis, KeyValuePair[] additionalFields, boolean objectMessageAsJsonObject) {
        super(config, new JacksonFactory.JSON(encodeThreadContextAsList, includeStacktrace, stacktraceAsString, objectMessageAsJsonObject).newWriter((boolean)var2_2, (boolean)var3_3, compact, includeTimeMillis), charset, compact, complete, eventEol, endOfLine, PatternLayout.newSerializerBuilder().setConfiguration(config).setPattern(headerPattern).setDefaultPattern(DEFAULT_HEADER).build(), PatternLayout.newSerializerBuilder().setConfiguration((Configuration)var1_1).setPattern(footerPattern).setDefaultPattern(DEFAULT_FOOTER).build(), includeNullDelimiter, additionalFields);
        void var1_1;
        void var3_3;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] getHeader() {
        void var1_1;
        if (!this.complete) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        JsonLayout jsonLayout = this;
        String str = jsonLayout.serializeToString(jsonLayout.getHeaderSerializer());
        if (str != null) {
            void var2_2;
            buf.append((String)var2_2);
        }
        buf.append(this.eol);
        return this.getBytes(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] getFooter() {
        void var1_1;
        if (!this.complete) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.eol);
        JsonLayout jsonLayout = this;
        String str = jsonLayout.serializeToString(jsonLayout.getFooterSerializer());
        if (str != null) {
            void var2_2;
            buf.append((String)var2_2);
        }
        buf.append(this.eol);
        return this.getBytes(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<String, String> getContentFormat() {
        void var1_1;
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("version", "2.0");
        return var1_1;
    }

    @Override
    public final String getContentType() {
        return "application/json; charset=" + this.getCharset();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static JsonLayout createLayout(Configuration config, boolean locationInfo, boolean properties, boolean propertiesAsList, boolean complete, boolean compact, boolean eventEol, String headerPattern, String footerPattern, Charset charset, boolean includeStacktrace) {
        void var3_3;
        void var2_2;
        void var1_1;
        Configuration configuration;
        boolean encodeThreadContextAsList = properties && propertiesAsList;
        return new JsonLayout(configuration, (boolean)var1_1, (boolean)var2_2, (boolean)var3_3, complete, compact, eventEol, null, headerPattern, footerPattern, charset, includeStacktrace, false, false, false, null, false);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    public static JsonLayout createDefaultLayout() {
        return new JsonLayout(new DefaultConfiguration(), false, false, false, false, false, false, null, DEFAULT_HEADER, DEFAULT_FOOTER, StandardCharsets.UTF_8, true, false, false, false, null, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void toSerializable(LogEvent event, Writer writer) throws IOException {
        void var2_2;
        void var1_1;
        if (this.complete && this.eventCount > 0L) {
            writer.append(", ");
        }
        super.toSerializable((LogEvent)var1_1, (Writer)var2_2);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractJacksonLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<JsonLayout> {
        @PluginBuilderAttribute
        private boolean propertiesAsList;
        @PluginBuilderAttribute
        private boolean objectMessageAsJsonObject;
        @PluginElement(value="AdditionalField")
        private KeyValuePair[] additionalFields;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public JsonLayout build() {
            void var3_3;
            void var2_2;
            void var1_1;
            boolean encodeThreadContextAsList = this.isProperties() && this.propertiesAsList;
            Builder builder = this;
            String headerPattern = builder.toStringOrNull(builder.getHeader());
            Builder builder2 = this;
            String footerPattern = builder2.toStringOrNull(builder2.getFooter());
            return new JsonLayout(this.getConfiguration(), this.isLocationInfo(), this.isProperties(), (boolean)var1_1, this.isComplete(), this.isCompact(), this.getEventEol(), this.getEndOfLine(), (String)var2_2, (String)var3_3, this.getCharset(), this.isIncludeStacktrace(), this.isStacktraceAsString(), this.isIncludeNullDelimiter(), this.isIncludeTimeMillis(), ((AbstractJacksonLayout.Builder)this).getAdditionalFields(), this.getObjectMessageAsJsonObject());
        }

        public boolean isPropertiesAsList() {
            return this.propertiesAsList;
        }

        /*
         * WARNING - void declaration
         */
        public B setPropertiesAsList(boolean propertiesAsList) {
            void var1_1;
            this.propertiesAsList = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        public boolean getObjectMessageAsJsonObject() {
            return this.objectMessageAsJsonObject;
        }

        /*
         * WARNING - void declaration
         */
        public B setObjectMessageAsJsonObject(boolean objectMessageAsJsonObject) {
            void var1_1;
            this.objectMessageAsJsonObject = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        @Override
        public KeyValuePair[] getAdditionalFields() {
            return this.additionalFields;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public B setAdditionalFields(KeyValuePair[] additionalFields) {
            void var1_1;
            this.additionalFields = var1_1;
            return (B)((Builder)this.asBuilder());
        }
    }
}

