/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import java.util.HashSet;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.jackson.Log4jJsonObjectMapper;
import org.apache.logging.log4j.core.jackson.Log4jXmlObjectMapper;
import org.apache.logging.log4j.core.jackson.Log4jYamlObjectMapper;
import org.codehaus.stax2.XMLStreamWriter2;

abstract class JacksonFactory {
    JacksonFactory() {
    }

    protected abstract String getPropertyNameForTimeMillis();

    protected abstract String getPropertyNameForInstant();

    protected abstract String getPropertNameForContextMap();

    protected abstract String getPropertNameForSource();

    protected abstract String getPropertNameForNanoTime();

    protected abstract PrettyPrinter newCompactPrinter();

    protected abstract ObjectMapper newObjectMapper();

    protected abstract PrettyPrinter newPrettyPrinter();

    /*
     * WARNING - void declaration
     */
    ObjectWriter newWriter(boolean locationInfo, boolean properties, boolean compact) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.newWriter((boolean)var1_1, (boolean)var2_2, (boolean)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    ObjectWriter newWriter(boolean locationInfo, boolean properties, boolean compact, boolean includeMillis) {
        void var3_4;
        void var2_3;
        void var1_1;
        SimpleFilterProvider filters = new SimpleFilterProvider();
        HashSet<String> except = new HashSet<String>(3);
        if (var1_1 == false) {
            except.add(this.getPropertNameForSource());
        }
        if (var2_3 == false) {
            except.add(this.getPropertNameForContextMap());
        }
        if (includeMillis) {
            except.add(this.getPropertyNameForInstant());
        } else {
            except.add(this.getPropertyNameForTimeMillis());
        }
        except.add(this.getPropertNameForNanoTime());
        filters.addFilter(Log4jLogEvent.class.getName(), SimpleBeanPropertyFilter.serializeAllExcept(except));
        ObjectWriter objectWriter = this.newObjectMapper().writer(var3_4 != false ? this.newCompactPrinter() : this.newPrettyPrinter());
        return objectWriter.with((FilterProvider)filters);
    }

    static class Log4jXmlPrettyPrinter
    extends DefaultXmlPrettyPrinter {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - void declaration
         */
        Log4jXmlPrettyPrinter(int nesting) {
            void var1_1;
            this._nesting = var1_1;
        }

        public void writePrologLinefeed(XMLStreamWriter2 sw) throws XMLStreamException {
        }

        public DefaultXmlPrettyPrinter createInstance() {
            return new Log4jXmlPrettyPrinter(1);
        }
    }

    static class YAML
    extends JacksonFactory {
        private final boolean includeStacktrace;
        private final boolean stacktraceAsString;

        /*
         * WARNING - void declaration
         */
        public YAML(boolean includeStacktrace, boolean stacktraceAsString) {
            void var2_2;
            void var1_1;
            this.includeStacktrace = var1_1;
            this.stacktraceAsString = var2_2;
        }

        @Override
        protected String getPropertyNameForTimeMillis() {
            return "timeMillis";
        }

        @Override
        protected String getPropertyNameForInstant() {
            return "instant";
        }

        @Override
        protected String getPropertNameForContextMap() {
            return "contextMap";
        }

        @Override
        protected String getPropertNameForSource() {
            return "source";
        }

        @Override
        protected String getPropertNameForNanoTime() {
            return "nanoTime";
        }

        @Override
        protected PrettyPrinter newCompactPrinter() {
            return new MinimalPrettyPrinter();
        }

        @Override
        protected ObjectMapper newObjectMapper() {
            return new Log4jYamlObjectMapper(false, this.includeStacktrace, this.stacktraceAsString);
        }

        @Override
        protected PrettyPrinter newPrettyPrinter() {
            return new DefaultPrettyPrinter();
        }
    }

    static class XML
    extends JacksonFactory {
        static final int DEFAULT_INDENT = 1;
        private final boolean includeStacktrace;
        private final boolean stacktraceAsString;

        /*
         * WARNING - void declaration
         */
        public XML(boolean includeStacktrace, boolean stacktraceAsString) {
            void var2_2;
            void var1_1;
            this.includeStacktrace = var1_1;
            this.stacktraceAsString = var2_2;
        }

        @Override
        protected String getPropertyNameForTimeMillis() {
            return "TimeMillis";
        }

        @Override
        protected String getPropertyNameForInstant() {
            return "Instant";
        }

        @Override
        protected String getPropertNameForContextMap() {
            return "ContextMap";
        }

        @Override
        protected String getPropertNameForSource() {
            return "Source";
        }

        @Override
        protected String getPropertNameForNanoTime() {
            return "nanoTime";
        }

        @Override
        protected PrettyPrinter newCompactPrinter() {
            return null;
        }

        @Override
        protected ObjectMapper newObjectMapper() {
            return new Log4jXmlObjectMapper(this.includeStacktrace, this.stacktraceAsString);
        }

        @Override
        protected PrettyPrinter newPrettyPrinter() {
            return new Log4jXmlPrettyPrinter(1);
        }
    }

    static class JSON
    extends JacksonFactory {
        private final boolean encodeThreadContextAsList;
        private final boolean includeStacktrace;
        private final boolean stacktraceAsString;
        private final boolean objectMessageAsJsonObject;

        /*
         * WARNING - void declaration
         */
        public JSON(boolean encodeThreadContextAsList, boolean includeStacktrace, boolean stacktraceAsString, boolean objectMessageAsJsonObject) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.encodeThreadContextAsList = var1_1;
            this.includeStacktrace = var2_2;
            this.stacktraceAsString = var3_3;
            this.objectMessageAsJsonObject = objectMessageAsJsonObject;
        }

        @Override
        protected String getPropertNameForContextMap() {
            return "contextMap";
        }

        @Override
        protected String getPropertyNameForTimeMillis() {
            return "timeMillis";
        }

        @Override
        protected String getPropertyNameForInstant() {
            return "instant";
        }

        @Override
        protected String getPropertNameForSource() {
            return "source";
        }

        @Override
        protected String getPropertNameForNanoTime() {
            return "nanoTime";
        }

        @Override
        protected PrettyPrinter newCompactPrinter() {
            return new MinimalPrettyPrinter();
        }

        @Override
        protected ObjectMapper newObjectMapper() {
            return new Log4jJsonObjectMapper(this.encodeThreadContextAsList, this.includeStacktrace, this.stacktraceAsString, this.objectMessageAsJsonObject);
        }

        @Override
        protected PrettyPrinter newPrettyPrinter() {
            return new DefaultPrettyPrinter();
        }
    }
}

