/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.layout.internal.ExcludeChecker;
import org.apache.logging.log4j.core.layout.internal.IncludeChecker;
import org.apache.logging.log4j.core.layout.internal.ListChecker;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.net.Severity;
import org.apache.logging.log4j.core.util.JsonUtils;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.core.util.Patterns;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.log4j.util.TriConsumer;

@Plugin(name="GelfLayout", category="Core", elementType="layout", printObject=true)
public final class GelfLayout
extends AbstractStringLayout {
    private static final char C = ',';
    private static final int COMPRESSION_THRESHOLD = 1024;
    private static final char Q = '\"';
    private static final String QC = "\",";
    private static final String QU = "\"_";
    private final KeyValuePair[] additionalFields;
    private final int compressionThreshold;
    private final CompressionType compressionType;
    private final String host;
    private final boolean includeStacktrace;
    private final boolean includeThreadContext;
    private final boolean includeMapMessage;
    private final boolean includeNullDelimiter;
    private final boolean includeNewLineDelimiter;
    private final boolean omitEmptyFields;
    private final PatternLayout layout;
    private final FieldWriter mdcWriter;
    private final FieldWriter mapWriter;
    private static final ThreadLocal<StringBuilder> messageStringBuilder = new ThreadLocal();
    private static final ThreadLocal<StringBuilder> timestampStringBuilder = new ThreadLocal();

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public GelfLayout(String host, KeyValuePair[] additionalFields, CompressionType compressionType, int compressionThreshold, boolean includeStacktrace) {
        this(null, (String)var1_1, (KeyValuePair[])var2_2, (CompressionType)var3_3, compressionThreshold, includeStacktrace, true, true, false, false, false, null, null, null, "", "");
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private GelfLayout(Configuration config, String host, KeyValuePair[] additionalFields, CompressionType compressionType, int compressionThreshold, boolean includeStacktrace, boolean includeThreadContext, boolean includeMapMessage, boolean includeNullDelimiter, boolean includeNewLineDelimiter, boolean omitEmptyFields, ListChecker mdcChecker, ListChecker mapChecker, PatternLayout patternLayout, String mdcPrefix, String mapPrefix) {
        super(config, StandardCharsets.UTF_8, null, null);
        KeyValuePair[] keyValuePairArray;
        void var3_4;
        void var2_2;
        this.host = host != null ? var2_2 : NetUtils.getLocalHostname();
        Object object = this.additionalFields = additionalFields != null ? var3_4 : KeyValuePair.EMPTY_ARRAY;
        if (keyValuePairArray == null) {
            keyValuePairArray = this.additionalFields;
            int n = this.additionalFields.length;
            for (int i = 0; i < n; ++i) {
                KeyValuePair keyValuePair = keyValuePairArray[i];
                if (!GelfLayout.valueNeedsLookup(keyValuePair.getValue())) continue;
                throw new IllegalArgumentException("configuration needs to be set when there are additional fields with variables");
            }
        }
        this.compressionType = compressionType;
        this.compressionThreshold = compressionThreshold;
        this.includeStacktrace = includeStacktrace;
        this.includeThreadContext = includeThreadContext;
        this.includeMapMessage = includeMapMessage;
        this.includeNullDelimiter = includeNullDelimiter;
        this.includeNewLineDelimiter = includeNewLineDelimiter;
        this.omitEmptyFields = omitEmptyFields;
        if (includeNullDelimiter && compressionType != CompressionType.OFF) {
            throw new IllegalArgumentException("null delimiter cannot be used with compression");
        }
        this.mdcWriter = new FieldWriter(mdcChecker, mdcPrefix);
        this.mapWriter = new FieldWriter(mapChecker, mapPrefix);
        this.layout = patternLayout;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        String mapVars;
        StringBuilder sb = new StringBuilder();
        sb.append("host=").append(this.host);
        sb.append(", compressionType=").append(this.compressionType.toString());
        sb.append(", compressionThreshold=").append(this.compressionThreshold);
        sb.append(", includeStackTrace=").append(this.includeStacktrace);
        sb.append(", includeThreadContext=").append(this.includeThreadContext);
        sb.append(", includeNullDelimiter=").append(this.includeNullDelimiter);
        sb.append(", includeNewLineDelimiter=").append(this.includeNewLineDelimiter);
        String threadVars = this.mdcWriter.getChecker().toString();
        if (threadVars.length() > 0) {
            sb.append(", ").append(threadVars);
        }
        if ((mapVars = this.mapWriter.getChecker().toString()).length() > 0) {
            void var2_2;
            sb.append(", ").append((String)var2_2);
        }
        if (this.layout != null) {
            sb.append(", PatternLayout{").append(this.layout.toString()).append("}");
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static GelfLayout createLayout(@PluginAttribute(value="host") String host, @PluginElement(value="AdditionalField") KeyValuePair[] additionalFields, @PluginAttribute(value="compressionType", defaultString="GZIP") CompressionType compressionType, @PluginAttribute(value="compressionThreshold", defaultInt=1024) int compressionThreshold, @PluginAttribute(value="includeStacktrace", defaultBoolean=true) boolean includeStacktrace) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return new GelfLayout(null, string, (KeyValuePair[])var1_1, (CompressionType)var2_2, (int)var3_3, includeStacktrace, true, true, false, false, false, null, null, null, "", "");
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    @Override
    public final Map<String, String> getContentFormat() {
        return Collections.emptyMap();
    }

    @Override
    public final String getContentType() {
        return "application/json; charset=" + this.getCharset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] toByteArray(LogEvent event) {
        void var1_1;
        StringBuilder text = this.toText(event, GelfLayout.getStringBuilder(), false);
        byte[] bytes = this.getBytes(text.toString());
        if (this.compressionType != CompressionType.OFF && bytes.length > this.compressionThreshold) {
            return this.compress(bytes);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void encode(LogEvent event, ByteBufferDestination destination) {
        void var2_2;
        void var1_1;
        if (this.compressionType != CompressionType.OFF) {
            super.encode(event, destination);
            return;
        }
        StringBuilder text = this.toText(event, GelfLayout.getStringBuilder(), true);
        Encoder<StringBuilder> encoder = this.getStringBuilderEncoder();
        encoder.encode((StringBuilder)var1_1, (ByteBufferDestination)var2_2);
    }

    @Override
    public final boolean requiresLocation() {
        return Objects.nonNull(this.layout) && ((AbstractStringLayout)this.layout).requiresLocation();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] compress(byte[] bytes) {
        Throwable throwable;
        DeflaterOutputStream stream2;
        Object baos2;
        block11: {
            try {
                baos2 = new ByteArrayOutputStream(this.compressionThreshold / 8);
                stream2 = this.compressionType.createDeflaterOutputStream((OutputStream)baos2);
                throwable = null;
                if (stream2 != null) break block11;
                baos2 = bytes;
                if (stream2 == null) return baos2;
                stream2.close();
                return baos2;
            }
            catch (IOException e) {
                void var1_1;
                void var2_4;
                StatusLogger.getLogger().error((Object)var2_4);
                return var1_1;
            }
        }
        try {
            stream2.write(bytes);
            stream2.finish();
            if (stream2 == null) return ((ByteArrayOutputStream)baos2).toByteArray();
        }
        catch (Throwable throwable2) {
            try {
                baos2 = throwable2;
                throwable = throwable2;
                throw baos2;
            }
            catch (Throwable baos2) {
                if (stream2 == null) throw baos2;
                if (throwable != null) {
                    try {
                        stream2.close();
                        throw baos2;
                    }
                    catch (Throwable stream2) {
                        throwable.addSuppressed(stream2);
                    }
                    throw baos2;
                } else {
                    void var3_5;
                    var3_5.close();
                }
                throw baos2;
            }
        }
        stream2.close();
        return ((ByteArrayOutputStream)baos2).toByteArray();
    }

    @Override
    public final String toSerializable(LogEvent event) {
        StringBuilder stringBuilder;
        stringBuilder = this.toText((LogEvent)((Object)stringBuilder), GelfLayout.getStringBuilder(), false);
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder toText(LogEvent event, StringBuilder builder, boolean gcFree) {
        void var2_3;
        void var3_4;
        void var1_1;
        builder.append('{');
        builder.append("\"version\":\"1.1\",");
        builder.append("\"host\":\"");
        JsonUtils.quoteAsString(GelfLayout.toNullSafeString(this.host), builder);
        builder.append(QC);
        builder.append("\"timestamp\":").append(GelfLayout.formatTimestamp(event.getTimeMillis())).append(',');
        builder.append("\"level\":").append(this.formatLevel(event.getLevel())).append(',');
        if (event.getThreadName() != null) {
            builder.append("\"_thread\":\"");
            JsonUtils.quoteAsString(event.getThreadName(), builder);
            builder.append(QC);
        }
        if (event.getLoggerName() != null) {
            builder.append("\"_logger\":\"");
            JsonUtils.quoteAsString(event.getLoggerName(), builder);
            builder.append(QC);
        }
        if (this.additionalFields.length > 0) {
            StrSubstitutor strSubstitutor = this.getConfiguration().getStrSubstitutor();
            KeyValuePair[] keyValuePairArray = this.additionalFields;
            int n = this.additionalFields.length;
            for (int i = 0; i < n; ++i) {
                KeyValuePair additionalField = keyValuePairArray[i];
                String value2 = GelfLayout.valueNeedsLookup(additionalField.getValue()) ? strSubstitutor.replace(event, additionalField.getValue()) : additionalField.getValue();
                if (!Strings.isNotEmpty((CharSequence)value2) && this.omitEmptyFields) continue;
                builder.append(QU);
                JsonUtils.quoteAsString(additionalField.getKey(), builder);
                builder.append("\":\"");
                JsonUtils.quoteAsString(GelfLayout.toNullSafeString(value2), builder);
                builder.append(QC);
            }
        }
        if (this.includeThreadContext) {
            event.getContextData().forEach((TriConsumer)this.mdcWriter, (Object)builder);
        }
        if (this.includeMapMessage && event.getMessage() instanceof MapMessage) {
            ((MapMessage)event.getMessage()).forEach((key, value) -> {
                void var1_1;
                void var3_3;
                void var2_2;
                this.mapWriter.accept((String)var2_2, (Object)var3_3, (StringBuilder)var1_1);
            });
        }
        if (event.getThrown() != null || this.layout != null) {
            builder.append("\"full_message\":\"");
            if (this.layout != null) {
                StringBuilder messageBuffer = GelfLayout.getMessageStringBuilder();
                this.layout.serialize(event, messageBuffer);
                JsonUtils.quoteAsString(messageBuffer, builder);
            } else if (this.includeStacktrace) {
                JsonUtils.quoteAsString(GelfLayout.formatThrowable(event.getThrown()), builder);
            } else {
                JsonUtils.quoteAsString(event.getThrown().toString(), builder);
            }
            builder.append(QC);
        }
        builder.append("\"short_message\":\"");
        Message message = var1_1.getMessage();
        if (message instanceof CharSequence) {
            JsonUtils.quoteAsString((CharSequence)message, builder);
        } else if (var3_4 != false && message instanceof StringBuilderFormattable) {
            StringBuilder messageBuffer = GelfLayout.getMessageStringBuilder();
            try {
                ((StringBuilderFormattable)message).formatTo(messageBuffer);
                JsonUtils.quoteAsString(messageBuffer, builder);
            }
            finally {
                GelfLayout.trimToMaxSize(messageBuffer);
            }
        } else {
            JsonUtils.quoteAsString(GelfLayout.toNullSafeString(message.getFormattedMessage()), builder);
        }
        builder.append('\"');
        builder.append('}');
        if (this.includeNullDelimiter) {
            builder.append('\u0000');
        }
        if (this.includeNewLineDelimiter) {
            builder.append('\n');
        }
        return var2_3;
    }

    private static boolean valueNeedsLookup(String value) {
        String string;
        return value != null && string.contains("${");
    }

    /*
     * WARNING - void declaration
     */
    private static StringBuilder getMessageStringBuilder() {
        void var0;
        StringBuilder result = messageStringBuilder.get();
        if (result == null) {
            result = new StringBuilder(1024);
            messageStringBuilder.set(result);
        }
        result.setLength(0);
        return var0;
    }

    private static CharSequence toNullSafeString(CharSequence s) {
        CharSequence charSequence;
        if (s == null) {
            return "";
        }
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    static CharSequence formatTimestamp(long timeMillis) {
        void var2_1;
        long l;
        if (timeMillis < 1000L) {
            return "0";
        }
        StringBuilder builder = GelfLayout.getTimestampStringBuilder();
        builder.append(l);
        StringBuilder stringBuilder = builder;
        stringBuilder.insert(stringBuilder.length() - 3, '.');
        return var2_1;
    }

    /*
     * WARNING - void declaration
     */
    private static StringBuilder getTimestampStringBuilder() {
        void var0;
        StringBuilder result = timestampStringBuilder.get();
        if (result == null) {
            result = new StringBuilder(20);
            timestampStringBuilder.set(result);
        }
        result.setLength(0);
        return var0;
    }

    private int formatLevel(Level level) {
        return Severity.getSeverity(level).getCode();
    }

    /*
     * WARNING - void declaration
     */
    static CharSequence formatThrowable(Throwable throwable) {
        void var1_1;
        void var2_2;
        Throwable throwable2;
        StringWriter sw = new StringWriter(2048);
        PrintWriter pw = new PrintWriter(sw);
        throwable2.printStackTrace(pw);
        var2_2.flush();
        return var1_1.getBuffer();
    }

    private class FieldWriter
    implements TriConsumer<String, Object, StringBuilder> {
        private final ListChecker checker;
        private final String prefix;

        /*
         * WARNING - void declaration
         */
        FieldWriter(ListChecker checker, String prefix) {
            void var3_3;
            void var2_2;
            this.checker = var2_2;
            this.prefix = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public void accept(String key, Object value, StringBuilder stringBuilder) {
            String stringValue = String.valueOf(value);
            if (this.checker.check(key) && (Strings.isNotEmpty((CharSequence)stringValue) || !GelfLayout.this.omitEmptyFields)) {
                void var3_3;
                void var2_2;
                void var1_1;
                stringBuilder.append(GelfLayout.QU);
                JsonUtils.quoteAsString(Strings.concat((String)this.prefix, (String)var1_1), stringBuilder);
                stringBuilder.append("\":\"");
                JsonUtils.quoteAsString(GelfLayout.toNullSafeString((CharSequence)var2_2), stringBuilder);
                var3_3.append(GelfLayout.QC);
            }
        }

        public ListChecker getChecker() {
            return this.checker;
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractStringLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<GelfLayout> {
        @PluginBuilderAttribute
        private String host;
        @PluginElement(value="AdditionalField")
        private KeyValuePair[] additionalFields;
        @PluginBuilderAttribute
        private CompressionType compressionType = CompressionType.GZIP;
        @PluginBuilderAttribute
        private int compressionThreshold = 1024;
        @PluginBuilderAttribute
        private boolean includeStacktrace = true;
        @PluginBuilderAttribute
        private boolean includeThreadContext = true;
        @PluginBuilderAttribute
        private boolean includeNullDelimiter;
        @PluginBuilderAttribute
        private boolean includeNewLineDelimiter;
        @PluginBuilderAttribute
        private String threadContextIncludes;
        @PluginBuilderAttribute
        private String threadContextExcludes;
        @PluginBuilderAttribute
        private String mapMessageIncludes;
        @PluginBuilderAttribute
        private String mapMessageExcludes;
        @PluginBuilderAttribute
        private boolean includeMapMessage = true;
        @PluginBuilderAttribute
        private boolean omitEmptyFields;
        @PluginBuilderAttribute
        private String messagePattern;
        @PluginBuilderAttribute
        private String threadContextPrefix = "";
        @PluginBuilderAttribute
        private String mapPrefix = "";
        @PluginElement(value="PatternSelector")
        private PatternSelector patternSelector;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public GelfLayout build() {
            void var3_3;
            void var2_2;
            void var1_1;
            Builder builder = this;
            ListChecker mdcChecker = builder.createChecker(builder.threadContextExcludes, this.threadContextIncludes);
            Builder builder2 = this;
            ListChecker mapChecker = builder2.createChecker(builder2.mapMessageExcludes, this.mapMessageIncludes);
            PatternLayout patternLayout = null;
            if (this.messagePattern != null && this.patternSelector != null) {
                AbstractLayout.LOGGER.error("A message pattern and PatternSelector cannot both be specified on GelfLayout, ignoring message pattern");
                this.messagePattern = null;
            }
            if (this.messagePattern != null) {
                patternLayout = PatternLayout.newBuilder().withPattern(this.messagePattern).withAlwaysWriteExceptions(this.includeStacktrace).withConfiguration(this.getConfiguration()).build();
            }
            if (this.patternSelector != null) {
                patternLayout = PatternLayout.newBuilder().withPatternSelector(this.patternSelector).withAlwaysWriteExceptions(this.includeStacktrace).withConfiguration(this.getConfiguration()).build();
            }
            return new GelfLayout(this.getConfiguration(), this.host, this.additionalFields, this.compressionType, this.compressionThreshold, this.includeStacktrace, this.includeThreadContext, this.includeMapMessage, this.includeNullDelimiter, this.includeNewLineDelimiter, this.omitEmptyFields, (ListChecker)var1_1, (ListChecker)var2_2, (PatternLayout)var3_3, this.threadContextPrefix, this.mapPrefix);
        }

        /*
         * WARNING - void declaration
         */
        private ListChecker createChecker(String excludes, String includes) {
            ListChecker listChecker;
            void var2_2;
            String[] array;
            Object checker = null;
            if (excludes != null && (array = excludes.split(Patterns.COMMA_SEPARATOR)).length > 0) {
                Object excludeList = new ArrayList<String>(array.length);
                int n = array.length;
                for (int i = 0; i < n; ++i) {
                    String str = array[i];
                    excludeList.add((String)str.trim());
                }
                excludeList = new ExcludeChecker((List<String>)excludeList);
            }
            if (includes != null && (array = var2_2.split(Patterns.COMMA_SEPARATOR)).length > 0) {
                void var1_1;
                ArrayList<String> includeList = new ArrayList<String>(array.length);
                for (String str : var1_1) {
                    includeList.add(str.trim());
                }
                listChecker = new IncludeChecker((List<String>)((Object)listChecker));
            }
            if (listChecker == null) {
                listChecker = ListChecker.NOOP_CHECKER;
            }
            return listChecker;
        }

        public String getHost() {
            return this.host;
        }

        public CompressionType getCompressionType() {
            return this.compressionType;
        }

        public int getCompressionThreshold() {
            return this.compressionThreshold;
        }

        public boolean isIncludeStacktrace() {
            return this.includeStacktrace;
        }

        public boolean isIncludeThreadContext() {
            return this.includeThreadContext;
        }

        public boolean isIncludeNullDelimiter() {
            return this.includeNullDelimiter;
        }

        public boolean isIncludeNewLineDelimiter() {
            return this.includeNewLineDelimiter;
        }

        public KeyValuePair[] getAdditionalFields() {
            return this.additionalFields;
        }

        /*
         * WARNING - void declaration
         */
        public B setHost(String host) {
            void var1_1;
            this.host = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setCompressionType(CompressionType compressionType) {
            void var1_1;
            this.compressionType = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setCompressionThreshold(int compressionThreshold) {
            void var1_1;
            this.compressionThreshold = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setIncludeStacktrace(boolean includeStacktrace) {
            void var1_1;
            this.includeStacktrace = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setIncludeThreadContext(boolean includeThreadContext) {
            void var1_1;
            this.includeThreadContext = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setIncludeNullDelimiter(boolean includeNullDelimiter) {
            void var1_1;
            this.includeNullDelimiter = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setIncludeNewLineDelimiter(boolean includeNewLineDelimiter) {
            void var1_1;
            this.includeNewLineDelimiter = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setAdditionalFields(KeyValuePair[] additionalFields) {
            void var1_1;
            this.additionalFields = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setMessagePattern(String pattern) {
            void var1_1;
            this.messagePattern = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setPatternSelector(PatternSelector patternSelector) {
            void var1_1;
            this.patternSelector = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setMdcIncludes(String mdcIncludes) {
            void var1_1;
            this.threadContextIncludes = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setMdcExcludes(String mdcExcludes) {
            void var1_1;
            this.threadContextExcludes = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setIncludeMapMessage(boolean includeMapMessage) {
            void var1_1;
            this.includeMapMessage = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setMapMessageIncludes(String mapMessageIncludes) {
            void var1_1;
            this.mapMessageIncludes = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setMapMessageExcludes(String mapMessageExcludes) {
            void var1_1;
            this.mapMessageExcludes = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setThreadContextPrefix(String prefix) {
            if (prefix != null) {
                void var1_1;
                this.threadContextPrefix = var1_1;
            }
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setMapPrefix(String prefix) {
            if (prefix != null) {
                void var1_1;
                this.mapPrefix = var1_1;
            }
            return (B)((Builder)this.asBuilder());
        }
    }

    public static enum CompressionType {
        GZIP{

            /*
             * WARNING - void declaration
             */
            @Override
            public final DeflaterOutputStream createDeflaterOutputStream(OutputStream os) throws IOException {
                void var1_1;
                return new GZIPOutputStream((OutputStream)var1_1);
            }
        }
        ,
        ZLIB{

            /*
             * WARNING - void declaration
             */
            @Override
            public final DeflaterOutputStream createDeflaterOutputStream(OutputStream os) throws IOException {
                void var1_1;
                return new DeflaterOutputStream((OutputStream)var1_1);
            }
        }
        ,
        OFF{

            @Override
            public final DeflaterOutputStream createDeflaterOutputStream(OutputStream os) throws IOException {
                return null;
            }
        };


        public abstract DeflaterOutputStream createDeflaterOutputStream(OutputStream var1) throws IOException;
    }
}

