/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractCsvLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="CsvParameterLayout", category="Core", elementType="layout", printObject=true)
public class CsvParameterLayout
extends AbstractCsvLayout {
    public static AbstractCsvLayout createDefaultLayout() {
        return new CsvParameterLayout(null, Charset.forName("UTF-8"), CSVFormat.valueOf((String)"Default"), null, null);
    }

    public static AbstractCsvLayout createLayout(CSVFormat format) {
        CSVFormat cSVFormat;
        return new CsvParameterLayout(null, Charset.forName("UTF-8"), cSVFormat, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static AbstractCsvLayout createLayout(@PluginConfiguration Configuration config, @PluginAttribute(value="format", defaultString="Default") String format, @PluginAttribute(value="delimiter") Character delimiter, @PluginAttribute(value="escape") Character escape, @PluginAttribute(value="quote") Character quote, @PluginAttribute(value="quoteMode") QuoteMode quoteMode, @PluginAttribute(value="nullString") String nullString, @PluginAttribute(value="recordSeparator") String recordSeparator, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset, @PluginAttribute(value="header") String header, @PluginAttribute(value="footer") String footer) {
        void var1_1;
        Configuration configuration;
        void var3_3;
        void var2_2;
        CSVFormat csvFormat = CsvParameterLayout.createFormat(format, (Character)var2_2, (Character)var3_3, quote, quoteMode, nullString, recordSeparator);
        return new CsvParameterLayout(configuration, charset, (CSVFormat)var1_1, header, footer);
    }

    /*
     * WARNING - void declaration
     */
    public CsvParameterLayout(Configuration config, Charset charset, CSVFormat csvFormat, String header, String footer) {
        super((Configuration)var1_1, (Charset)var2_2, (CSVFormat)var3_3, header, footer);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toSerializable(LogEvent event) {
        Message message = event.getMessage();
        Object[] parameters = message.getParameters();
        StringBuilder buffer = CsvParameterLayout.getStringBuilder();
        try {
            void var3_4;
            this.getFormat().printRecord((Appendable)buffer, parameters);
            return var3_4.toString();
        }
        catch (IOException e) {
            void var2_3;
            void var1_1;
            StatusLogger.getLogger().error((Message)var1_1, (Throwable)e);
            return this.getFormat().getCommentMarker() + " " + var2_3;
        }
    }
}

