/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractCsvLayout;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="CsvLogEventLayout", category="Core", elementType="layout", printObject=true)
public class CsvLogEventLayout
extends AbstractCsvLayout {
    public static CsvLogEventLayout createDefaultLayout() {
        return new CsvLogEventLayout(null, Charset.forName("UTF-8"), CSVFormat.valueOf((String)"Default"), null, null);
    }

    public static CsvLogEventLayout createLayout(CSVFormat format) {
        CSVFormat cSVFormat;
        return new CsvLogEventLayout(null, Charset.forName("UTF-8"), cSVFormat, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static CsvLogEventLayout createLayout(@PluginConfiguration Configuration config, @PluginAttribute(value="format", defaultString="Default") String format, @PluginAttribute(value="delimiter") Character delimiter, @PluginAttribute(value="escape") Character escape, @PluginAttribute(value="quote") Character quote, @PluginAttribute(value="quoteMode") QuoteMode quoteMode, @PluginAttribute(value="nullString") String nullString, @PluginAttribute(value="recordSeparator") String recordSeparator, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset, @PluginAttribute(value="header") String header, @PluginAttribute(value="footer") String footer) {
        void var1_1;
        Configuration configuration;
        void var3_3;
        void var2_2;
        CSVFormat csvFormat = CsvLogEventLayout.createFormat(format, (Character)var2_2, (Character)var3_3, quote, quoteMode, nullString, recordSeparator);
        return new CsvLogEventLayout(configuration, charset, (CSVFormat)var1_1, header, footer);
    }

    /*
     * WARNING - void declaration
     */
    protected CsvLogEventLayout(Configuration config, Charset charset, CSVFormat csvFormat, String header, String footer) {
        super((Configuration)var1_1, (Charset)var2_2, (CSVFormat)var3_3, header, footer);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toSerializable(LogEvent event) {
        StringBuilder buffer = CsvLogEventLayout.getStringBuilder();
        CSVFormat format = this.getFormat();
        try {
            format.print((Object)event.getNanoTime(), (Appendable)buffer, true);
            format.print((Object)event.getTimeMillis(), (Appendable)buffer, false);
            format.print((Object)event.getLevel(), (Appendable)buffer, false);
            format.print((Object)event.getThreadId(), (Appendable)buffer, false);
            format.print((Object)event.getThreadName(), (Appendable)buffer, false);
            format.print((Object)event.getThreadPriority(), (Appendable)buffer, false);
            format.print((Object)event.getMessage().getFormattedMessage(), (Appendable)buffer, false);
            format.print((Object)event.getLoggerFqcn(), (Appendable)buffer, false);
            format.print((Object)event.getLoggerName(), (Appendable)buffer, false);
            format.print((Object)event.getMarker(), (Appendable)buffer, false);
            format.print((Object)event.getThrownProxy(), (Appendable)buffer, false);
            format.print((Object)event.getSource(), (Appendable)buffer, false);
            format.print((Object)event.getContextData(), (Appendable)buffer, false);
            format.print((Object)event.getContextStack(), (Appendable)buffer, false);
            format.println((Appendable)buffer);
            return buffer.toString();
        }
        catch (IOException e) {
            void var2_3;
            void var3_4;
            void var1_1;
            StatusLogger.getLogger().error(var1_1.toString(), (Throwable)e);
            return var3_4.getCommentMarker() + " " + var2_3;
        }
    }
}

