/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.impl.DefaultLogEventFactory;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.StringBuilderEncoder;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.StringEncoder;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.StringBuilders;

public abstract class AbstractStringLayout
extends AbstractLayout<String>
implements StringLayout,
LocationAware {
    protected static final int DEFAULT_STRING_BUILDER_SIZE = 1024;
    protected static final int MAX_STRING_BUILDER_SIZE = Math.max(1024, AbstractStringLayout.size("log4j.layoutStringBuilder.maxSize", 2048));
    private static final ThreadLocal<StringBuilder> threadLocal = new ThreadLocal();
    private Encoder<StringBuilder> textEncoder;
    private final Charset charset;
    private final Serializer footerSerializer;
    private final Serializer headerSerializer;

    @Override
    public boolean requiresLocation() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected static StringBuilder getStringBuilder() {
        void var0;
        if (AbstractLogger.getRecursionDepth() > 1) {
            return new StringBuilder(1024);
        }
        StringBuilder result = threadLocal.get();
        if (result == null) {
            result = new StringBuilder(1024);
            threadLocal.set(result);
        }
        AbstractStringLayout.trimToMaxSize(result);
        result.setLength(0);
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static int size(String property, int defaultValue) {
        void var1_1;
        String string;
        return PropertiesUtil.getProperties().getIntegerProperty(string, (int)var1_1);
    }

    protected static void trimToMaxSize(StringBuilder stringBuilder) {
        StringBuilders.trimToMaxSize((StringBuilder)stringBuilder, (int)MAX_STRING_BUILDER_SIZE);
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractStringLayout(Charset charset) {
        this((Charset)var1_1, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractStringLayout(Charset aCharset, byte[] header, byte[] footer) {
        super(null, (byte[])var2_2, (byte[])var3_3);
        void var1_1;
        void var3_3;
        void var2_2;
        this.headerSerializer = null;
        this.footerSerializer = null;
        this.charset = aCharset == null ? StandardCharsets.UTF_8 : var1_1;
        this.textEncoder = Constants.ENABLE_DIRECT_ENCODERS ? new StringBuilderEncoder(this.charset) : null;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractStringLayout(Configuration config, Charset aCharset, Serializer headerSerializer, Serializer footerSerializer) {
        super((Configuration)var1_1, null, null);
        void var2_2;
        void var3_3;
        void var1_1;
        this.headerSerializer = var3_3;
        this.footerSerializer = footerSerializer;
        this.charset = aCharset == null ? StandardCharsets.UTF_8 : var2_2;
        this.textEncoder = Constants.ENABLE_DIRECT_ENCODERS ? new StringBuilderEncoder(this.charset) : null;
    }

    protected byte[] getBytes(String s) {
        return s.getBytes(this.charset);
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public byte[] getFooter() {
        AbstractStringLayout abstractStringLayout = this;
        return abstractStringLayout.serializeToBytes(abstractStringLayout.footerSerializer, super.getFooter());
    }

    public Serializer getFooterSerializer() {
        return this.footerSerializer;
    }

    @Override
    public byte[] getHeader() {
        AbstractStringLayout abstractStringLayout = this;
        return abstractStringLayout.serializeToBytes(abstractStringLayout.headerSerializer, super.getHeader());
    }

    public Serializer getHeaderSerializer() {
        return this.headerSerializer;
    }

    private DefaultLogEventFactory getLogEventFactory() {
        return DefaultLogEventFactory.getInstance();
    }

    protected Encoder<StringBuilder> getStringBuilderEncoder() {
        if (this.textEncoder == null) {
            this.textEncoder = new StringBuilderEncoder(this.getCharset());
        }
        return this.textEncoder;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] serializeToBytes(Serializer serializer, byte[] defaultValue) {
        void var1_1;
        String serializable = this.serializeToString(serializer);
        if (serializable == null) {
            void var2_2;
            return var2_2;
        }
        return StringEncoder.toBytes((String)var1_1, this.getCharset());
    }

    /*
     * WARNING - void declaration
     */
    protected String serializeToString(Serializer serializer) {
        void var3_2;
        void var1_1;
        void var2_3;
        Level level;
        String loggerName;
        if (serializer == null) {
            return null;
        }
        if (this.configuration != null) {
            LoggerConfig rootLogger = this.configuration.getRootLogger();
            loggerName = rootLogger.getName();
            level = rootLogger.getLevel();
        } else {
            loggerName = "";
            level = AbstractConfiguration.getDefaultLevel();
        }
        LogEvent logEvent = this.getLogEventFactory().createEvent((String)var2_3, null, "", level, null, null, null);
        return var1_1.toSerializable((LogEvent)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toByteArray(LogEvent event) {
        void var1_1;
        AbstractStringLayout abstractStringLayout = this;
        return abstractStringLayout.getBytes((String)abstractStringLayout.toSerializable((LogEvent)var1_1));
    }

    public static interface Serializer2 {
        public StringBuilder toSerializable(LogEvent var1, StringBuilder var2);
    }

    public static interface Serializer
    extends Serializer2 {
        public String toSerializable(LogEvent var1);

        /*
         * WARNING - void declaration
         */
        @Override
        default public StringBuilder toSerializable(LogEvent event, StringBuilder builder) {
            void var2_2;
            void var1_1;
            builder.append(this.toSerializable((LogEvent)var1_1));
            return var2_2;
        }
    }

    public static abstract class Builder<B extends Builder<B>>
    extends AbstractLayout.Builder<B> {
        @PluginBuilderAttribute(value="charset")
        private Charset charset;
        @PluginElement(value="footerSerializer")
        private Serializer footerSerializer;
        @PluginElement(value="headerSerializer")
        private Serializer headerSerializer;

        public Charset getCharset() {
            return this.charset;
        }

        public Serializer getFooterSerializer() {
            return this.footerSerializer;
        }

        public Serializer getHeaderSerializer() {
            return this.headerSerializer;
        }

        /*
         * WARNING - void declaration
         */
        public B setCharset(Charset charset) {
            void var1_1;
            this.charset = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setFooterSerializer(Serializer footerSerializer) {
            void var1_1;
            this.footerSerializer = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setHeaderSerializer(Serializer headerSerializer) {
            void var1_1;
            this.headerSerializer = var1_1;
            return (B)((Builder)this.asBuilder());
        }
    }
}

