/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;

public abstract class AbstractCsvLayout
extends AbstractStringLayout {
    protected static final String DEFAULT_CHARSET = "UTF-8";
    protected static final String DEFAULT_FORMAT = "Default";
    private static final String CONTENT_TYPE = "text/csv";
    private final CSVFormat format;

    /*
     * WARNING - void declaration
     */
    protected static CSVFormat createFormat(String format, Character delimiter, Character escape, Character quote, QuoteMode quoteMode, String nullString, String recordSeparator) {
        String string;
        String csvFormat = CSVFormat.valueOf((String)format);
        if (AbstractCsvLayout.isNotNul(delimiter)) {
            void var1_1;
            csvFormat = csvFormat.withDelimiter(var1_1.charValue());
        }
        if (AbstractCsvLayout.isNotNul(escape)) {
            void var2_2;
            csvFormat = csvFormat.withEscape((Character)var2_2);
        }
        if (AbstractCsvLayout.isNotNul(quote)) {
            void var3_3;
            csvFormat = csvFormat.withQuote((Character)var3_3);
        }
        if (quoteMode != null) {
            csvFormat = csvFormat.withQuoteMode(quoteMode);
        }
        if (nullString != null) {
            csvFormat = csvFormat.withNullString(nullString);
        }
        if (recordSeparator != null) {
            csvFormat = csvFormat.withRecordSeparator(recordSeparator);
        }
        return string;
    }

    private static boolean isNotNul(Character character) {
        Character c;
        return character != null && c.charValue() != '\u0000';
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractCsvLayout(Configuration config, Charset charset, CSVFormat csvFormat, String header, String footer) {
        super(config, (Charset)var2_2, PatternLayout.newSerializerBuilder().setConfiguration(config).setPattern(header).build(), PatternLayout.newSerializerBuilder().setConfiguration((Configuration)var1_1).setPattern(footer).build());
        void var3_3;
        void var1_1;
        void var2_2;
        this.format = var3_3;
    }

    @Override
    public String getContentType() {
        return "text/csv; charset=" + this.getCharset();
    }

    public CSVFormat getFormat() {
        return this.format;
    }
}

