/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jmx;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.jmx.Server;
import org.apache.logging.log4j.core.jmx.StatusLoggerAdminMBean;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;

public class StatusLoggerAdmin
extends NotificationBroadcasterSupport
implements StatusLoggerAdminMBean,
StatusListener {
    private final AtomicLong sequenceNo = new AtomicLong();
    private final ObjectName objectName;
    private final String contextName;
    private Level level = Level.WARN;

    /*
     * WARNING - void declaration
     */
    public StatusLoggerAdmin(String contextName, Executor executor) {
        super(executor, StatusLoggerAdmin.createNotificationInfo());
        void var1_1;
        this.contextName = contextName;
        try {
            String mbeanName = String.format("org.apache.logging.log4j2:type=%s,component=StatusLogger", Server.escape(contextName));
            this.objectName = new ObjectName(mbeanName);
        }
        catch (Exception e) {
            void var2_3;
            throw new IllegalStateException((Throwable)var2_3);
        }
        this.removeListeners((String)var1_1);
        StatusLogger.getLogger().registerListener((StatusListener)this);
    }

    private void removeListeners(String ctxName) {
        StatusLogger logger = StatusLogger.getLogger();
        Object object = logger.getListeners();
        object = object.iterator();
        while (object.hasNext()) {
            StatusListener statusListener = (StatusListener)object.next();
            if (!(statusListener instanceof StatusLoggerAdmin)) continue;
            StatusLoggerAdmin adminListener = (StatusLoggerAdmin)statusListener;
            if (ctxName == null || !ctxName.equals(adminListener.contextName)) continue;
            logger.removeListener((StatusListener)adminListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static MBeanNotificationInfo createNotificationInfo() {
        void var1_1;
        void var0;
        String[] notifTypes = new String[]{"com.apache.logging.log4j.core.jmx.statuslogger.data", "com.apache.logging.log4j.core.jmx.statuslogger.message"};
        String name = Notification.class.getName();
        return new MBeanNotificationInfo((String[])var0, (String)var1_1, "StatusLogger has logged an event");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] getStatusDataHistory() {
        void var2_2;
        List<StatusData> data = this.getStatusData();
        String[] result = new String[data.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = data.get(i).getFormattedStatus();
        }
        return var2_2;
    }

    @Override
    public List<StatusData> getStatusData() {
        return StatusLogger.getLogger().getStatusData();
    }

    @Override
    public String getLevel() {
        return this.level.name();
    }

    public Level getStatusLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLevel(String level) {
        void var1_1;
        this.level = Level.toLevel((String)var1_1, (Level)Level.ERROR);
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    /*
     * WARNING - void declaration
     */
    public void log(StatusData data) {
        void var2_2;
        void var1_1;
        Notification notifMsg = new Notification("com.apache.logging.log4j.core.jmx.statuslogger.message", this.getObjectName(), this.nextSeqNo(), this.nowMillis(), data.getFormattedStatus());
        this.sendNotification(notifMsg);
        Notification notifData = new Notification("com.apache.logging.log4j.core.jmx.statuslogger.data", (Object)this.getObjectName(), this.nextSeqNo(), this.nowMillis());
        notifData.setUserData(var1_1);
        this.sendNotification((Notification)var2_2);
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    private long nextSeqNo() {
        return this.sequenceNo.getAndIncrement();
    }

    private long nowMillis() {
        return System.currentTimeMillis();
    }

    public void close() throws IOException {
    }
}

