/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jmx;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.async.AsyncLoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.jmx.AppenderAdmin;
import org.apache.logging.log4j.core.jmx.AsyncAppenderAdmin;
import org.apache.logging.log4j.core.jmx.ContextSelectorAdmin;
import org.apache.logging.log4j.core.jmx.LoggerConfigAdmin;
import org.apache.logging.log4j.core.jmx.LoggerContextAdmin;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.core.jmx.StatusLoggerAdmin;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class Server {
    private static final String CONTEXT_NAME_ALL = "*";
    public static final String DOMAIN = "org.apache.logging.log4j2";
    private static final String PROPERTY_DISABLE_JMX = "log4j2.disable.jmx";
    private static final String PROPERTY_ASYNC_NOTIF = "log4j2.jmx.notify.async";
    private static final String THREAD_NAME_PREFIX = "jmx.notif";
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    static final Executor executor = Server.isJmxDisabled() ? null : Server.createExecutor();

    private Server() {
    }

    private static ExecutorService createExecutor() {
        boolean bl;
        boolean defaultAsync = !Constants.IS_WEB_APP;
        bl = PropertiesUtil.getProperties().getBooleanProperty(PROPERTY_ASYNC_NOTIF, bl);
        if (bl) {
            return Executors.newFixedThreadPool(1, Log4jThreadFactory.createDaemonThreadFactory(THREAD_NAME_PREFIX));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static String escape(String name) {
        void var1_1;
        void var2_2;
        StringBuilder sb = new StringBuilder(name.length() << 1);
        boolean needsQuotes = false;
        block6: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '\"': 
                case '*': 
                case '?': 
                case '\\': {
                    sb.append('\\');
                    needsQuotes = true;
                    break;
                }
                case ',': 
                case ':': 
                case '=': {
                    needsQuotes = true;
                    break;
                }
                case '\r': {
                    continue block6;
                }
                case '\n': {
                    sb.append("\\n");
                    needsQuotes = true;
                    continue block6;
                }
            }
            sb.append(c);
        }
        if (var2_2 != false) {
            sb.insert(0, '\"');
            sb.append('\"');
        }
        return var1_1.toString();
    }

    private static boolean isJmxDisabled() {
        return PropertiesUtil.getProperties().getBooleanProperty(PROPERTY_DISABLE_JMX);
    }

    public static void reregisterMBeansAfterReconfigure() {
        if (Server.isJmxDisabled()) {
            LOGGER.debug("JMX disabled for Log4j2. Not registering MBeans.");
            return;
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Server.reregisterMBeansAfterReconfigure(mBeanServer);
    }

    /*
     * WARNING - void declaration
     */
    public static void reregisterMBeansAfterReconfigure(MBeanServer mbs) {
        if (Server.isJmxDisabled()) {
            LOGGER.debug("JMX disabled for Log4j2. Not registering MBeans.");
            return;
        }
        try {
            ContextSelector selector = Server.getContextSelector();
            if (selector == null) {
                LOGGER.debug("Could not register MBeans: no ContextSelector found.");
                return;
            }
            LOGGER.trace("Reregistering MBeans after reconfigure. Selector={}", (Object)selector);
            List<LoggerContext> contexts = selector.getLoggerContexts();
            int i = 0;
            for (LoggerContext ctx : contexts) {
                RingBufferAdmin rbmbean;
                LoggerContextAdmin mbean;
                LOGGER.trace("Reregistering context ({}/{}): '{}' {}", (Object)(++i), (Object)contexts.size(), (Object)ctx.getName(), (Object)ctx);
                Server.unregisterLoggerContext(ctx.getName(), mbs);
                LoggerContextAdmin loggerContextAdmin = mbean = new LoggerContextAdmin(ctx, executor);
                Server.register(mbs, loggerContextAdmin, loggerContextAdmin.getObjectName());
                if (ctx instanceof AsyncLoggerContext && (rbmbean = ((AsyncLoggerContext)ctx).createRingBufferAdmin()).getBufferSize() > 0L) {
                    RingBufferAdmin ringBufferAdmin = rbmbean;
                    Server.register(mbs, ringBufferAdmin, ringBufferAdmin.getObjectName());
                }
                Server.registerStatusLogger(ctx.getName(), mbs, executor);
                Server.registerContextSelector(ctx.getName(), selector, mbs, executor);
                Server.registerLoggerConfigs(ctx, mbs, executor);
                Server.registerAppenders(ctx, mbs, executor);
            }
            return;
        }
        catch (Exception ex) {
            void var1_2;
            LOGGER.error("Could not register mbeans", (Throwable)var1_2);
            return;
        }
    }

    public static void unregisterMBeans() {
        if (Server.isJmxDisabled()) {
            LOGGER.debug("JMX disabled for Log4j2. Not unregistering MBeans.");
            return;
        }
        Server.unregisterMBeans(ManagementFactory.getPlatformMBeanServer());
    }

    public static void unregisterMBeans(MBeanServer mbs) {
        if (mbs != null) {
            MBeanServer mBeanServer;
            Server.unregisterStatusLogger(CONTEXT_NAME_ALL, mbs);
            Server.unregisterContextSelector(CONTEXT_NAME_ALL, mbs);
            Server.unregisterContexts(mbs);
            Server.unregisterLoggerConfigs(CONTEXT_NAME_ALL, mbs);
            Server.unregisterAsyncLoggerRingBufferAdmins(CONTEXT_NAME_ALL, mbs);
            Server.unregisterAsyncLoggerConfigRingBufferAdmins(CONTEXT_NAME_ALL, mbs);
            Server.unregisterAppenders(CONTEXT_NAME_ALL, mbs);
            Server.unregisterAsyncAppenders(CONTEXT_NAME_ALL, mBeanServer);
        }
    }

    private static ContextSelector getContextSelector() {
        LoggerContextFactory factory = LogManager.getFactory();
        if (factory instanceof Log4jContextFactory) {
            ContextSelector contextSelector;
            contextSelector = ((Log4jContextFactory)((Object)contextSelector)).getSelector();
            return contextSelector;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void unregisterLoggerContext(String loggerContextName) {
        void var1_1;
        String string;
        if (Server.isJmxDisabled()) {
            LOGGER.debug("JMX disabled for Log4j2. Not unregistering MBeans.");
            return;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Server.unregisterLoggerContext(string, (MBeanServer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void unregisterLoggerContext(String contextName, MBeanServer mbs) {
        void var1_1;
        String string;
        String string2 = String.format("org.apache.logging.log4j2:type=%s", Server.escape(contextName), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string2, mbs);
        Server.unregisterStatusLogger(contextName, mbs);
        Server.unregisterContextSelector(contextName, mbs);
        Server.unregisterLoggerConfigs(contextName, mbs);
        Server.unregisterAppenders(contextName, mbs);
        Server.unregisterAsyncAppenders(contextName, mbs);
        Server.unregisterAsyncLoggerRingBufferAdmins(contextName, mbs);
        Server.unregisterAsyncLoggerConfigRingBufferAdmins(string, (MBeanServer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void registerStatusLogger(String contextName, MBeanServer mbs, Executor executor) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        void var1_1;
        StatusLoggerAdmin statusLoggerAdmin;
        void var2_2;
        StatusLoggerAdmin mbean = new StatusLoggerAdmin(contextName, (Executor)var2_2);
        StatusLoggerAdmin statusLoggerAdmin2 = statusLoggerAdmin;
        Server.register((MBeanServer)var1_1, statusLoggerAdmin2, statusLoggerAdmin2.getObjectName());
    }

    /*
     * WARNING - void declaration
     */
    private static void registerContextSelector(String contextName, ContextSelector selector, MBeanServer mbs, Executor executor) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        void var2_2;
        ContextSelectorAdmin contextSelectorAdmin;
        void var1_1;
        ContextSelectorAdmin mbean = new ContextSelectorAdmin(contextName, (ContextSelector)var1_1);
        ContextSelectorAdmin contextSelectorAdmin2 = contextSelectorAdmin;
        Server.register((MBeanServer)var2_2, contextSelectorAdmin2, contextSelectorAdmin2.getObjectName());
    }

    /*
     * WARNING - void declaration
     */
    private static void unregisterStatusLogger(String contextName, MBeanServer mbs) {
        void var1_1;
        String string;
        string = String.format("org.apache.logging.log4j2:type=%s,component=StatusLogger", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string, (MBeanServer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void unregisterContextSelector(String contextName, MBeanServer mbs) {
        void var1_1;
        String string;
        string = String.format("org.apache.logging.log4j2:type=%s,component=ContextSelector", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string, (MBeanServer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void unregisterLoggerConfigs(String contextName, MBeanServer mbs) {
        void var1_1;
        String string;
        string = String.format("org.apache.logging.log4j2:type=%s,component=Loggers,name=%s", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string, (MBeanServer)var1_1);
    }

    private static void unregisterContexts(MBeanServer mbs) {
        MBeanServer mBeanServer;
        String string = String.format("org.apache.logging.log4j2:type=%s", CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string, mBeanServer);
    }

    /*
     * WARNING - void declaration
     */
    private static void unregisterAppenders(String contextName, MBeanServer mbs) {
        void var1_1;
        String string;
        string = String.format("org.apache.logging.log4j2:type=%s,component=Appenders,name=%s", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string, (MBeanServer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void unregisterAsyncAppenders(String contextName, MBeanServer mbs) {
        void var1_1;
        String string;
        string = String.format("org.apache.logging.log4j2:type=%s,component=AsyncAppenders,name=%s", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string, (MBeanServer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void unregisterAsyncLoggerRingBufferAdmins(String contextName, MBeanServer mbs) {
        void var1_1;
        String string;
        string = String.format("org.apache.logging.log4j2:type=%s,component=AsyncLoggerRingBuffer", Server.escape(string));
        Server.unregisterAllMatching(string, (MBeanServer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void unregisterAsyncLoggerConfigRingBufferAdmins(String contextName, MBeanServer mbs) {
        void var1_1;
        String string;
        string = String.format("org.apache.logging.log4j2:type=%s,component=Loggers,name=%s,subtype=RingBuffer", Server.escape(string), CONTEXT_NAME_ALL);
        Server.unregisterAllMatching(string, (MBeanServer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void unregisterAllMatching(String search, MBeanServer mbs) {
        try {
            ObjectName pattern = new ObjectName(search);
            Object found = mbs.queryNames(pattern, null);
            if (found == null || found.isEmpty()) {
                LOGGER.trace("Unregistering but no MBeans found matching '{}'", (Object)search);
            } else {
                LOGGER.trace("Unregistering {} MBeans: {}", (Object)found.size(), found);
            }
            if (found != null) {
                found = found.iterator();
                while (found.hasNext()) {
                    void var3_5;
                    ObjectName objectName = (ObjectName)found.next();
                    mbs.unregisterMBean((ObjectName)var3_5);
                }
            }
            return;
        }
        catch (InstanceNotFoundException ex) {
            LOGGER.debug("Could not unregister MBeans for " + search + ". Ignoring " + ex);
            return;
        }
        catch (Exception ex) {
            void var2_4;
            String string;
            LOGGER.error("Could not unregister MBeans for " + string, (Throwable)var2_4);
            return;
        }
    }

    private static void registerLoggerConfigs(LoggerContext ctx, MBeanServer mbs, Executor executor) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Map<String, LoggerConfig> map = ctx.getConfiguration().getLoggers();
        for (String name : map.keySet()) {
            RingBufferAdmin rbmbean;
            LoggerConfigAdmin mbean;
            LoggerConfig cfg = map.get(name);
            LoggerConfigAdmin loggerConfigAdmin = mbean = new LoggerConfigAdmin(ctx, cfg);
            Server.register(mbs, loggerConfigAdmin, loggerConfigAdmin.getObjectName());
            if (!(cfg instanceof AsyncLoggerConfig)) continue;
            cfg = (AsyncLoggerConfig)cfg;
            RingBufferAdmin ringBufferAdmin = rbmbean = ((AsyncLoggerConfig)cfg).createRingBufferAdmin(ctx.getName());
            Server.register(mbs, ringBufferAdmin, ringBufferAdmin.getObjectName());
        }
    }

    private static void registerAppenders(LoggerContext ctx, MBeanServer mbs, Executor executor) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Map<String, Appender> map = ctx.getConfiguration().getAppenders();
        for (String name : map.keySet()) {
            Object mbean;
            Appender appender = map.get(name);
            if (appender instanceof AsyncAppender) {
                AsyncAppender async = (AsyncAppender)appender;
                Object object = mbean = new AsyncAppenderAdmin(ctx.getName(), async);
                Server.register(mbs, object, ((AsyncAppenderAdmin)object).getObjectName());
                continue;
            }
            mbean = new AppenderAdmin(ctx.getName(), (Appender)mbean);
            AppenderAdmin appenderAdmin = mbean;
            Server.register(mbs, appenderAdmin, appenderAdmin.getObjectName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void register(MBeanServer mbs, Object mbean, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        void var2_2;
        void var1_1;
        MBeanServer mBeanServer;
        if (mbs.isRegistered(objectName)) {
            try {
                mbs.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException jMException) {
                LOGGER.trace("Failed to unregister MBean {}", (Object)objectName);
            }
        }
        LOGGER.debug("Registering MBean {}", (Object)objectName);
        mBeanServer.registerMBean(var1_1, (ObjectName)var2_2);
    }
}

