/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jmx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.jmx.LoggerContextAdminMBean;
import org.apache.logging.log4j.core.jmx.Server;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.status.StatusLogger;

public class LoggerContextAdmin
extends NotificationBroadcasterSupport
implements PropertyChangeListener,
LoggerContextAdminMBean {
    private static final int PAGE = 4096;
    private static final int TEXT_BUFFER = 65536;
    private static final int BUFFER_SIZE = 2048;
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private final AtomicLong sequenceNo = new AtomicLong();
    private final ObjectName objectName;
    private final LoggerContext loggerContext;

    /*
     * WARNING - void declaration
     */
    public LoggerContextAdmin(LoggerContext loggerContext, Executor executor) {
        super(executor, LoggerContextAdmin.createNotificationInfo());
        void var1_1;
        this.loggerContext = Objects.requireNonNull(loggerContext, "loggerContext");
        try {
            String ctxName = Server.escape(loggerContext.getName());
            String name = String.format("org.apache.logging.log4j2:type=%s", ctxName);
            this.objectName = new ObjectName(name);
        }
        catch (Exception e) {
            void var2_3;
            throw new IllegalStateException((Throwable)var2_3);
        }
        var1_1.addPropertyChangeListener(this);
    }

    /*
     * WARNING - void declaration
     */
    private static MBeanNotificationInfo createNotificationInfo() {
        void var1_1;
        void var0;
        String[] notifTypes = new String[]{"com.apache.logging.log4j.core.jmx.config.reconfigured"};
        String name = Notification.class.getName();
        return new MBeanNotificationInfo((String[])var0, (String)var1_1, "Configuration reconfigured");
    }

    @Override
    public String getStatus() {
        return this.loggerContext.getState().toString();
    }

    @Override
    public String getName() {
        return this.loggerContext.getName();
    }

    private Configuration getConfig() {
        return this.loggerContext.getConfiguration();
    }

    @Override
    public String getConfigLocationUri() {
        if (this.loggerContext.getConfigLocation() != null) {
            return String.valueOf(this.loggerContext.getConfigLocation());
        }
        if (this.getConfigName() != null) {
            return String.valueOf(new File(this.getConfigName()).toURI());
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConfigLocationUri(String configLocation) throws URISyntaxException, IOException {
        void var1_1;
        Object configURL;
        ConfigurationSource configSource;
        if (configLocation == null || configLocation.isEmpty()) {
            throw new IllegalArgumentException("Missing configuration location");
        }
        LOGGER.debug("---------");
        LOGGER.debug("Remote request to reconfigure using location " + configLocation);
        File configFile = new File(configLocation);
        if (configFile.exists()) {
            void var2_2;
            LOGGER.debug("Opening config file {}", (Object)configFile.getAbsolutePath());
            configSource = new ConfigurationSource((InputStream)new FileInputStream(configFile), (File)var2_2);
        } else {
            configURL = new URL((String)((Object)configSource));
            LOGGER.debug("Opening config URL {}", configURL);
            configURL = new ConfigurationSource(((URL)configURL).openStream(), (URL)configURL);
        }
        Configuration config = ConfigurationFactory.getInstance().getConfiguration(this.loggerContext, (ConfigurationSource)configURL);
        this.loggerContext.start((Configuration)var1_1);
        LOGGER.debug("Completed remote request to reconfigure.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        void var1_1;
        if (!"config".equals(evt.getPropertyName())) {
            return;
        }
        Notification notif = new Notification("com.apache.logging.log4j.core.jmx.config.reconfigured", this.getObjectName(), this.nextSeqNo(), this.now(), null);
        this.sendNotification((Notification)var1_1);
    }

    @Override
    public String getConfigText() throws IOException {
        return this.getConfigText(StandardCharsets.UTF_8.name());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getConfigText(String charsetName) throws IOException {
        try {
            void var1_1;
            ConfigurationSource configurationSource = this.loggerContext.getConfiguration().getConfigurationSource();
            ConfigurationSource copy = configurationSource.resetInputStream();
            Charset charset = Charset.forName(charsetName);
            return this.readContents(copy.getInputStream(), (Charset)var1_1);
        }
        catch (Exception ex) {
            void var3_5;
            void var2_3;
            StringWriter sw = new StringWriter(2048);
            var2_3.printStackTrace(new PrintWriter(sw));
            return var3_5.toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    private String readContents(InputStream in, Charset charset) throws IOException {
        String string;
        InputStreamReader reader = null;
        try {
            int count;
            reader = new InputStreamReader(in, charset);
            StringBuilder result = new StringBuilder(65536);
            char[] buff = new char[4096];
            while ((count = reader.read(buff)) >= 0) {
                result.append(buff, 0, count);
            }
            string = ((StringBuilder)((Object)string)).toString();
        }
        catch (Throwable throwable) {
            void var3_4;
            void var1_1;
            Closer.closeSilently((AutoCloseable)var1_1);
            Closer.closeSilently((AutoCloseable)var3_4);
            throw throwable;
        }
        Closer.closeSilently(in);
        Closer.closeSilently(reader);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConfigText(String configText, String charsetName) {
        LOGGER.debug("---------");
        LOGGER.debug("Remote request to reconfigure from config text.");
        try {
            void var2_3;
            ByteArrayInputStream in = new ByteArrayInputStream(configText.getBytes((String)var2_3));
            ConfigurationSource source = new ConfigurationSource(in);
            Configuration updated = ConfigurationFactory.getInstance().getConfiguration(this.loggerContext, source);
            this.loggerContext.start(updated);
            LOGGER.debug("Completed remote request to reconfigure from config text.");
            return;
        }
        catch (Exception ex) {
            void var1_2;
            LOGGER.error("Could not reconfigure from config text", (Throwable)ex);
            throw new IllegalArgumentException("Could not reconfigure from config text", (Throwable)var1_2);
        }
    }

    @Override
    public String getConfigName() {
        return this.getConfig().getName();
    }

    @Override
    public String getConfigClassName() {
        return this.getConfig().getClass().getName();
    }

    @Override
    public String getConfigFilter() {
        return String.valueOf(this.getConfig().getFilter());
    }

    @Override
    public Map<String, String> getConfigProperties() {
        return this.getConfig().getProperties();
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    private long nextSeqNo() {
        return this.sequenceNo.getAndIncrement();
    }

    private long now() {
        return System.currentTimeMillis();
    }
}

