/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jmx;

import java.util.List;
import java.util.Objects;
import javax.management.ObjectName;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.jmx.LoggerConfigAdminMBean;
import org.apache.logging.log4j.core.jmx.Server;

public class LoggerConfigAdmin
implements LoggerConfigAdminMBean {
    private final LoggerContext loggerContext;
    private final LoggerConfig loggerConfig;
    private final ObjectName objectName;

    /*
     * WARNING - void declaration
     */
    public LoggerConfigAdmin(LoggerContext loggerContext, LoggerConfig loggerConfig) {
        this.loggerContext = Objects.requireNonNull(loggerContext, "loggerContext");
        this.loggerConfig = Objects.requireNonNull(loggerConfig, "loggerConfig");
        try {
            void var2_3;
            String ctxName = Server.escape(loggerContext.getName());
            String configName = Server.escape(loggerConfig.getName());
            String name = String.format("org.apache.logging.log4j2:type=%s,component=Loggers,name=%s", ctxName, var2_3);
            this.objectName = new ObjectName(name);
            return;
        }
        catch (Exception e) {
            void var1_2;
            throw new IllegalStateException((Throwable)var1_2);
        }
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public String getName() {
        return this.loggerConfig.getName();
    }

    @Override
    public String getLevel() {
        return this.loggerConfig.getLevel().name();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLevel(String level) {
        void var1_1;
        this.loggerConfig.setLevel(Level.getLevel((String)var1_1));
        this.loggerContext.updateLoggers();
    }

    @Override
    public boolean isAdditive() {
        return this.loggerConfig.isAdditive();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAdditive(boolean additive) {
        void var1_1;
        this.loggerConfig.setAdditive((boolean)var1_1);
        this.loggerContext.updateLoggers();
    }

    @Override
    public boolean isIncludeLocation() {
        return this.loggerConfig.isIncludeLocation();
    }

    @Override
    public String getFilter() {
        return String.valueOf(((AbstractFilterable)this.loggerConfig).getFilter());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String[] getAppenderRefs() {
        void var2_2;
        List<AppenderRef> refs = this.loggerConfig.getAppenderRefs();
        String[] result = new String[refs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = refs.get(i).getRef();
        }
        return var2_2;
    }
}

