/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.pattern.TextRenderer;

class ThrowableProxyRenderer {
    private static final String TAB = "\t";
    private static final String CAUSED_BY_LABEL = "Caused by: ";
    private static final String SUPPRESSED_LABEL = "Suppressed: ";
    private static final String WRAPPED_BY_LABEL = "Wrapped by: ";

    private ThrowableProxyRenderer() {
    }

    /*
     * WARNING - void declaration
     */
    static void formatWrapper(StringBuilder sb, ThrowableProxy cause, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        void var3_3;
        void var2_2;
        void var1_1;
        StringBuilder stringBuilder;
        Throwable throwable = cause.getCauseProxy() != null ? cause.getCauseProxy().getThrowable() : null;
        if (throwable != null) {
            ThrowableProxyRenderer.formatWrapper(sb, cause.getCauseProxy(), ignorePackages, textRenderer, suffix, lineSeparator);
            sb.append(WRAPPED_BY_LABEL);
            ThrowableProxyRenderer.renderSuffix(suffix, sb, textRenderer);
        }
        ThrowableProxyRenderer.renderOn(cause, sb, textRenderer);
        ThrowableProxyRenderer.renderSuffix(suffix, sb, textRenderer);
        textRenderer.render(lineSeparator, sb, "Text");
        ThrowableProxyRenderer.formatElements(stringBuilder, "", cause.getCommonElementCount(), cause.getThrowable().getStackTrace(), var1_1.getExtendedStackTrace(), (List<String>)var2_2, (TextRenderer)var3_3, suffix, lineSeparator);
    }

    /*
     * WARNING - void declaration
     */
    private static void formatCause(StringBuilder sb, String prefix, ThrowableProxy cause, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        void var3_3;
        void var2_2;
        void var1_1;
        ThrowableProxyRenderer.formatThrowableProxy(sb, (String)var1_1, CAUSED_BY_LABEL, (ThrowableProxy)var2_2, (List<String>)var3_3, textRenderer, suffix, lineSeparator);
    }

    /*
     * WARNING - void declaration
     */
    private static void formatThrowableProxy(StringBuilder sb, String prefix, String causeLabel, ThrowableProxy throwableProxy, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        void var3_3;
        void var1_1;
        StringBuilder stringBuilder;
        void var2_2;
        if (throwableProxy == null) {
            return;
        }
        textRenderer.render(prefix, sb, "Prefix");
        textRenderer.render((String)var2_2, sb, "CauseLabel");
        ThrowableProxyRenderer.renderOn(throwableProxy, sb, textRenderer);
        ThrowableProxyRenderer.renderSuffix(suffix, sb, textRenderer);
        textRenderer.render(lineSeparator, sb, "Text");
        ThrowableProxyRenderer.formatElements(sb, prefix, throwableProxy.getCommonElementCount(), throwableProxy.getStackTrace(), throwableProxy.getExtendedStackTrace(), ignorePackages, textRenderer, suffix, lineSeparator);
        ThrowableProxyRenderer.formatSuppressed(sb, prefix + TAB, throwableProxy.getSuppressedProxies(), ignorePackages, textRenderer, suffix, lineSeparator);
        ThrowableProxyRenderer.formatCause(stringBuilder, (String)var1_1, var3_3.getCauseProxy(), ignorePackages, textRenderer, suffix, lineSeparator);
    }

    /*
     * WARNING - void declaration
     */
    private static void formatSuppressed(StringBuilder sb, String prefix, ThrowableProxy[] suppressedProxies, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        void var2_2;
        if (suppressedProxies == null) {
            return;
        }
        for (void suppressedProxy : var2_2) {
            ThrowableProxyRenderer.formatThrowableProxy(sb, prefix, SUPPRESSED_LABEL, (ThrowableProxy)suppressedProxy, ignorePackages, textRenderer, suffix, lineSeparator);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void formatElements(StringBuilder sb, String prefix, int commonCount, StackTraceElement[] causedTrace2, ExtendedStackTraceElement[] extStackTrace, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        if (ignorePackages == null || ignorePackages.isEmpty()) {
            ExtendedStackTraceElement[] extendedStackTraceElementArray = extStackTrace;
            int n = ((ExtendedStackTraceElement[])extStackTrace).length;
            for (int causedTrace2 = 0; causedTrace2 < n; ++causedTrace2) {
                extStackTrace = extendedStackTraceElementArray[causedTrace2];
                ThrowableProxyRenderer.formatEntry((ExtendedStackTraceElement)extStackTrace, sb, prefix, textRenderer, suffix, lineSeparator);
            }
        } else {
            int count = 0;
            for (int i = 0; i < ((ExtendedStackTraceElement[])extStackTrace).length; ++i) {
                StackTraceElement[] causedTrace2;
                if (!ThrowableProxyRenderer.ignoreElement(causedTrace2[i], ignorePackages)) {
                    if (count > 0) {
                        ThrowableProxyRenderer.appendSuppressedCount(sb, prefix, count, textRenderer, suffix, lineSeparator);
                        count = 0;
                    }
                    ThrowableProxyRenderer.formatEntry(extStackTrace[i], sb, prefix, textRenderer, suffix, lineSeparator);
                    continue;
                }
                ++count;
            }
            if (count > 0) {
                ThrowableProxyRenderer.appendSuppressedCount(sb, prefix, count, textRenderer, suffix, lineSeparator);
            }
        }
        if (commonCount != 0) {
            StringBuilder stringBuilder;
            void var2_2;
            void var1_1;
            textRenderer.render((String)var1_1, sb, "Prefix");
            textRenderer.render("\t... ", sb, "More");
            textRenderer.render(Integer.toString((int)var2_2), sb, "More");
            textRenderer.render(" more", sb, "More");
            ThrowableProxyRenderer.renderSuffix(suffix, sb, textRenderer);
            textRenderer.render(lineSeparator, stringBuilder, "Text");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void renderSuffix(String suffix, StringBuilder sb, TextRenderer textRenderer) {
        if (!suffix.isEmpty()) {
            void var1_1;
            String string;
            void var2_2;
            textRenderer.render(" ", sb, "Suffix");
            var2_2.render(string, (StringBuilder)var1_1, "Suffix");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void appendSuppressedCount(StringBuilder sb, String prefix, int count, TextRenderer textRenderer, String suffix, String lineSeparator) {
        StringBuilder stringBuilder;
        void var3_3;
        void var1_1;
        textRenderer.render((String)var1_1, sb, "Prefix");
        if (count == 1) {
            textRenderer.render("\t... ", sb, "Suppressed");
        } else {
            void var2_2;
            textRenderer.render("\t... suppressed ", sb, "Suppressed");
            textRenderer.render(Integer.toString((int)var2_2), sb, "Suppressed");
            textRenderer.render(" lines", sb, "Suppressed");
        }
        ThrowableProxyRenderer.renderSuffix(suffix, sb, textRenderer);
        var3_3.render(lineSeparator, stringBuilder, "Text");
    }

    /*
     * WARNING - void declaration
     */
    private static void formatEntry(ExtendedStackTraceElement extStackTraceElement, StringBuilder sb, String prefix, TextRenderer textRenderer, String suffix, String lineSeparator) {
        void var1_1;
        void var3_3;
        ExtendedStackTraceElement extendedStackTraceElement;
        void var2_2;
        textRenderer.render((String)var2_2, sb, "Prefix");
        textRenderer.render("\tat ", sb, "At");
        extendedStackTraceElement.renderOn(sb, textRenderer);
        ThrowableProxyRenderer.renderSuffix(suffix, sb, textRenderer);
        var3_3.render(lineSeparator, (StringBuilder)var1_1, "Text");
    }

    /*
     * WARNING - void declaration
     */
    private static boolean ignoreElement(StackTraceElement element, List<String> ignorePackages) {
        if (ignorePackages != null) {
            Iterator iterator;
            String className = element.getClassName();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                String pkg = (String)iterator.next();
                if (!className.startsWith((String)var2_2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static void formatExtendedStackTraceTo(ThrowableProxy src, StringBuilder sb, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        void var3_3;
        void var2_2;
        ThrowableProxy throwableProxy;
        void var1_1;
        textRenderer.render(src.getName(), sb, "Name");
        textRenderer.render(": ", sb, "NameMessageSeparator");
        textRenderer.render(src.getMessage(), sb, "Message");
        ThrowableProxyRenderer.renderSuffix(suffix, sb, textRenderer);
        textRenderer.render(lineSeparator, sb, "Text");
        StackTraceElement[] causedTrace = src.getThrowable() != null ? src.getThrowable().getStackTrace() : null;
        ThrowableProxyRenderer.formatElements(sb, "", 0, causedTrace, src.getExtendedStackTrace(), ignorePackages, textRenderer, suffix, lineSeparator);
        ThrowableProxyRenderer.formatSuppressed(sb, TAB, src.getSuppressedProxies(), ignorePackages, textRenderer, suffix, lineSeparator);
        ThrowableProxyRenderer.formatCause((StringBuilder)var1_1, "", throwableProxy.getCauseProxy(), (List<String>)var2_2, (TextRenderer)var3_3, suffix, lineSeparator);
    }

    /*
     * WARNING - void declaration
     */
    static void formatCauseStackTrace(ThrowableProxy src, StringBuilder sb, List<String> ignorePackages, TextRenderer textRenderer, String suffix, String lineSeparator) {
        void var3_3;
        void var2_2;
        ThrowableProxy throwableProxy;
        void var1_1;
        ThrowableProxy causeProxy = src.getCauseProxy();
        if (causeProxy != null) {
            ThrowableProxyRenderer.formatWrapper(sb, causeProxy, ignorePackages, textRenderer, suffix, lineSeparator);
            sb.append(WRAPPED_BY_LABEL);
            ThrowableProxyRenderer.renderSuffix(suffix, sb, textRenderer);
        }
        ThrowableProxyRenderer.renderOn(src, sb, textRenderer);
        ThrowableProxyRenderer.renderSuffix(suffix, sb, textRenderer);
        textRenderer.render(lineSeparator, sb, "Text");
        ThrowableProxyRenderer.formatElements((StringBuilder)var1_1, "", 0, src.getStackTrace(), throwableProxy.getExtendedStackTrace(), (List<String>)var2_2, (TextRenderer)var3_3, suffix, lineSeparator);
    }

    /*
     * WARNING - void declaration
     */
    private static void renderOn(ThrowableProxy src, StringBuilder output, TextRenderer textRenderer) {
        ThrowableProxy throwableProxy;
        String msg = src.getMessage();
        textRenderer.render(throwableProxy.getName(), output, "Name");
        if (msg != null) {
            void var1_1;
            void var3_3;
            void var2_2;
            textRenderer.render(": ", output, "NameMessageSeparator");
            var2_2.render((String)var3_3, (StringBuilder)var1_1, "Message");
        }
    }
}

